/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.file;

import com.tridium.nd.file.BNiagaraFileDescriptor;
import com.tridium.nd.util.BSimpleMap;
import com.tridium.util.ThrowableUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BSimple;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BNiagaraFileImport
extends BNiagaraFileDescriptor {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraFileImport.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"file.png"), (BIcon)BIcon.std((String)"badges/import.png"));
    private static final Lexicon LEXICON = Lexicon.make(BNiagaraFileImport.class);
    private static final Set<FilePath> OPTIONAL_REMOTE_FILES = Collections.unmodifiableSet(Stream.of(new FilePath("^charts/defaultOptions.chart")).collect(Collectors.toSet()));
    private BOrdList failedOptionalImports = BOrdList.DEFAULT;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    protected void doFileExecute(BFileSpace remoteSpace) throws IOException {
        this.copyFilesFromRemoteToLocalSpace(remoteSpace, (BFileSpace)BFileSystem.INSTANCE);
    }

    public void copyFilesFromRemoteToLocalSpace(BFileSpace remoteSpace, BFileSpace localSpace) throws IOException {
        BSimpleMap map = this.getFiles();
        this.failedOptionalImports = BOrdList.DEFAULT;
        BOrdList failedExpectedImports = BOrdList.DEFAULT;
        IOException lastErr = null;
        for (BSimple localFile : map.list()) {
            BOrd remoteFileOrd = (BOrd)map.get(localFile);
            try {
                this.createAllFiles(remoteSpace, remoteFileOrd, localSpace, (BOrd)localFile);
            }
            catch (IOException err) {
                if (LOG.isLoggable(Level.FINE)) {
                    String msg = String.format("Unable to copy remote %s to local %s", map.get(localFile), localFile);
                    LOG.log(Level.FINE, msg, err);
                }
                if (remoteFileOrd != null) {
                    if (map.size() > 1) {
                        try {
                            OrdQuery[] ordQueries = remoteFileOrd.parse();
                            if (OPTIONAL_REMOTE_FILES.contains(ordQueries[ordQueries.length - 1])) {
                                this.failedOptionalImports = BOrdList.add((BOrdList)this.failedOptionalImports, (BOrd)remoteFileOrd);
                                continue;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    failedExpectedImports = BOrdList.add((BOrdList)failedExpectedImports, (BOrd)remoteFileOrd);
                }
                lastErr = err;
            }
        }
        if (lastErr != null) {
            StringJoiner sj = new StringJoiner("\n");
            failedExpectedImports.forEach(ord -> sj.add(ord.toString()));
            throw new LocalizableRuntimeException("niagaraDriver", "fileImport.fail", new Object[]{sj.toString(), ThrowableUtil.dumpToString((Throwable)lastErr, (int)1)}, (Throwable)lastErr);
        }
    }

    public void executeOk() {
        super.executeOk();
        if (!this.failedOptionalImports.equals((Object)BOrdList.DEFAULT)) {
            StringJoiner sj = new StringJoiner("\n");
            this.failedOptionalImports.forEach(ord -> sj.add(ord.toString()));
            this.setFaultCause(LEXICON.getText("fileImport.optional.fail", new Object[]{sj.toString()}));
        }
    }

    public void executeFail(Throwable ex) {
        if (ex instanceof Localizable) {
            this.executeFail(((Localizable)ex).toString(null));
        } else {
            super.executeFail(ex);
        }
    }
}

