/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BForceUpdateNiagaraPointsJob;
import com.tridium.nd.point.BINiagaraPointContainer;
import com.tridium.nd.point.BNiagaraProxyExt;
import java.util.ArrayList;
import java.util.List;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDeviceFolder;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="forceUpdateNiagaraProxyPoints", returnType="BOrd", flags=128)
public class BNiagaraStationFolder
extends BDeviceFolder
implements BINiagaraPointContainer {
    @Generated
    public static final Action forceUpdateNiagaraProxyPoints = BNiagaraStationFolder.newAction((int)128, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraStationFolder.class);

    @Generated
    public BOrd forceUpdateNiagaraProxyPoints() {
        return (BOrd)this.invoke(forceUpdateNiagaraProxyPoints, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void renamed(Property prop, String old, Context context) {
        super.renamed(prop, old, context);
        this.rebuildStationMap();
    }

    public void childParented(Property prop, BValue v, Context context) {
        super.childParented(prop, v, context);
        if (v instanceof BNiagaraStation || v instanceof BNiagaraStationFolder) {
            this.rebuildStationMap();
        }
    }

    public void childUnparented(Property prop, BValue v, Context context) {
        super.childUnparented(prop, v, context);
        if (v instanceof BNiagaraStation || v instanceof BNiagaraStationFolder) {
            this.rebuildStationMap();
        }
    }

    void rebuildStationMap() {
        try {
            BNiagaraNetwork network = (BNiagaraNetwork)this.getNetwork();
            network.rebuildStationMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AgentList getAgents(Context cx) {
        return BNiagaraNetwork.filterProvAgentList((BComponent)this, super.getAgents(cx));
    }

    @Override
    public List<BNiagaraProxyExt> getDescendantNiagaraProxyExts() {
        ArrayList<BNiagaraProxyExt> result = new ArrayList<BNiagaraProxyExt>();
        BNiagaraStationFolder.findNiagaraProxyExts((BComplex)this, result);
        return result;
    }

    private static void findNiagaraProxyExts(BComplex comp, List<BNiagaraProxyExt> list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(BNiagaraStation.TYPE)) {
                list.addAll(((BNiagaraStation)kid).getDescendantNiagaraProxyExts());
                continue;
            }
            if (!kid.getType().is(TYPE)) continue;
            BNiagaraStationFolder.findNiagaraProxyExts((BComplex)kid, list);
        }
    }

    public BOrd doForceUpdateNiagaraProxyPoints(Context cx) {
        return new BForceUpdateNiagaraPointsJob(this).submit(cx);
    }
}

