/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ux;

import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.install.installable.BInstallable;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.platform.qnx.BNtpServerQnx;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BProvisioningNiagaraRpcUtil
extends BSingleton {
    @Generated
    public static final BProvisioningNiagaraRpcUtil INSTANCE = new BProvisioningNiagaraRpcUtil();
    @Generated
    public static final Type TYPE = Sys.loadType(BProvisioningNiagaraRpcUtil.class);
    private static final Logger log = Logger.getLogger("provisioningNiagara");
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getDeviceId(String nwOrd, String deviceOrd, Context cx) throws PermissionException {
        BDeviceNetwork nw = (BDeviceNetwork)BOrd.make((String)nwOrd).get(null, cx);
        if (!nw.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to Device Network");
        }
        BDevice device = (BDevice)BOrd.make((String)deviceOrd).get((BObject)nw, cx);
        if (!device.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to Device");
        }
        BNetworkBatchAgent batchAgent = BNetworkBatchAgent.get((BDeviceNetwork)nw, (Context)cx);
        return batchAgent.getBatchDeviceId(device).toString(cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static JSONArray getDevices(String jobOrd, Context cx) throws PermissionException {
        BDeviceNetworkJob job = (BDeviceNetworkJob)BOrd.make((String)jobOrd).get(null, cx);
        if (!job.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to job");
        }
        BDevice[] devices = job.getDevices();
        if (devices.length == 0) {
            return new JSONArray();
        }
        return Arrays.stream(devices).map(device -> BProvisioningNiagaraRpcUtil.toJSONObject(job, device, cx)).collect(BProvisioningNiagaraRpcUtil.toJSONArray());
    }

    private static JSONObject toJSONObject(BDeviceNetworkJob job, BDevice device, Context cx) {
        BNetworkBatchAgent batchAgent = BNetworkBatchAgent.get((BDeviceNetwork)job.getNetwork(), (Context)cx);
        JSONObject deviceObject = new JSONObject();
        deviceObject.put("navOrdStr", (Object)device.getNavOrd().toString());
        deviceObject.put("deviceId", (Object)batchAgent.getBatchDeviceId(device).toString());
        try {
            deviceObject.put("iconEnc", (Object)device.getIcon().encodeToString());
        }
        catch (IOException ex) {
            log.log(Level.INFO, "Invalid device icon for " + device.getName(), ex);
        }
        return deviceObject;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static JSONArray getNtpServers(String serverString, Context cx) {
        if (serverString.isEmpty()) {
            return new JSONArray();
        }
        String[] serverArray = serverString.split(";");
        ArrayList<BNtpServerQnx> servers = new ArrayList<BNtpServerQnx>();
        for (String server2 : serverArray) {
            servers.add(new BNtpServerQnx(server2));
        }
        return servers.stream().map(server -> BProvisioningNiagaraRpcUtil.toServerJSONObject(server)).collect(BProvisioningNiagaraRpcUtil.toJSONArray());
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static JSONArray getCleanDistFiles(Context cx) {
        BIFile[] files;
        JSONArray fileList = new JSONArray();
        if (BUser.getCurrentAuthenticatedUser() != cx.getUser()) {
            throw new PermissionException(LEX.getText("ProvisioningNiagaraRpcUtil.getCleanDistFiles.notCurrentLoggedInUser", new Object[]{cx}));
        }
        BDirectory cleanDistDir = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("!cleandist"));
        if (cleanDistDir == null) {
            throw new PermissionException(LEX.getText("ProvisioningNiagaraRpcUtil.getCleanDistFiles.directoryDoesNotExist", new Object[]{cx}));
        }
        if (!cleanDistDir.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException(LEX.getText("ProvisioningNiagaraRpcUtil.getCleanDistFiles.insufficientPrivileges", new Object[]{cx}));
        }
        for (BIFile file : files = cleanDistDir.listFiles()) {
            JSONObject fileEntry = new JSONObject();
            fileEntry.put("name", (Object)file.getFileName());
            fileEntry.put("modified", (Object)file.getLastModified());
            fileEntry.put("size", file.getSize());
            fileEntry.put("navOrd", (Object)file.getNavOrd());
            fileList.put((Object)fileEntry);
        }
        return fileList;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getInstallable(String navOrd, Context cx) throws Exception {
        BIFile distFile;
        Pattern fileMatcher = Pattern.compile("(.*)file:!cleandist(.*)");
        Pattern fileTrim = Pattern.compile("local:|", 16);
        if (!fileMatcher.matcher(navOrd).matches()) {
            throw new PermissionException(LEX.getText("ProvisioningNiagaraRpcUtil.getCleanDistFiles.insufficientPrivileges", new Object[]{cx}));
        }
        try {
            distFile = (BIFile)BOrd.make((String)navOrd).get();
        }
        catch (Exception e) {
            throw new PermissionException(LEX.getText("ProvisioningNiagaraRpcUtil.getCleanDistFiles.insufficientPrivileges", new Object[]{cx}));
        }
        navOrd = fileTrim.matcher(navOrd).replaceAll("");
        if (!distFile.getNavOrd().encodeToString().matches("(.*)" + navOrd)) {
            throw new PermissionException(LEX.getText("ProvisioningNiagaraRpcUtil.getCleanDistFiles.insufficientPrivileges", new Object[]{cx}));
        }
        if (!distFile.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException(LEX.getText("ProvisioningNiagaraRpcUtil.getCleanDistFiles.insufficientPrivileges", new Object[]{cx}));
        }
        BInstallable installable = BInstallable.make((BIFile)distFile);
        String installableEncoded = BsonEncoderPlugin.marshal((BValue)installable);
        return installableEncoded;
    }

    private static Collector<JSONObject, JSONArray, JSONArray> toJSONArray() {
        return Collector.of(JSONArray::new, JSONArray::put, JSONArray::put, new Collector.Characteristics[0]);
    }

    private static JSONObject toServerJSONObject(BNtpServerQnx server) {
        JSONObject serverObject = new JSONObject();
        serverObject.put("useBurst", server.getUseBurst());
        serverObject.put("serverPreferred", server.getServerPreferred());
        serverObject.put("peerMode", (Object)server.getPeerMode().getTag());
        serverObject.put("address", (Object)server.getAddress());
        serverObject.put("maxPollInterval", server.getMaxPollInterval());
        serverObject.put("minPollInterval", server.getMinPollInterval());
        return serverObject;
    }
}

