/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import com.tridium.ldap.BLdapConfig;
import java.security.PrivilegedAction;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.util.Lexicon;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GSSDelegCredAction
implements PrivilegedAction<Object> {
    private String serverPrincipal;
    private FoxSession session;
    private Logger logger = Logger.getLogger("ldap");

    public GSSDelegCredAction(String serverPrincipal, FoxSession session) {
        this.serverPrincipal = serverPrincipal;
        this.session = session;
    }

    @Override
    public Object run() {
        Lexicon lex = Lexicon.make((String)"ldap");
        this.logger.fine(lex.getText("kerberos.gss.delegating"));
        boolean serverExpectingToken = true;
        try {
            Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
            GSSManager manager = GSSManager.getInstance();
            GSSName serverName = manager.createName(this.serverPrincipal, null);
            serverName = serverName.canonicalize(krb5Oid);
            GSSContext secContext = manager.createContext(serverName, krb5Oid, null, 0);
            secContext.requestCredDeleg(true);
            secContext.requestMutualAuth(true);
            byte[] token = new byte[]{};
            boolean established = false;
            while (!established) {
                Objects.requireNonNull(token);
                token = secContext.initSecContext(token, 0, token.length);
                established = secContext.isEstablished();
                boolean bl = serverExpectingToken = serverExpectingToken && !established;
                if (serverExpectingToken) {
                    serverExpectingToken = false;
                    if (token != null) {
                        FoxMessage message = new FoxMessage();
                        message.add("token", token);
                        message.add("expectingResponse", !established);
                        this.session.setState("client.tune sendToken");
                        this.session.sendTuning("clientToken", message);
                    } else {
                        GSSDelegCredAction.sendErrorToken(this.session);
                    }
                }
                if (established) continue;
                this.session.setState("client.tune receiveToken");
                FoxMessage gssToken = this.session.receiveTuning("serverToken");
                token = gssToken.getBlob("token", null);
                boolean validToken = token != null && token.length != 0;
                serverExpectingToken = gssToken.getBoolean("expectingResponse", validToken);
                if (validToken) continue;
                this.logger.warning(lex.getText("kerberos.gss.noToken"));
                return null;
            }
            this.logger.fine(lex.getText("kerberos.gss.contextEstablished", new Object[]{secContext.getSrcName(), secContext.getTargName()}));
        }
        catch (Exception e) {
            if (serverExpectingToken) {
                GSSDelegCredAction.sendErrorToken(this.session);
            }
            BLdapConfig.logException(lex.getText("kerberos.gss.couldNotDelegate"), e, Level.SEVERE);
        }
        return null;
    }

    public static void sendErrorToken(FoxSession session) {
        FoxMessage login = new FoxMessage();
        byte[] errToken = new byte[]{};
        login.add("token", errToken);
        login.add("expectingResponse", false);
        session.setState("client.tune sendLogin");
        try {
            session.sendTuning("clientToken", login);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

