/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import java.io.EOFException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.util.Lexicon;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

class AcquireCredentialsAction
implements PrivilegedExceptionAction<Object> {
    private Logger logger = Logger.getLogger("ldap");
    protected static final Lexicon lex = Lexicon.make((String)"ldap");
    private FoxSession session;

    public AcquireCredentialsAction(FoxSession session) {
        this.session = session;
    }

    @Override
    public Object run() throws Exception {
        GSSCredential cred;
        boolean clientExpectingToken = true;
        try {
            this.logger.fine(lex.getText("ldap.kerberos.acquireFoxCreds"));
            GSSManager manager = GSSManager.getInstance();
            GSSContext context = manager.createContext((GSSCredential)null);
            boolean established = false;
            while (!established) {
                this.session.setState("server.tune receiveToken");
                FoxMessage clientToken = this.session.receiveTuning("clientToken");
                byte[] token = clientToken.getBlob("token");
                boolean validToken = token != null && token.length != 0;
                clientExpectingToken = clientToken.getBoolean("expectingResponse", validToken);
                if (!validToken) {
                    throw new Exception(lex.getText("ldap.error.noTokenFromClient"));
                }
                token = context.acceptSecContext(token, 0, token.length);
                established = context.isEstablished();
                if (!clientExpectingToken) continue;
                clientExpectingToken = false;
                if (token != null) {
                    FoxMessage outMessage = new FoxMessage();
                    outMessage.add("token", token);
                    outMessage.add("expectingResponse", !established);
                    this.session.setState("server.tune sendToken");
                    this.session.sendTuning("serverToken", outMessage);
                    continue;
                }
                AcquireCredentialsAction.sendErrorToken(this.session);
            }
            cred = context.getDelegCred();
            if (cred == null) {
                throw new Exception(lex.getText("ldap.error.couldNotAcquireFoxCreds"));
            }
        }
        catch (EOFException eof) {
            this.logger.fine(lex.getText("ldap.warning.acquireCredsEof"));
            return null;
        }
        catch (Exception e) {
            if (clientExpectingToken) {
                AcquireCredentialsAction.sendErrorToken(this.session);
            }
            throw e;
        }
        this.logger.fine(lex.getText("ldap.kerberos.acquiredFoxCreds"));
        return new BKerberosCredentials(cred);
    }

    public static void sendErrorToken(FoxSession session) {
        FoxMessage login = new FoxMessage();
        byte[] errToken = new byte[]{};
        login.add("token", errToken);
        login.add("expectingResponse", false);
        session.setState("server.tune sendLogin");
        try {
            session.sendTuning("serverToken", login);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

