/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap;

import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.NiagaraLoginConfiguration;
import com.tridium.ldap.BGlobalLdapConfiguration;
import com.tridium.ldap.BLdapTypeConfig;
import com.tridium.ldap.LdapLoginModule;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserPrototypeMergePolicy;
import javax.baja.user.IHasPrototypeMergePolicy;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

@NiagaraType(agent={@AgentOn(types={"baja:AuthenticationScheme"})})
@NiagaraProperties(value={@NiagaraProperty(name="config", type="BLdapTypeConfig", defaultValue="new BLdapTypeConfig()"), @NiagaraProperty(name="prototypeMergePolicy", type="BUserPrototypeMergePolicy", defaultValue="new BUserPrototypeMergePolicy()")})
public class BLdapAuthenticationScheme
extends BAuthenticationScheme
implements IHasPrototypeMergePolicy {
    @Generated
    public static final Property config = BLdapAuthenticationScheme.newProperty((int)0, (BValue)new BLdapTypeConfig(), null);
    @Generated
    public static final Property prototypeMergePolicy = BLdapAuthenticationScheme.newProperty((int)0, (BValue)new BUserPrototypeMergePolicy(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLdapAuthenticationScheme.class);
    public static final String SCHEME_NAME = "n4LDAP";
    public static final Logger LOG = Logger.getLogger("ldap");
    private Configuration configuration;

    @Generated
    public BLdapTypeConfig getConfig() {
        return (BLdapTypeConfig)this.get(config);
    }

    @Generated
    public void setConfig(BLdapTypeConfig v) {
        this.set(config, (BValue)v, null);
    }

    @Generated
    public BUserPrototypeMergePolicy getPrototypeMergePolicy() {
        return (BUserPrototypeMergePolicy)this.get(prototypeMergePolicy);
    }

    @Generated
    public void setPrototypeMergePolicy(BUserPrototypeMergePolicy v) {
        this.set(prototypeMergePolicy, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        if (this.isRunning()) {
            BAuthenticationService authnService = BAuthenticationService.getService();
            if (this.getParent() == authnService.getAuthenticationSchemes()) {
                this.getComponentSpace().enableMixIn(BGlobalLdapConfiguration.TYPE);
            }
        }
    }

    private void fwStopped() {
        BAuthenticationService authnService;
        BLdapAuthenticationScheme[] ldapSchemes;
        if (!this.isRunning() && (ldapSchemes = (BLdapAuthenticationScheme[])(authnService = BAuthenticationService.getService()).getAuthenticationSchemes().getChildren(BLdapAuthenticationScheme.class)).length == 1 && ldapSchemes[0] == this) {
            LOG.finer("Removing last LDAP Authentication Scheme, disabling BGlobalLdapConfigurationMixIn");
            this.getComponentSpace().disableMixIn(BGlobalLdapConfiguration.TYPE);
        }
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public Configuration getLoginConfiguration() {
        HashMap<String, BLdapTypeConfig> options = new HashMap<String, BLdapTypeConfig>();
        options.put("config", this.getConfig());
        if (this.configuration == null) {
            this.configuration = new NiagaraLoginConfiguration(LdapLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        }
        return this.configuration;
    }

    public boolean supportsRemoteUsers() {
        return true;
    }

    public final BAbstractAuthenticator getDefaultAuthenticator() {
        return new BPasswordCache();
    }
}

