/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.smartKey.comm.req;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridiumx.smartKey.SmartKeyLexicon;
import com.tridiumx.smartKey.comm.BSmartKeyReceiver;
import com.tridiumx.smartKey.comm.req.BSmartKeyReadKeysRequest;
import com.tridiumx.smartKey.comm.rsp.BSmartKeyReadWriteResponse;
import com.tridiumx.smartKey.enums.BSmartKeyControlEnum;
import com.tridiumx.smartKey.identify.BSmartKeyDeviceId;
import com.tridiumx.smartKey.identify.BSmartKeyWriteControlParams;
import com.tridiumx.smartKey.point.BSmartKeyBeeperPoint;
import com.tridiumx.smartKey.point.BSmartKeyProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSmartKeyWriteControlRequest
extends BDdfWriteRequest {
    @Generated
    public static final Type TYPE = Sys.loadType(BSmartKeyWriteControlRequest.class);
    public static final int NO_CHANGE = 0;
    public static final int BUZZER_OFF = 0;
    public static final int BUZZER_CONTINUOUS = 255;
    public static final int SMART_KEY_ON = 1;
    public static final int SMART_KEY_OFF = 2;
    public static final int BUZZER_CONTROL_LOC = 16;
    public static final int BACKLIGHT_CONTROL_LOC = 17;
    public static final int CRC_LOC = 19;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public byte[] toByteArray() {
        BSmartKeyDeviceId deviceId = (BSmartKeyDeviceId)this.getDeviceId();
        int smartKeyId = deviceId.getSmartKeyId();
        byte[] x80Request = BSmartKeyReadKeysRequest.toByteArray(smartKeyId);
        this.fillBuzzerAndBacklightControlBytes(x80Request);
        this.fillCrcByte(x80Request);
        return x80Request;
    }

    private void fillCrcByte(byte[] x80Request) {
        x80Request[19] = (byte)BSmartKeyReceiver.computeChecksum(x80Request, x80Request.length);
    }

    private void fillBuzzerAndBacklightControlBytes(byte[] x80Request) {
        int buzzerControl = 0;
        int lcdBacklightControl = 0;
        int keypadBacklightControl = 0;
        boolean foundKeypadPoint = false;
        boolean foundBacklightPoint = false;
        boolean foundBuzzerPoint = false;
        IDdfWritable[] writableSource = this.getWritableSource();
        if (writableSource != null) {
            for (int i = 0; i < writableSource.length; ++i) {
                if (writableSource[i].getWriteValue().getStatus().isNull()) continue;
                BSmartKeyProxyExt smartKeyProxy = (BSmartKeyProxyExt)writableSource[i];
                BSmartKeyWriteControlParams smartKeyWriteControlParams = (BSmartKeyWriteControlParams)smartKeyProxy.getWriteParameters();
                BSmartKeyControlEnum smartKeyControl = smartKeyWriteControlParams.getControl();
                if (smartKeyControl == BSmartKeyControlEnum.lcdBacklight) {
                    if (foundBacklightPoint) {
                        throw new BajaRuntimeException(SmartKeyLexicon.onlyOneBacklightPointAllowed(smartKeyProxy));
                    }
                    lcdBacklightControl = this.getRawValue(smartKeyProxy, smartKeyControl);
                    foundBacklightPoint = true;
                    continue;
                }
                if (smartKeyControl == BSmartKeyControlEnum.keypadBacklight) {
                    if (foundKeypadPoint) {
                        throw new BajaRuntimeException(SmartKeyLexicon.onlyOneKeypadLightingPointAllowed(smartKeyProxy));
                    }
                    keypadBacklightControl = this.getRawValue(smartKeyProxy, smartKeyControl);
                    foundKeypadPoint = true;
                    continue;
                }
                if (smartKeyControl != BSmartKeyControlEnum.buzzer) continue;
                if (foundBuzzerPoint) {
                    throw new BajaRuntimeException(SmartKeyLexicon.onlyOneBuzzerPointAllowed(smartKeyProxy));
                }
                BControlPoint controlPoint = smartKeyProxy.getParentPoint();
                buzzerControl = controlPoint instanceof BSmartKeyBeeperPoint ? ((BSmartKeyBeeperPoint)controlPoint).getBeepCount() : this.getRawValue(smartKeyProxy, smartKeyControl);
                foundBuzzerPoint = true;
            }
        }
        x80Request[16] = (byte)buzzerControl;
        x80Request[17] = (byte)((lcdBacklightControl & 3) << 6 | (keypadBacklightControl & 3) << 4);
    }

    public BIDdfResponse processReceive(IDdfDataFrame receiveFrame) throws DdfResponseException {
        return new BSmartKeyReadWriteResponse(receiveFrame);
    }

    protected int getRawValue(BSmartKeyProxyExt ddfWritable, BSmartKeyControlEnum control) {
        BStatusValue writeValue = ddfWritable.getWriteValue();
        if (writeValue instanceof BStatusNumeric) {
            return (int)Math.round(((BStatusNumeric)writeValue).getNumeric());
        }
        if (writeValue instanceof BStatusEnum) {
            return ((BStatusEnum)writeValue).getEnum().getOrdinal();
        }
        if (writeValue instanceof BStatusBoolean) {
            if (control == BSmartKeyControlEnum.lcdBacklight || control == BSmartKeyControlEnum.keypadBacklight) {
                return ((BStatusBoolean)writeValue).getBoolean() ? 1 : 2;
            }
            if (control == BSmartKeyControlEnum.buzzer) {
                return ((BStatusBoolean)writeValue).getBoolean() ? 255 : 0;
            }
            return ((BStatusBoolean)writeValue).getBoolean() ? 1 : 0;
        }
        if (writeValue instanceof BStatusString) {
            String s = ((BStatusString)writeValue).getValue();
            try {
                return (int)Math.round(Double.parseDouble(s));
            }
            catch (NumberFormatException nfe1) {
                try {
                    int radix = ddfWritable.getFacets().geti("radix", 10);
                    return (int)Long.parseLong(s, radix);
                }
                catch (NumberFormatException nfe2) {
                    String trueText;
                    BEnumRange range = (BEnumRange)ddfWritable.getFacets().get("range", null);
                    if (range != null) {
                        try {
                            return range.tagToOrdinal(s);
                        }
                        catch (InvalidEnumException invalidEnumException) {
                            // empty catch block
                        }
                    }
                    if (s.equals(trueText = ddfWritable.getFacets().gets("trueText", "True"))) {
                        if (control == BSmartKeyControlEnum.lcdBacklight || control == BSmartKeyControlEnum.keypadBacklight) {
                            return 1;
                        }
                        if (control == BSmartKeyControlEnum.buzzer) {
                            return 255;
                        }
                        return 1;
                    }
                    String falseText = ddfWritable.getFacets().gets("falseText", "False");
                    if (s.equals(falseText)) {
                        if (control == BSmartKeyControlEnum.lcdBacklight || control == BSmartKeyControlEnum.keypadBacklight) {
                            return 2;
                        }
                        if (control == BSmartKeyControlEnum.buzzer) {
                            return 0;
                        }
                        return 0;
                    }
                    throw new BajaRuntimeException(DdfDefaultCommLexicon.unsupportedStringFormat((String)ddfWritable.toString(), (String)s));
                }
            }
        }
        throw new BajaRuntimeException(DdfDefaultCommLexicon.unsupportedStringFormat((String)ddfWritable.toString(), (String)ddfWritable.getWriteValue().toString()));
    }
}

