/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.point;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.BAndoverNetwork;
import com.tridium.andoverAC256.enums.BAndoverReadEnabledStateEnum;
import com.tridium.andoverAC256.enums.BAndoverSendDisableEnum;
import com.tridium.andoverAC256.messages.AndoverDataResponse;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.andoverAC256.point.BAndoverPointDeviceExt;
import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.basicdriver.util.BasicWriteAsyncRequest;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="assignedName", type="String", defaultValue=""), @NiagaraProperty(name="rawValue", type="String", defaultValue="", flags=7), @NiagaraProperty(name="pointOrigin", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="pointNotes", type="String", defaultValue=""), @NiagaraProperty(name="sendDisableCommand", type="BAndoverSendDisableEnum", defaultValue="BAndoverSendDisableEnum.onEveryWrite"), @NiagaraProperty(name="readEnabledState", type="BAndoverReadEnabledStateEnum", defaultValue="BAndoverReadEnabledStateEnum.onEveryRead"), @NiagaraProperty(name="nativeEnableState", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal")})
public class BAndoverProxyExt
extends BBasicProxyExt
implements BIBasicPollable,
AndoverMessageConst {
    @Generated
    public static final Property assignedName = BAndoverProxyExt.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property rawValue = BAndoverProxyExt.newProperty((int)7, (String)"", null);
    @Generated
    public static final Property pointOrigin = BAndoverProxyExt.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property pointNotes = BAndoverProxyExt.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property sendDisableCommand = BAndoverProxyExt.newProperty((int)0, (BValue)BAndoverSendDisableEnum.onEveryWrite, null);
    @Generated
    public static final Property readEnabledState = BAndoverProxyExt.newProperty((int)0, (BValue)BAndoverReadEnabledStateEnum.onEveryRead, null);
    @Generated
    public static final Property nativeEnableState = BAndoverProxyExt.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property pollFrequency = BAndoverProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAndoverProxyExt.class);
    protected boolean overflow = false;
    boolean enabledStateHasBeenRead = false;
    boolean disableCommandHasBeenSent = false;

    @Generated
    public String getAssignedName() {
        return this.getString(assignedName);
    }

    @Generated
    public void setAssignedName(String v) {
        this.setString(assignedName, v, null);
    }

    @Generated
    public String getRawValue() {
        return this.getString(rawValue);
    }

    @Generated
    public void setRawValue(String v) {
        this.setString(rawValue, v, null);
    }

    @Generated
    public String getPointOrigin() {
        return this.getString(pointOrigin);
    }

    @Generated
    public void setPointOrigin(String v) {
        this.setString(pointOrigin, v, null);
    }

    @Generated
    public String getPointNotes() {
        return this.getString(pointNotes);
    }

    @Generated
    public void setPointNotes(String v) {
        this.setString(pointNotes, v, null);
    }

    @Generated
    public BAndoverSendDisableEnum getSendDisableCommand() {
        return (BAndoverSendDisableEnum)this.get(sendDisableCommand);
    }

    @Generated
    public void setSendDisableCommand(BAndoverSendDisableEnum v) {
        this.set(sendDisableCommand, (BValue)v, null);
    }

    @Generated
    public BAndoverReadEnabledStateEnum getReadEnabledState() {
        return (BAndoverReadEnabledStateEnum)this.get(readEnabledState);
    }

    @Generated
    public void setReadEnabledState(BAndoverReadEnabledStateEnum v) {
        this.set(readEnabledState, (BValue)v, null);
    }

    @Generated
    public boolean getNativeEnableState() {
        return this.getBoolean(nativeEnableState);
    }

    @Generated
    public void setNativeEnableState(boolean v) {
        this.setBoolean(nativeEnableState, v, null);
    }

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAndoverProxyExt() {
    }

    public BAndoverProxyExt(String assignedName) {
        if (assignedName != null && assignedName != "") {
            this.setAssignedName(assignedName);
        }
    }

    public void poll() {
        if (this.isTraceOn()) {
            this.getAcLog().trace(this.getName() + " :poll for " + this.getAssignedName());
        }
        if (!this.isValid()) {
            return;
        }
        if (this.device().getCurrentDomain() != 0 && this.device().setDomain(0) != 0) {
            this.readFail("domain not set to 0 on read data attempt");
            return;
        }
        if (this.needToReadEnabledState()) {
            AndoverGenericRequest disReq = new AndoverGenericRequest("P DIS " + this.getAssignedName() + "\n", 12);
            AndoverStringResponse disRsp = (AndoverStringResponse)this.network().sendSync(disReq);
            if (disRsp != null) {
                if (!disRsp.isError()) {
                    this.setNativeEnableState(disRsp.getMessage().indexOf("Enabled") != -1);
                    this.enabledStateHasBeenRead = true;
                }
            } else {
                this.device().ping();
            }
        }
        AndoverGenericRequest req = new AndoverGenericRequest("P " + this.getAssignedName() + "\n", 4);
        AndoverDataResponse rsp = (AndoverDataResponse)this.network().sendSync(req);
        if (rsp != null) {
            if (!rsp.isError()) {
                this.getAcLog().trace("Read Succeeded!");
                this.setValue(rsp);
            } else {
                this.getAcLog().trace("Read Response is Error!");
                this.readFail(rsp.getError());
            }
        } else {
            this.getAcLog().trace("Read Failed - no response!");
            this.readFail("No Response");
            this.device().ping();
        }
    }

    public boolean isValid() {
        return this.getAssignedName() != null | this.getAssignedName().trim() != "";
    }

    public void setValue(AndoverDataResponse rsp) {
    }

    public void started() throws Exception {
        super.started();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(assignedName)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
            this.enabledStateHasBeenRead = false;
            this.disableCommandHasBeenSent = false;
        }
    }

    public boolean sendCommand(String command) {
        AndoverGenericRequest req = new AndoverGenericRequest(command, 12);
        AndoverStringResponse rsp = (AndoverStringResponse)this.network().sendSync(req);
        if (rsp == null || rsp.isError()) {
            if (this.isTraceOn()) {
                this.getAcLog().error("command not successful: " + command);
            }
            if (rsp == null) {
                this.device().ping();
            }
            return false;
        }
        if (this.isTraceOn()) {
            this.getAcLog().trace(rsp.toString());
        }
        return true;
    }

    public boolean write(Context cx) throws Exception {
        if (this.getMode() != BReadWriteMode.readonly) {
            BStatusValue out = this.getWriteValue();
            BBasicNetwork network = (BBasicNetwork)this.getNetwork();
            if (out.getStatus().isNull()) {
                try {
                    network.postWrite(new Runnable(){

                        @Override
                        public void run() {
                            BAndoverProxyExt.this.doAuto();
                        }
                    });
                }
                catch (Exception e) {
                    this.writeFail("posting Enable command failed" + e);
                    network.getLog().error(this.getSlotPath().toString() + "post Auto failed", (Throwable)e);
                }
            } else {
                if (network.getLog().isTraceOn()) {
                    network.getLog().trace("Write <" + this + "> " + out);
                }
                try {
                    network.postWrite((Runnable)new BasicWriteAsyncRequest((BBasicProxyExt)this, out));
                }
                catch (Exception e) {
                    this.writeFail("posting Write Failed," + e);
                    network.getLog().error("Could not post write for " + this.getParent().getName(), (Throwable)e);
                }
            }
        }
        return false;
    }

    public void doAuto() {
        AndoverGenericRequest disReq = new AndoverGenericRequest("EN " + this.getAssignedName() + "\n", 12);
        AndoverStringResponse disRsp = (AndoverStringResponse)this.network().sendSync(disReq);
        if (disRsp != null && !disRsp.isError()) {
            this.setNativeEnableState(true);
            this.enabledStateHasBeenRead = true;
        }
    }

    public void doWrite(BStatusValue out) {
        if (out.getStatus().isNull()) {
            // empty if block
        }
        if (out == null) {
            this.updateOutput(this.getWriteValue());
        } else {
            this.updateOutput(out);
        }
        if (this.getParentPoint().isSubscribed()) {
            this.poll();
        }
    }

    private boolean updateOutput(BStatusValue out) {
        if (this.needToSendDisableCommand() && this.sendCommand("DIS " + this.getAssignedName() + "\n")) {
            this.disableCommandHasBeenSent = true;
        }
        String dataOut = null;
        if (out instanceof BStatusBoolean) {
            boolean bValue = ((BStatusBoolean)out).getValue();
            if (bValue) {
                dataOut = "ON";
            }
            if (!bValue) {
                dataOut = "OFF";
            }
        } else if (out instanceof BStatusNumeric) {
            float fValue = (float)((BStatusNumeric)out).getValue();
            Float value = Float.valueOf(fValue);
            dataOut = this.formatFloatString(value);
        } else if (out instanceof BStatusString) {
            dataOut = ((BStatusString)out).getValue();
        } else if (out instanceof BStatusEnum) {
            dataOut = Integer.toString(((BStatusEnum)out).getEnum().getOrdinal());
        } else {
            this.writeFail("unsupported data type");
            return false;
        }
        if (dataOut == null) {
            this.writeFail("cannot write null to device");
            return false;
        }
        AndoverGenericRequest req = new AndoverGenericRequest("MOD " + dataOut + " " + this.getAssignedName() + "\n", 12);
        AndoverStringResponse resp = (AndoverStringResponse)this.network().sendSync(req);
        if (resp == null) {
            this.writeFail("device time out");
            this.device().ping();
            return false;
        }
        if (resp.isError()) {
            this.writeFail(resp.getErrorMsg());
            return false;
        }
        this.writeOk(out);
        return true;
    }

    public Type getDeviceExtType() {
        return BAndoverPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void readSubscribed(Context cx) throws Exception {
        if (this.isTraceOn()) {
            this.getAcLog().trace(this + ".readSubscribed() on " + this);
        }
        this.enabledStateHasBeenRead = false;
        this.network().getPollScheduler().subscribe((BIPollable)this);
    }

    public void readUnsubscribed(Context cx) throws Exception {
        if (this.isTraceOn()) {
            this.getAcLog().trace(this + ".readUnsubscribed() on " + this);
        }
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
    }

    public void writeData(BStatusValue out) {
        this.doWrite(out);
    }

    protected String formatFloatString(Float value) {
        int intValue = value.intValue();
        float floatValue = value.floatValue();
        String floatString = value.toString();
        if (intValue > 9999) {
            this.overflow = true;
            return "9999";
        }
        if (intValue < -9999) {
            this.overflow = true;
            return "-9999";
        }
        this.overflow = false;
        if (Math.abs(intValue) >= 1000) {
            intValue = Math.round(floatValue);
            Integer tempInt = intValue;
            return tempInt.toString();
        }
        if (Math.abs(intValue) >= 100) {
            intValue = Math.round(floatValue * 10.0f);
            Integer tempInt = intValue;
            floatString = tempInt.toString();
            floatString = floatString.substring(0, floatString.length() - 1) + "." + floatString.substring(floatString.length() - 1, floatString.length());
            return floatString;
        }
        if (Math.abs(intValue) >= 10) {
            intValue = Math.round(floatValue * 100.0f);
            Integer tempInt = intValue;
            floatString = tempInt.toString();
            floatString = floatString.substring(0, floatString.length() - 2) + "." + floatString.substring(floatString.length() - 2, floatString.length());
            return floatString;
        }
        if (Math.abs(intValue) > 0) {
            intValue = Math.round(floatValue * 1000.0f);
            Integer tempInt = intValue;
            floatString = tempInt.toString();
            floatString = floatString.substring(0, floatString.length() - 3) + "." + floatString.substring(floatString.length() - 3, floatString.length());
            return floatString;
        }
        intValue = Math.round(floatValue * 10000.0f);
        Integer tempInt = intValue;
        if (tempInt == 0) {
            return "0";
        }
        floatString = tempInt.toString();
        int length = floatString.length();
        switch (length) {
            case 1: {
                floatString = "0.000" + floatString;
                break;
            }
            case 2: {
                if (floatValue < 0.0f) {
                    floatString = "-.000" + floatString.substring(1);
                    break;
                }
                floatString = "0.00" + floatString;
                break;
            }
            case 3: {
                if (floatValue < 0.0f) {
                    floatString = "-.00" + floatString.substring(1);
                    break;
                }
                floatString = "0.0" + floatString;
                break;
            }
            case 4: {
                if (floatValue < 0.0f) {
                    floatString = "-.0" + floatString.substring(1);
                    break;
                }
                floatString = "0." + floatString;
                break;
            }
            case 5: {
                floatString = "-." + floatString.substring(1);
                break;
            }
        }
        return floatString;
    }

    public boolean needToSendDisableCommand() {
        if (this.getSendDisableCommand() == BAndoverSendDisableEnum.never) {
            return false;
        }
        if (this.getSendDisableCommand() == BAndoverSendDisableEnum.onEveryWrite) {
            return true;
        }
        if (this.getSendDisableCommand() == BAndoverSendDisableEnum.onlyOnFirstWrite) {
            return !this.disableCommandHasBeenSent;
        }
        return true;
    }

    public boolean needToReadEnabledState() {
        if (this.getReadEnabledState() == BAndoverReadEnabledStateEnum.never) {
            return false;
        }
        if (this.getReadEnabledState() == BAndoverReadEnabledStateEnum.onEveryRead) {
            return true;
        }
        if (this.getReadEnabledState() == BAndoverReadEnabledStateEnum.onlyOnFirstRead) {
            return !this.enabledStateHasBeenRead;
        }
        return true;
    }

    protected BAndoverDevice device() {
        return (BAndoverDevice)this.getDevice();
    }

    protected BAndoverNetwork network() {
        return this.device().andoverNetwork();
    }

    protected boolean isTraceOn() {
        return this.getAcLog().isTraceOn();
    }

    protected Log getAcLog() {
        return this.device().andoverNetwork().getAcLog();
    }
}

