/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.point;

import com.tridium.andoverAC256.messages.AndoverDataResponse;
import com.tridium.andoverAC256.point.BAndoverProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAndoverEnumProxyExt
extends BAndoverProxyExt {
    @Generated
    public static final Type TYPE = Sys.loadType(BAndoverEnumProxyExt.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAndoverEnumProxyExt() {
        super("");
    }

    public BAndoverEnumProxyExt(String assignedName) {
        super(assignedName);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BEnumPoint;
    }

    @Override
    public void setValue(AndoverDataResponse rsp) {
        BStatusEnum sv = (BStatusEnum)this.getReadValue().newCopy();
        try {
            sv = this.parseEnum(rsp.getStringValue());
        }
        catch (NumberFormatException e) {
            this.readFail(e.getMessage());
            return;
        }
        sv.setStatusOverridden(!this.getNativeEnableState());
        this.readOk((BStatusValue)sv);
        this.setRawValue(rsp.getStringValue());
    }

    private BEnum getEnum(String text, BFacets facets) throws NumberFormatException {
        if (facets != null) {
            try {
                BEnumRange range = (BEnumRange)facets.get("range");
                BEnum myEnum = range.get(text);
                return myEnum;
            }
            catch (InvalidEnumException e) {
                throw new NumberFormatException("answer does not match an enum tag");
            }
        }
        throw new NumberFormatException("No Enum Defined");
    }

    private BStatusEnum parseEnum(String valStr) throws NumberFormatException {
        BStatusEnum sv = (BStatusEnum)this.getReadValue().newCopy();
        try {
            BDouble value = BDouble.make((double)this.stringToNumeric(valStr));
            sv = (BStatusEnum)this.getReadValue().newCopy();
            BDynamicEnum en = sv.getValue();
            sv.setValue(en.getRange().get((int)value.getDouble()));
        }
        catch (NumberFormatException e) {
            BEnum myEnum = this.getEnum(valStr, ((BControlPoint)this.getParent()).getFacets());
            sv.setValue(myEnum);
        }
        return sv;
    }

    private double stringToNumeric(String valStr) throws NumberFormatException {
        try {
            int i = Integer.parseInt(valStr);
            return i;
        }
        catch (NumberFormatException i) {
            try {
                double d = Double.parseDouble(valStr);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                if (valStr.equalsIgnoreCase("On")) {
                    return 1.0;
                }
                if (valStr.equalsIgnoreCase("-On")) {
                    return -1.0;
                }
                if (valStr.equalsIgnoreCase("Off")) {
                    return 0.0;
                }
                throw new NumberFormatException("not a number");
            }
        }
    }
}

