/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.job;

import com.tridium.andoverAC256.BAndoverScript;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.basicdriver.message.Message;
import java.util.StringTokenizer;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAndoverRunScriptJob
extends BJob
implements AndoverMessageConst,
Runnable {
    @Generated
    public static final Type TYPE = Sys.loadType(BAndoverRunScriptJob.class);
    private BAndoverScript scriptObject;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAndoverRunScriptJob() {
    }

    public BAndoverRunScriptJob(BAndoverScript scriptObject) {
        this.scriptObject = scriptObject;
    }

    public void doRun(Context cx) {
        this.scriptObject.getDevice().andoverNetwork().dispatch(this);
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    @Override
    public void run() {
        StringBuilder concatResponse = new StringBuilder();
        try {
            if (this.scriptObject.getDevice() == null) {
                throw new IllegalStateException("Must submit thru AndoverDevice.submitRunScriptJob()");
            }
            this.log().message("Running AndoverScriptObject::" + this.scriptObject.getName());
            StringTokenizer tokenizer = new StringTokenizer(this.scriptObject.getScript(), "\n");
            int lines = tokenizer.countTokens();
            int lineCount = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                this.log().message("executing line " + ++lineCount + ":" + token);
                AndoverGenericRequest reqMsg = new AndoverGenericRequest(token + "\n", 12);
                AndoverStringResponse rcvMsg = (AndoverStringResponse)this.scriptObject.getDevice().andoverNetwork().getComm().transmit((Message)reqMsg, this.scriptObject.getResponseTimeout(), 0);
                if (rcvMsg == null) {
                    reqMsg = new AndoverGenericRequest("'", 12);
                    this.scriptObject.getDevice().andoverNetwork().getComm().transmitNoResponse((Message)reqMsg);
                    this.scriptObject.setScriptResults(concatResponse.toString());
                    this.setDomain(0);
                    this.failed(new Throwable("no response to script line " + lineCount + "::" + token));
                    return;
                }
                concatResponse.append(rcvMsg.getMessage());
                this.progress(lineCount * 100 / lines);
            }
            this.scriptObject.setScriptResults(concatResponse.toString());
            if (this.setDomain(0) == 0) {
                this.success();
            } else {
                this.failed(new Throwable("unable to set domain 0"));
            }
        }
        catch (Exception e) {
            this.setDomain(0);
            this.scriptObject.setScriptResults(concatResponse.toString());
            this.log().message(e.toString());
            this.failed(e);
        }
    }

    private int setDomain(int domain) {
        try {
            AndoverGenericRequest domainReq = new AndoverGenericRequest("DOM " + domain + "\n", 12);
            AndoverStringResponse domainRsp = (AndoverStringResponse)this.scriptObject.getDevice().andoverNetwork().getComm().transmit((Message)domainReq, BRelTime.makeSeconds((int)10), 0);
            if (domainRsp == null) {
                this.log().message("    ERROR: could not set to domain " + domain);
                return -1;
            }
            if (domainRsp.isError()) {
                this.log().message("    ERROR: could not set to domain " + domain);
                return -1;
            }
            return domainRsp.getDomain();
        }
        catch (Exception e) {
            this.log().message("ERROR setting domain to " + domain + ": " + e);
            return -1;
        }
    }
}

