/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.job;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.datatypes.BAndoverBackupConfig;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.basicdriver.message.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAndoverBackupControllerJob
extends BJob
implements AndoverMessageConst,
Runnable {
    @Generated
    public static final Type TYPE = Sys.loadType(BAndoverBackupControllerJob.class);
    private BAndoverDevice device;
    private String fileName;
    private int domain;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAndoverBackupControllerJob() {
    }

    public BAndoverBackupControllerJob(BAndoverDevice device, BAndoverBackupConfig config) {
        this.device = device;
        this.fileName = config.getFileName();
        this.domain = config.getDomain();
    }

    public void doRun(Context cx) {
        this.device.andoverNetwork().dispatch(this);
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    @Override
    public void run() {
        try {
            if (this.device == null) {
                throw new IllegalStateException("Must submit thru AndoverDevice.submitPointDiscoveryJob()");
            }
            boolean goodUpload = true;
            this.log().message("Dump -> Start dedicated process...");
            int actual = this.setDomain(this.domain);
            if (actual != this.domain) {
                this.setDomain(0);
                this.failed(new Throwable("ERROR: LCU NOT FOUND, ABORTING..."));
                return;
            }
            BFileSystem fs = BFileSystem.INSTANCE;
            BIFile tmpFile = fs.makeFile(new FilePath("^backups/" + this.fileName), null);
            OutputStream out = tmpFile.getOutputStream();
            this.log().message("Dump -> Sending dump command...");
            AndoverGenericRequest reqMsg = new AndoverGenericRequest("DUMP ALL\n", 12);
            AndoverStringResponse rcvMsg = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)reqMsg, BRelTime.makeSeconds((int)this.getDumpTimeout()), 0);
            if (rcvMsg == null) {
                goodUpload = false;
                this.setDomain(0);
                this.failed(new Throwable("ERROR: -> no response to dump command"));
                return;
            }
            String dumpText = null;
            try {
                dumpText = rcvMsg.message.substring(rcvMsg.message.indexOf("@"), rcvMsg.message.indexOf("&") + 1);
            }
            catch (IndexOutOfBoundsException e) {
                goodUpload = false;
                this.setDomain(0);
                this.log().message("ERROR: -> dump response is missing start/stop delimiters");
                return;
            }
            this.log().message("Dump -> Checking integrity of response");
            goodUpload = this.checkDumpIntegrity(dumpText);
            if (goodUpload) {
                this.log().message("Dump -> Integrity checking OK, saving results...");
                out.write(dumpText.getBytes());
                out.write(13);
                out.write(10);
            }
            out.close();
            this.device.getBackupFileList();
            this.setDomain(0);
            this.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.failed(e);
        }
    }

    private int setDomain(int domain) {
        if (!this.device.getSupportsDomainKeyword()) {
            return 0;
        }
        try {
            AndoverGenericRequest domainReq = new AndoverGenericRequest("DOM " + domain + "\n", 12);
            AndoverStringResponse domainRsp = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)domainReq, BRelTime.makeSeconds((int)10), 0);
            if (domainRsp == null) {
                this.log().message("    ERROR: could not set to domain " + domain);
                return -1;
            }
            if (domainRsp.isError()) {
                this.log().message("    ERROR: could not set to domain " + domain);
                return -1;
            }
            this.device.setCurrentDomain(domainRsp.getDomain());
            return domainRsp.getDomain();
        }
        catch (Exception e) {
            this.log().message("ERROR setting domain to " + domain + ": " + e);
            return -1;
        }
    }

    private int getDumpTimeout() {
        int dumpTimeout;
        switch (this.device.andoverNetwork().getSerialPortConfig().getBaudRate().getOrdinal()) {
            case 110: {
                dumpTimeout = 30000;
                break;
            }
            case 300: {
                dumpTimeout = 11000;
                break;
            }
            case 600: {
                dumpTimeout = 5200;
                break;
            }
            case 1200: {
                dumpTimeout = 2600;
                break;
            }
            case 2400: {
                dumpTimeout = 1300;
                break;
            }
            case 4800: {
                dumpTimeout = 650;
                break;
            }
            case 9600: {
                dumpTimeout = 360;
                break;
            }
            case 19200: {
                dumpTimeout = 180;
                break;
            }
            default: {
                dumpTimeout = 360;
            }
        }
        return dumpTimeout;
    }

    private boolean checkDumpIntegrity(String dumpText) {
        StringTokenizer tokenizer = new StringTokenizer(dumpText);
        int checkValue = 0;
        int checkRead = 0;
        int dollarSign = 0;
        int lineNumber = 0;
        char[] characters = new char[2];
        while (tokenizer.hasMoreTokens()) {
            String checkString;
            ++lineNumber;
            checkRead = 0;
            checkValue = 0;
            dollarSign = 0;
            String token = tokenizer.nextToken();
            dollarSign = token.indexOf("$");
            if (dollarSign == -1) continue;
            try (StringReader newReader = new StringReader(token.substring(1, dollarSign));){
                checkString = token.substring(dollarSign + 1, dollarSign + 3);
                while (newReader.read(characters, 0, 2) != -1) {
                    checkValue = checkValue + Integer.parseInt(new String(characters), 16) & 0xFF;
                }
            }
            catch (IOException e) {
                return false;
            }
            checkRead = Integer.parseInt(checkString, 16);
            if (checkRead == checkValue) continue;
            return false;
        }
        return true;
    }
}

