/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.comm;

import com.tridium.andoverAC256.BAndoverNetwork;
import com.tridium.andoverAC256.messages.AndoverMessage;
import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import java.io.OutputStream;
import javax.baja.nre.util.ByteArrayUtil;

public class AndoverCommTransmitter
extends CommTransmitter {
    long interCharacterDelay = 0L;
    BAndoverNetwork network;

    public AndoverCommTransmitter(BAndoverNetwork net) {
        this.network = net;
    }

    public void setInterCharacterDelay(long delay) {
        this.interCharacterDelay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessage(Message message) {
        OutputStream out = this.getOutputStream();
        try {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                AndoverMessage msg = (AndoverMessage)message;
                byte[] a = msg.getByteArray();
                if (this.network != null && this.network.getLowLevelTrace()) {
                    this.getComm().getNetwork().getLog().trace("tx:" + ByteArrayUtil.toHexString((byte[])a));
                }
                if (a.length > 0) {
                    for (int i = 0; i < a.length; ++i) {
                        out.write(a[i] & 0xFF);
                        Thread.sleep(this.interCharacterDelay);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getComm().handleFailedTransmit(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(byte[] a) throws Exception {
        OutputStream out;
        OutputStream outputStream = out = this.getOutputStream();
        synchronized (outputStream) {
            if (this.network != null && this.network.getLowLevelTrace()) {
                this.getComm().getNetwork().getLog().trace("tx:" + ByteArrayUtil.toHexString((byte[])a));
            }
            if (a.length > 0) {
                for (int i = 0; i < a.length; ++i) {
                    out.write(a[i] & 0xFF);
                    Thread.sleep(this.interCharacterDelay);
                }
            }
        }
    }
}

