/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256;

import com.tridium.andoverAC256.BAndoverBackupFolder;
import com.tridium.andoverAC256.BAndoverNetwork;
import com.tridium.andoverAC256.datatypes.BAndoverBackupConfig;
import com.tridium.andoverAC256.datatypes.BAndoverBackupRecord;
import com.tridium.andoverAC256.datatypes.BAndoverPointDiscoveryConfig;
import com.tridium.andoverAC256.datatypes.BAndoverRestoreConfig;
import com.tridium.andoverAC256.datatypes.BAndoverSetOptionsConfig;
import com.tridium.andoverAC256.datatypes.BPrintStatusReadings;
import com.tridium.andoverAC256.datatypes.BProgramReloadSettings;
import com.tridium.andoverAC256.enums.BAndoverDeviceTypeEnum;
import com.tridium.andoverAC256.enums.BAndoverPromptEnum;
import com.tridium.andoverAC256.job.BAndoverBackupControllerJob;
import com.tridium.andoverAC256.job.BAndoverDiscoverPointsJob;
import com.tridium.andoverAC256.job.BAndoverRestoreControllerJob;
import com.tridium.andoverAC256.job.BAndoverSetOptionsJob;
import com.tridium.andoverAC256.messages.AndoverDataResponse;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStatusResponse;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.andoverAC256.point.BAndoverPointDeviceExt;
import com.tridium.basicdriver.BBasicDevice;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="deviceType", type="BAndoverDeviceTypeEnum", defaultValue="BAndoverDeviceTypeEnum.ac256", flags=4), @NiagaraProperty(name="devicePassword", type="String", defaultValue="&ne222"), @NiagaraProperty(name="builtInUserPassword", type="String", defaultValue="santa"), @NiagaraProperty(name="configuredUserPassword", type="String", defaultValue="none", flags=4), @NiagaraProperty(name="commInitialized", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="promptStatus", type="BEnum", defaultValue="BAndoverPromptEnum.UnknownPrompt", flags=67), @NiagaraProperty(name="currentDomain", type="int", defaultValue="0", flags=67), @NiagaraProperty(name="printStatusReadings", type="BPrintStatusReadings", defaultValue="new BPrintStatusReadings()", flags=67), @NiagaraProperty(name="jaceDateTime", type="String", defaultValue="-", flags=67), @NiagaraProperty(name="automaticallySetTime", type="boolean", defaultValue="true"), @NiagaraProperty(name="syncTimeFrequency", type="BRelTime", defaultValue="BRelTime.makeHours(1)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeMinutes(1))")}), @NiagaraProperty(name="automaticallyReloadProgram", type="boolean", defaultValue="true"), @NiagaraProperty(name="programReloadSettings", type="BProgramReloadSettings", defaultValue="new BProgramReloadSettings()"), @NiagaraProperty(name="automaticallySetOptions", type="boolean", defaultValue="true"), @NiagaraProperty(name="optionCommandSettings", type="BAndoverSetOptionsConfig", defaultValue="new BAndoverSetOptionsConfig()"), @NiagaraProperty(name="monitorPoint", type="String", defaultValue="F1"), @NiagaraProperty(name="useSPort", type="boolean", defaultValue="false"), @NiagaraProperty(name="points", type="BAndoverPointDeviceExt", defaultValue="new BAndoverPointDeviceExt()"), @NiagaraProperty(name="backupList", type="BAndoverBackupFolder", defaultValue="new BAndoverBackupFolder()", flags=4), @NiagaraProperty(name="supportsDomainKeyword", type="boolean", defaultValue="true")})
@NiagaraActions(value={@NiagaraAction(name="submitDiscoverPointsJob", parameterType="BAndoverPointDiscoveryConfig", defaultValue="new BAndoverPointDiscoveryConfig()", returnType="BOrd", flags=4), @NiagaraAction(name="submitBackupControllerJob", parameterType="BAndoverBackupConfig", defaultValue="new BAndoverBackupConfig()", returnType="BOrd", flags=4), @NiagaraAction(name="submitRestoreControllerJob", parameterType="BAndoverRestoreConfig", defaultValue="new BAndoverRestoreConfig()", returnType="BOrd", flags=4), @NiagaraAction(name="deleteBackupFile", parameterType="BOrd", defaultValue="BOrd.make(\"\")", flags=132), @NiagaraAction(name="submitSetOptionsJob", parameterType="BAndoverSetOptionsConfig", defaultValue="new BAndoverSetOptionsConfig()", returnType="BOrd", flags=132), @NiagaraAction(name="statusCommand"), @NiagaraAction(name="syncTime")})
@NiagaraTopic(name="logonSuccessful")
public class BAndoverDevice
extends BBasicDevice
implements AndoverMessageConst {
    @Generated
    public static final Property deviceType = BAndoverDevice.newProperty((int)4, (BValue)BAndoverDeviceTypeEnum.ac256, null);
    @Generated
    public static final Property devicePassword = BAndoverDevice.newProperty((int)0, (String)"&ne222", null);
    @Generated
    public static final Property builtInUserPassword = BAndoverDevice.newProperty((int)0, (String)"santa", null);
    @Generated
    public static final Property configuredUserPassword = BAndoverDevice.newProperty((int)4, (String)"none", null);
    @Generated
    public static final Property commInitialized = BAndoverDevice.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property promptStatus = BAndoverDevice.newProperty((int)67, (BValue)BAndoverPromptEnum.UnknownPrompt, null);
    @Generated
    public static final Property currentDomain = BAndoverDevice.newProperty((int)67, (int)0, null);
    @Generated
    public static final Property printStatusReadings = BAndoverDevice.newProperty((int)67, (BValue)new BPrintStatusReadings(), null);
    @Generated
    public static final Property jaceDateTime = BAndoverDevice.newProperty((int)67, (String)"-", null);
    @Generated
    public static final Property automaticallySetTime = BAndoverDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property syncTimeFrequency = BAndoverDevice.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1)));
    @Generated
    public static final Property automaticallyReloadProgram = BAndoverDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property programReloadSettings = BAndoverDevice.newProperty((int)0, (BValue)new BProgramReloadSettings(), null);
    @Generated
    public static final Property automaticallySetOptions = BAndoverDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property optionCommandSettings = BAndoverDevice.newProperty((int)0, (BValue)new BAndoverSetOptionsConfig(), null);
    @Generated
    public static final Property monitorPoint = BAndoverDevice.newProperty((int)0, (String)"F1", null);
    @Generated
    public static final Property useSPort = BAndoverDevice.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property points = BAndoverDevice.newProperty((int)0, (BValue)new BAndoverPointDeviceExt(), null);
    @Generated
    public static final Property backupList = BAndoverDevice.newProperty((int)4, (BValue)new BAndoverBackupFolder(), null);
    @Generated
    public static final Property supportsDomainKeyword = BAndoverDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action submitDiscoverPointsJob = BAndoverDevice.newAction((int)4, (BValue)new BAndoverPointDiscoveryConfig(), null);
    @Generated
    public static final Action submitBackupControllerJob = BAndoverDevice.newAction((int)4, (BValue)new BAndoverBackupConfig(), null);
    @Generated
    public static final Action submitRestoreControllerJob = BAndoverDevice.newAction((int)4, (BValue)new BAndoverRestoreConfig(), null);
    @Generated
    public static final Action deleteBackupFile = BAndoverDevice.newAction((int)132, (BValue)BOrd.make((String)""), null);
    @Generated
    public static final Action submitSetOptionsJob = BAndoverDevice.newAction((int)132, (BValue)new BAndoverSetOptionsConfig(), null);
    @Generated
    public static final Action statusCommand = BAndoverDevice.newAction((int)0, null);
    @Generated
    public static final Action syncTime = BAndoverDevice.newAction((int)0, null);
    @Generated
    public static final Topic logonSuccessful = BAndoverDevice.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAndoverDevice.class);
    boolean isFirstPing = false;
    int lastTimeSyncDay = -1;
    int lastStatusUpdateHour = -1;
    Object monitorObject = new Object();
    private boolean reloadRequired = false;
    private Clock.Ticket timeSyncTicket;

    @Generated
    public BAndoverDeviceTypeEnum getDeviceType() {
        return (BAndoverDeviceTypeEnum)this.get(deviceType);
    }

    @Generated
    public void setDeviceType(BAndoverDeviceTypeEnum v) {
        this.set(deviceType, (BValue)v, null);
    }

    @Generated
    public String getDevicePassword() {
        return this.getString(devicePassword);
    }

    @Generated
    public void setDevicePassword(String v) {
        this.setString(devicePassword, v, null);
    }

    @Generated
    public String getBuiltInUserPassword() {
        return this.getString(builtInUserPassword);
    }

    @Generated
    public void setBuiltInUserPassword(String v) {
        this.setString(builtInUserPassword, v, null);
    }

    @Generated
    public String getConfiguredUserPassword() {
        return this.getString(configuredUserPassword);
    }

    @Generated
    public void setConfiguredUserPassword(String v) {
        this.setString(configuredUserPassword, v, null);
    }

    @Generated
    public boolean getCommInitialized() {
        return this.getBoolean(commInitialized);
    }

    @Generated
    public void setCommInitialized(boolean v) {
        this.setBoolean(commInitialized, v, null);
    }

    @Generated
    public BEnum getPromptStatus() {
        return (BEnum)this.get(promptStatus);
    }

    @Generated
    public void setPromptStatus(BEnum v) {
        this.set(promptStatus, (BValue)v, null);
    }

    @Generated
    public int getCurrentDomain() {
        return this.getInt(currentDomain);
    }

    @Generated
    public void setCurrentDomain(int v) {
        this.setInt(currentDomain, v, null);
    }

    @Generated
    public BPrintStatusReadings getPrintStatusReadings() {
        return (BPrintStatusReadings)this.get(printStatusReadings);
    }

    @Generated
    public void setPrintStatusReadings(BPrintStatusReadings v) {
        this.set(printStatusReadings, (BValue)v, null);
    }

    @Generated
    public String getJaceDateTime() {
        return this.getString(jaceDateTime);
    }

    @Generated
    public void setJaceDateTime(String v) {
        this.setString(jaceDateTime, v, null);
    }

    @Generated
    public boolean getAutomaticallySetTime() {
        return this.getBoolean(automaticallySetTime);
    }

    @Generated
    public void setAutomaticallySetTime(boolean v) {
        this.setBoolean(automaticallySetTime, v, null);
    }

    @Generated
    public BRelTime getSyncTimeFrequency() {
        return (BRelTime)this.get(syncTimeFrequency);
    }

    @Generated
    public void setSyncTimeFrequency(BRelTime v) {
        this.set(syncTimeFrequency, (BValue)v, null);
    }

    @Generated
    public boolean getAutomaticallyReloadProgram() {
        return this.getBoolean(automaticallyReloadProgram);
    }

    @Generated
    public void setAutomaticallyReloadProgram(boolean v) {
        this.setBoolean(automaticallyReloadProgram, v, null);
    }

    @Generated
    public BProgramReloadSettings getProgramReloadSettings() {
        return (BProgramReloadSettings)this.get(programReloadSettings);
    }

    @Generated
    public void setProgramReloadSettings(BProgramReloadSettings v) {
        this.set(programReloadSettings, (BValue)v, null);
    }

    @Generated
    public boolean getAutomaticallySetOptions() {
        return this.getBoolean(automaticallySetOptions);
    }

    @Generated
    public void setAutomaticallySetOptions(boolean v) {
        this.setBoolean(automaticallySetOptions, v, null);
    }

    @Generated
    public BAndoverSetOptionsConfig getOptionCommandSettings() {
        return (BAndoverSetOptionsConfig)this.get(optionCommandSettings);
    }

    @Generated
    public void setOptionCommandSettings(BAndoverSetOptionsConfig v) {
        this.set(optionCommandSettings, (BValue)v, null);
    }

    @Generated
    public String getMonitorPoint() {
        return this.getString(monitorPoint);
    }

    @Generated
    public void setMonitorPoint(String v) {
        this.setString(monitorPoint, v, null);
    }

    @Generated
    public boolean getUseSPort() {
        return this.getBoolean(useSPort);
    }

    @Generated
    public void setUseSPort(boolean v) {
        this.setBoolean(useSPort, v, null);
    }

    @Generated
    public BAndoverPointDeviceExt getPoints() {
        return (BAndoverPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BAndoverPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public BAndoverBackupFolder getBackupList() {
        return (BAndoverBackupFolder)this.get(backupList);
    }

    @Generated
    public void setBackupList(BAndoverBackupFolder v) {
        this.set(backupList, (BValue)v, null);
    }

    @Generated
    public boolean getSupportsDomainKeyword() {
        return this.getBoolean(supportsDomainKeyword);
    }

    @Generated
    public void setSupportsDomainKeyword(boolean v) {
        this.setBoolean(supportsDomainKeyword, v, null);
    }

    @Generated
    public BOrd submitDiscoverPointsJob(BAndoverPointDiscoveryConfig parameter) {
        return (BOrd)this.invoke(submitDiscoverPointsJob, (BValue)parameter, null);
    }

    @Generated
    public BOrd submitBackupControllerJob(BAndoverBackupConfig parameter) {
        return (BOrd)this.invoke(submitBackupControllerJob, (BValue)parameter, null);
    }

    @Generated
    public BOrd submitRestoreControllerJob(BAndoverRestoreConfig parameter) {
        return (BOrd)this.invoke(submitRestoreControllerJob, (BValue)parameter, null);
    }

    @Generated
    public void deleteBackupFile(BOrd parameter) {
        this.invoke(deleteBackupFile, (BValue)parameter, null);
    }

    @Generated
    public BOrd submitSetOptionsJob(BAndoverSetOptionsConfig parameter) {
        return (BOrd)this.invoke(submitSetOptionsJob, (BValue)parameter, null);
    }

    @Generated
    public void statusCommand() {
        this.invoke(statusCommand, null, null);
    }

    @Generated
    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    @Generated
    public void fireLogonSuccessful(BValue event) {
        this.fire(logonSuccessful, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        if (!this.getSupportsDomainKeyword()) {
            this.setCurrentDomain(0);
        }
        super.started();
        this.getBackupFileList();
        if (this.getAutomaticallySetTime()) {
            this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSyncTimeFrequency(), (Action)syncTime, null);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == syncTimeFrequency || property == automaticallySetTime) {
            if (this.timeSyncTicket != null) {
                this.timeSyncTicket.cancel();
            }
            if (this.getAutomaticallySetTime()) {
                this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSyncTimeFrequency(), (Action)syncTime, null);
            }
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.timeSyncTicket != null) {
            this.timeSyncTicket.cancel();
        }
        this.timeSyncTicket = null;
    }

    public Type getNetworkType() {
        return BAndoverNetwork.TYPE;
    }

    public BAndoverNetwork andoverNetwork() {
        return (BAndoverNetwork)this.getNetwork();
    }

    public Log getAcLog() {
        return this.andoverNetwork().getAcLog();
    }

    public void getBackupFileList() {
        BDirectory tmpFile;
        try {
            BFileSpace space = (BFileSpace)BOrd.make((String)"file:").get();
            tmpFile = space.makeDir(new FilePath("^backups"), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.getBackupList().removeAll();
        BIFile[] kids = tmpFile.listFiles();
        for (int i = 0; i < kids.length; ++i) {
            BAndoverBackupRecord rec = new BAndoverBackupRecord();
            rec.setTimestamp(kids[i].getLastModified());
            rec.setPath(kids[i].getFileName());
            rec.setOrd(kids[i].getOrdInSpace());
            this.getBackupList().add(null, (BValue)rec, 3);
        }
        this.getBackupList().fireTableUpdated((BValue)BString.make((String)""));
    }

    public BOrd doSubmitDiscoverPointsJob(BAndoverPointDiscoveryConfig params, Context cx) {
        return new BAndoverDiscoverPointsJob(this, params).submit(cx);
    }

    public BOrd doSubmitBackupControllerJob(BAndoverBackupConfig params, Context cx) {
        return new BAndoverBackupControllerJob(this, params).submit(cx);
    }

    public BOrd doSubmitRestoreControllerJob(BAndoverRestoreConfig params, Context cx) {
        return new BAndoverRestoreControllerJob(this, params).submit(cx);
    }

    public void doDeleteBackupFile(BOrd fileOrd) {
        BIFile deleteFile = (BIFile)fileOrd.get();
        try {
            deleteFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getBackupFileList();
    }

    public BOrd doSubmitSetOptionsJob(BAndoverSetOptionsConfig params, Context cx) {
        return new BAndoverSetOptionsJob(this, params).submit(cx);
    }

    public void doStatusCommand() {
        if (this.getStatus().isDisabled()) {
            return;
        }
        this.andoverNetwork().postAsync(new Runnable(){

            @Override
            public void run() {
                AndoverStatusResponse rsp = null;
                AndoverGenericRequest req = new AndoverGenericRequest("P STATUS\n", 1);
                if (BAndoverDevice.this.getAcLog().isTraceOn()) {
                    BAndoverDevice.this.getAcLog().trace(req.toString());
                }
                if ((rsp = (AndoverStatusResponse)BAndoverDevice.this.andoverNetwork().sendSync(req, BAndoverDevice.this.getStatusTimeout(), 1)) == null) {
                    return;
                }
                if (BAndoverDevice.this.getAcLog().isTraceOn()) {
                    BAndoverDevice.this.getAcLog().trace(rsp.toString());
                }
                if (rsp.exceptionCode != 0) {
                    return;
                }
                BAndoverDevice.this.setStatusData(rsp);
                BAndoverDevice.this.lastStatusUpdateHour = BAbsTime.now().getHour();
                if (rsp.message.indexOf("Enter System Time") != -1) {
                    BAndoverDevice.this.sendSyncTime();
                }
                if (rsp.message.indexOf("Set System Options") != -1) {
                    BAndoverDevice.this.submitSetOptionsJob(BAndoverDevice.this.getOptionCommandSettings());
                }
            }
        });
    }

    private BRelTime getStatusTimeout() {
        int statusTimeout = 20;
        int baud = this.andoverNetwork().getSerialPortConfig().getBaudRate().getOrdinal();
        switch (baud) {
            case 110: {
                statusTimeout = 320;
                break;
            }
            case 300: {
                statusTimeout = 160;
                break;
            }
            case 600: {
                statusTimeout = 80;
                break;
            }
            case 1200: {
                statusTimeout = 40;
                break;
            }
            case 2400: {
                statusTimeout = 20;
                break;
            }
            case 4800: {
                statusTimeout = 10;
                break;
            }
            case 9600: {
                statusTimeout = 5;
                break;
            }
            case 19200: {
                statusTimeout = 5;
                break;
            }
            default: {
                statusTimeout = 20;
            }
        }
        return BRelTime.makeSeconds((int)statusTimeout);
    }

    private String getJaceDateTimeString() {
        BAbsTime jDate = BAbsTime.now();
        int jDay = jDate.getDay();
        int jHour = jDate.getHour();
        int jMinute = jDate.getMinute();
        int jSecond = jDate.getSecond();
        String jYearString = String.valueOf(jDate.getYear());
        String jMonthString = jDate.getMonth().getTag().toUpperCase().substring(0, 3);
        String jDayString = String.valueOf(jDate.getDay());
        String jDayOfWeekString = jDate.getWeekday().getTag().toUpperCase().substring(0, 3);
        String jHourString = String.valueOf(jDate.getHour());
        String jMinuteString = String.valueOf(jDate.getMinute());
        String jSecondString = String.valueOf(jDate.getSecond());
        if (jDay < 10) {
            jDayString = " " + jDayString;
        }
        if (jHour < 10) {
            jHourString = " " + jHourString;
        }
        if (jMinute < 10) {
            jMinuteString = " " + jMinuteString;
        }
        if (jSecond < 10) {
            jSecondString = " " + jSecondString;
        }
        return jYearString + " " + jMonthString + " " + jDayString + " " + jDayOfWeekString + "  " + jHourString + " " + jMinuteString + " " + jSecondString;
    }

    public void doSyncTime() {
        this.andoverNetwork().postAsync(new Runnable(){

            @Override
            public void run() {
                BAndoverDevice.this.sendSyncTime();
            }
        });
    }

    private boolean sendSyncTime() {
        String jaceDateTimeString = this.getJaceDateTimeString();
        AndoverGenericRequest setTimeReq = new AndoverGenericRequest("set time " + jaceDateTimeString + "\n", 12);
        AndoverStringResponse setTimeRsp = (AndoverStringResponse)this.andoverNetwork().sendSync(setTimeReq);
        if (setTimeRsp == null) {
            return false;
        }
        this.lastTimeSyncDay = BAbsTime.now().getDayOfYear();
        return true;
    }

    public void doPing() {
        this.getAcLog().trace("ping at " + BAbsTime.now());
        if (!this.andoverNetwork().getSerialPortConfig().getStatus().equals((Object)BStatus.ok)) {
            this.pingFail("can't ping because serial port not initialized");
            return;
        }
        if (this.reloadRequired) {
            this.initCommunications();
            this.pingFail("waiting for panel to re-load");
            return;
        }
        AndoverDataResponse rsp = null;
        AndoverGenericRequest req = new AndoverGenericRequest("P " + this.getMonitorPoint() + "\n", 4);
        rsp = (AndoverDataResponse)this.andoverNetwork().sendSync(req);
        if (rsp == null) {
            if (this.initCommunications()) {
                this.pingOk();
            } else {
                this.pingFail("no response");
            }
            return;
        }
        this.pingOk();
    }

    public void setStatusData(AndoverStatusResponse rsp) {
        if (rsp.getDomain() != 0) {
            return;
        }
        this.setPromptStatus((BEnum)rsp.getPrompt());
        String jaceDateTime = this.getJaceDateTimeString();
        this.setJaceDateTime(jaceDateTime);
        String andoverDateTimeString = rsp.getAndoverDateTime();
        if (rsp.exceptionCode != 0) {
            return;
        }
        this.getPrintStatusReadings().setAndoverDateTime(andoverDateTimeString);
        if (this.getSupportsDomainKeyword()) {
            this.setCurrentDomain(rsp.getDomain());
        } else {
            this.setCurrentDomain(0);
        }
        this.getPrintStatusReadings().setUnitNumber(rsp.getUnitNumber());
        this.getPrintStatusReadings().setNumberAttachedIOUs(rsp.getNumberIOUs());
        this.getPrintStatusReadings().setIouCommFaults(rsp.getIOUCommFaults());
        this.getPrintStatusReadings().setIouOverrides(rsp.getIOUOverrides());
        this.getPrintStatusReadings().setNumberLCUs(rsp.getNumberLCUs());
        this.getPrintStatusReadings().setLCUCommFaults(rsp.getLCUCommFaults());
        this.getPrintStatusReadings().setDisabledVarClasses(rsp.getDisabledVars());
        this.getPrintStatusReadings().setNumberFailures(rsp.getNumberFailures());
    }

    public boolean initCommunications() {
        this.getAcLog().trace("initCommunications");
        AndoverStringResponse signOnRspStep1 = null;
        this.getAcLog().trace("sending devicePassword:" + this.getDevicePassword());
        String signOnString = this.getUseSPort() ? this.getDevicePassword() + "\n" : "\n" + this.getDevicePassword();
        AndoverGenericRequest reqStep1 = new AndoverGenericRequest(signOnString, 12);
        this.setDriverState(1);
        signOnRspStep1 = (AndoverStringResponse)this.andoverNetwork().sendSync(reqStep1, this.andoverNetwork().getResponseTimeout(), 2);
        if (signOnRspStep1 == null) {
            if (this.getAcLog().isTraceOn()) {
                this.getAcLog().trace("no response to logon step 1");
            }
            return false;
        }
        if (signOnRspStep1.getPrompt() != BAndoverPromptEnum.PPrompt) {
            if (this.getAcLog().isTraceOn()) {
                this.getAcLog().trace("error, expecting a P Prompt but received a " + (Object)((Object)signOnRspStep1.getPrompt()));
            }
            return false;
        }
        this.setDriverState(2);
        AndoverGenericRequest reqStep2 = new AndoverGenericRequest(this.getBuiltInUserPassword() + "\n", 1);
        AndoverStatusResponse signOnRspStep2 = (AndoverStatusResponse)this.andoverNetwork().sendSync(reqStep2, this.getStatusTimeout(), 0);
        if (signOnRspStep2 == null) {
            if (this.getAcLog().isTraceOn()) {
                this.getAcLog().trace("null step 2 logon");
            }
            this.setDriverState(1);
            return false;
        }
        if (signOnRspStep2.message.endsWith("?")) {
            AndoverStringResponse response;
            AndoverGenericRequest answer;
            this.setReloadRequired(true);
            this.getAcLog().warning("Andover panel program lost!");
            int numIOUs = this.getProgramReloadSettings().getLBusIousAtStartup();
            int numLCUs = this.getProgramReloadSettings().getAcnetLCUsAtStartup();
            if (signOnRspStep2.message.indexOf("Number of IOU") != -1) {
                this.getAcLog().trace("setting L-Bus Number of IOUs:" + numIOUs);
                answer = new AndoverGenericRequest("" + numIOUs + "\n", 12);
                response = (AndoverStringResponse)this.andoverNetwork().sendSync(answer, BRelTime.makeSeconds((int)5), 0);
                if (response == null) {
                    this.getAcLog().trace("error, expected additional prompts to set number LCUs");
                } else if (response.message.indexOf("Number of LCU") != -1) {
                    this.getAcLog().trace("setting ACNET Number of LCUs:" + numLCUs);
                    answer = new AndoverGenericRequest("" + numLCUs + "\n", 12);
                    response = (AndoverStringResponse)this.andoverNetwork().sendSync(answer, BRelTime.makeSeconds((int)5), 0);
                }
            }
            if (signOnRspStep2.message.indexOf("Number of LCU") != -1) {
                this.getAcLog().trace("setting ACNET Number of LCUs:" + numLCUs);
                answer = new AndoverGenericRequest("" + numLCUs + "\n", 12);
                response = (AndoverStringResponse)this.andoverNetwork().sendSync(answer, BRelTime.makeSeconds((int)6), 0);
            }
            this.setDriverState(1);
            return false;
        }
        this.setStatusData(signOnRspStep2);
        if (signOnRspStep2.message.indexOf("Set System Options") != -1) {
            this.doSubmitSetOptionsJob(this.getOptionCommandSettings(), null);
        }
        if (signOnRspStep2.message.indexOf("Enter System Time") != -1) {
            this.doSyncTime();
        }
        if (this.reloadRequired) {
            if (this.getAutomaticallyReloadProgram()) {
                this.getAcLog().trace("STARTING RELOAD PROCESS...");
                this.getBackupFileList();
                BAndoverBackupRecord[] backupList = (BAndoverBackupRecord[])this.getBackupList().getChildren(BAndoverBackupRecord.class);
                BAndoverBackupRecord mostRecentBackup = null;
                BAbsTime fileTime = BAbsTime.NULL;
                for (int i = 0; i < backupList.length; ++i) {
                    String filepath = backupList[i].getPath();
                    if (filepath.indexOf("_dom0_") == -1 || !backupList[i].getTimestamp().isAfter(fileTime)) continue;
                    fileTime = backupList[i].getTimestamp();
                    mostRecentBackup = backupList[i];
                }
                if (mostRecentBackup != null) {
                    BAndoverRestoreConfig config = new BAndoverRestoreConfig();
                    config.setRestoreDialog("Restoring Domain 0");
                    config.setFileName(mostRecentBackup.getPath());
                    config.setTimestamp(mostRecentBackup.getTimestamp());
                    config.setDomain(0);
                    config.setOrd(mostRecentBackup.getOrd());
                    this.doSubmitRestoreControllerJob(config, null);
                    this.getAcLog().trace("auto reload is enabled, reloading controller program from " + mostRecentBackup.getPath());
                } else {
                    this.getAcLog().warning("ERROR: no backups available, cannot reload controller!");
                }
            } else {
                this.getAcLog().warning("auto reload is not enabled, a backup configuration will not be downloaded to the controller");
            }
            this.setPromptStatus((BEnum)BAndoverPromptEnum.UnknownPrompt);
            this.setDriverState(1);
            return false;
        }
        if (signOnRspStep2.isError()) {
            this.getAcLog().trace("error sending personal password to panel");
            this.setPromptStatus((BEnum)BAndoverPromptEnum.UnknownPrompt);
            this.setDriverState(1);
            return false;
        }
        this.getAcLog().trace("sucessfully initialized communications to Andover panel");
        this.setStatusData(signOnRspStep2);
        this.setDriverState(1);
        this.setCommInitialized(true);
        this.fireLogonSuccessful((BValue)BString.make((String)""));
        return true;
    }

    public void setDriverState(int state) {
        this.andoverNetwork().setDriverState(state);
    }

    public int setDomain(int domain) {
        if (!this.getSupportsDomainKeyword()) {
            return 0;
        }
        try {
            AndoverGenericRequest domainReq = new AndoverGenericRequest("DOM " + domain + "\n", 12);
            AndoverStringResponse domainRsp = (AndoverStringResponse)this.andoverNetwork().sendSync(domainReq);
            if (domainRsp == null) {
                if (this.getAcLog().isTraceOn()) {
                    this.getAcLog().trace("    ERROR: could not set to domain " + domain);
                }
                return -1;
            }
            if (domainRsp.isError()) {
                if (this.getAcLog().isTraceOn()) {
                    this.getAcLog().trace("    ERROR: could not set to domain " + domain);
                }
                return -1;
            }
            this.setCurrentDomain(domainRsp.getDomain());
            return domainRsp.getDomain();
        }
        catch (Exception e) {
            if (this.getAcLog().isTraceOn()) {
                this.getAcLog().warning("ERROR setting domain to " + domain + ": " + e);
            }
            return -1;
        }
    }

    public void setReloadRequired(boolean required) {
        this.reloadRequired = required;
    }
}

