/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusSlave;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.modbusCore.enums.BModbusDataModeEnum;
import com.tridium.modbusCore.server.BModbusServerNetwork;
import com.tridium.modbusSlave.BModbusSlaveDevice;
import com.tridium.modbusSlave.BModbusSlaveDeviceFolder;
import com.tridium.modbusSlave.comm.ModbusSlaveSerialComm;
import com.tridium.modbusSlave.comm.ModbusUnsolicitedReceive;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="interMessageDelay", type="BRelTime", defaultValue="BRelTime.make(0)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(0), BFacets.MAX, BRelTime.SECOND)")}), @NiagaraProperty(name="serialPortConfig", type="BSerialHelper", defaultValue="new BSerialHelper()"), @NiagaraProperty(name="modbusDataMode", type="BModbusDataModeEnum", defaultValue="BModbusDataModeEnum.rtu"), @NiagaraProperty(name="snifferMode", type="boolean", defaultValue="false")})
public class BModbusSlaveNetwork
extends BModbusServerNetwork
implements BISerialHelperParent {
    @Generated
    public static final Property interMessageDelay = BModbusSlaveNetwork.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    @Generated
    public static final Property serialPortConfig = BModbusSlaveNetwork.newProperty((int)0, (BValue)new BSerialHelper(), null);
    @Generated
    public static final Property modbusDataMode = BModbusSlaveNetwork.newProperty((int)0, (BValue)BModbusDataModeEnum.rtu, null);
    @Generated
    public static final Property snifferMode = BModbusSlaveNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusSlaveNetwork.class);
    private Log log = null;
    private ModbusUnsolicitedReceive unsolicitedReceive = null;

    @Generated
    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    @Generated
    public void setInterMessageDelay(BRelTime v) {
        this.set(interMessageDelay, (BValue)v, null);
    }

    @Generated
    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    @Generated
    public void setSerialPortConfig(BSerialHelper v) {
        this.set(serialPortConfig, (BValue)v, null);
    }

    @Generated
    public BModbusDataModeEnum getModbusDataMode() {
        return (BModbusDataModeEnum)this.get(modbusDataMode);
    }

    @Generated
    public void setModbusDataMode(BModbusDataModeEnum v) {
        this.set(modbusDataMode, (BValue)v, null);
    }

    @Generated
    public boolean getSnifferMode() {
        return this.getBoolean(snifferMode);
    }

    @Generated
    public void setSnifferMode(boolean v) {
        this.setBoolean(snifferMode, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BModbusSlaveDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BModbusSlaveDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "modbusSlave");
    }

    public int getModbusMode() {
        return this.getModbusDataMode().getOrdinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.getNameSubscriber().subscribe((BComponent)this.getSerialPortConfig());
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
        if (this.log == null) {
            this.log = this.getLog();
        }
        Log log = this.log;
        synchronized (log) {
            this.log = this.getLog();
        }
    }

    public void startComm() throws Exception {
        if (this.getSerialPortConfig().getPortName().equals("none")) {
            this.configFail("No port selected for Modbus communication.");
        } else {
            try {
                super.startComm();
            }
            catch (Exception e) {
                this.configFail("Could not enable Modbus serial communication (" + e + ")");
                throw e;
            }
            this.configOk();
        }
    }

    public Log getLog() {
        String serialLogName = this.getName() + "_" + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)serialLogName)) {
            serialLogName = SlotPath.escape((String)serialLogName);
        }
        return Log.getLog((String)serialLogName);
    }

    protected Comm makeComm() {
        return new ModbusSlaveSerialComm(this);
    }

    protected void initComm(Comm comm) {
        this.unsolicitedReceive = new ModbusUnsolicitedReceive(this);
        this.unsolicitedReceive.init();
    }

    public void reopenPort() {
        try {
            String newPort = this.getSerialPortConfig().getPortName();
            if (newPort.equals("none")) {
                this.configFail("No port selected for Modbus communication.");
                this.stopComm();
                return;
            }
            this.restartSerialNetwork();
        }
        catch (Exception e) {
            this.getLog().warning("BModbusSlaveNetwork caught exception in reopenPort(): " + e.getLocalizedMessage());
        }
    }

    private void restartSerialNetwork() throws Exception {
        if (!(this.isDisabled() || this.isDown() || this.isFatalFault())) {
            this.getLog().message(" *** Restarting serial comm ***");
            this.stopComm();
            this.startComm();
        }
    }

    public void atSteadyState() {
        this.unsolicitedReceive.atSteadyState();
    }

    protected boolean initializeNetwork() {
        if (this.networkInitialized) {
            return true;
        }
        this.startHelpers();
        if (!this.getComm().isCommStarted()) {
            this.getModbusLog().warning("Unable to start Serial Comm for " + this.getName());
            this.stopHelpers();
            return false;
        }
        try {
            ((ModbusSlaveSerialComm)this.getComm()).getSerialPort().enableReceiveThreshold(1);
        }
        catch (UnsupportedOperationException e) {
            this.getModbusLog().error(this.getName() + ", ModbusSlaveSerialComm: Unable to perform enableReceiveThreshold = 1.  Exception- ", (Throwable)e);
        }
        this.networkInitialized = true;
        return true;
    }

    protected void startHelpers() {
        super.startHelpers();
        this.unsolicitedReceive.start();
    }

    protected void stopHelpers() {
        super.stopHelpers();
        this.unsolicitedReceive.stop();
    }

    public ModbusUnsolicitedReceive unsolicitedReceive() {
        return this.unsolicitedReceive;
    }

    protected void processNameSubscriberEvent(BComponentEvent event) {
        super.processNameSubscriberEvent(event);
        try {
            if (event.getId() == 0 && event.getSlot().equals((Object)BSerialHelper.portName)) {
                this.updateLog();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BModbusSlaveDevice findModbusDevice(int address) {
        BDevice[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i] == null || !(devices[i] instanceof BModbusSlaveDevice) || ((BModbusSlaveDevice)devices[i]).getDeviceAddress() != address) continue;
            return (BModbusSlaveDevice)devices[i];
        }
        return null;
    }
}

