function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 * @author Nutan Naik
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/rdb/rc/fe/RdbmsColumnSelectionEditor
 * @since Niagara 4.14
 */

define(['baja!', 'baja!rdb:RdbmsColumnSelection,rdb:RdbmsOptionalColumnSelection', 'lex!baja', 'jquery', 'Promise', 'underscore', 'bajaux/spandrel', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/webEditors/rc/fe/baja/DynamicEnumEditor', 'css!nmodule/rdb/rc/rdb'], function (baja, types, lexs, $, Promise, _, spandrel, fe, BooleanEditor, DynamicEnumEditor) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-RdbmsColumnSelectionEditor'
      }
    };
  };
  var _lexs = _slicedToArray(lexs, 1),
    bajaLex = _lexs[0];

  /**
   * Editor for `RdbmsColumnSelection`.
   *
   * @class
   * @alias module:nmodule/rdb/rc/fe/RdbmsColumnSelectionEditor
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @since Niagara 4.14
   **/
  var RdbmsColumnSelectionEditor = /*#__PURE__*/function (_spandrel) {
    function RdbmsColumnSelectionEditor(params) {
      _classCallCheck(this, RdbmsColumnSelectionEditor);
      return _callSuper(this, RdbmsColumnSelectionEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @returns {Promise.<baja.Component>} RdbmsColumnSelection or RdbmsOptionalColumnSelection
     */
    _inherits(RdbmsColumnSelectionEditor, _spandrel);
    return _createClass(RdbmsColumnSelectionEditor, [{
      key: "doSave",
      value: function doSave(readValue) {
        var realColumnSelection = this.value();
        var column = readValue.getColumn();
        var hasUnspecified = readValue.getType().is('rdb:RdbmsOptionalColumnSelection');
        var promises = [realColumnSelection.set({
          slot: 'column',
          value: column
        })];
        if (hasUnspecified) {
          promises.push(realColumnSelection.set({
            slot: 'unspecified',
            value: readValue.getUnspecified()
          }));
        }
        return Promise.all(promises);
      }

      /**
       * @returns {Promise.<baja.Component>} RdbmsColumnSelection or RdbmsOptionalColumnSelection
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var _this = this;
        return this.$getDynamicEnumEditorWidget().read().then(function (newEnum) {
          return _this.$readRdbmsColumnSelection(newEnum);
        })["catch"](function () {
          //new value, add it to the enum range
          return _this.$getDynamicEnumEditorWidget().$readString().then(function (str) {
            str = baja.SlotPath.escape(str);
            var range = _this.value().getColumn().getRange();
            var ordinals = range.getOrdinals();
            var ordinalValue = str && str.length ? -1 : 0;
            var tags = [];
            baja.iterate(ordinals, function (ordinal, i) {
              var tag = range.getTag(ordinal);
              tags.push(tag);
              if (tag === str) {
                ordinalValue = i;
              }
            });
            if (ordinalValue === -1) {
              ordinalValue = tags.length;
              ordinals.push(tags.length);
              tags.push(str);
            }
            range = baja.EnumRange.make({
              ordinals: ordinals,
              tags: tags
            });
            return _this.$readRdbmsColumnSelection(baja.DynamicEnum.make({
              ordinal: ordinalValue,
              range: range
            }));
          });
        });
      }

      /**
       * @private
       * @param {baja.DynamicEnum} newEnum
       * @returns {Promise.<baja.Component>} RdbmsColumnSelection or RdbmsOptionalColumnSelection
       */
    }, {
      key: "$readRdbmsColumnSelection",
      value: function $readRdbmsColumnSelection(newEnum) {
        var booleanEditor = this.$getBooleanEditorWidget();
        if (!booleanEditor) {
          return baja.$('rdb:RdbmsColumnSelection', {
            column: newEnum
          });
        } else {
          return this.$getBooleanEditorWidget().read().then(function (newValue) {
            return baja.$('rdb:RdbmsOptionalColumnSelection', {
              column: newEnum,
              unspecified: newValue
            });
          });
        }
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getBooleanEditorWidget",
      value: function $getBooleanEditorWidget() {
        return this.queryWidget('checkbox');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getDynamicEnumEditorWidget",
      value: function $getDynamicEnumEditorWidget() {
        return this.queryWidget('dynamicEnumEditor');
      }
    }]);
  }(spandrel(function (value, _ref) {
    var self = _ref.self;
    var column = value.getColumn();

    // flag to show/hide None checkbox
    var hasUnspecified = value.getType().is('rdb:RdbmsOptionalColumnSelection');
    var noneText = bajaLex.get('flag.none');
    var isUnspecified = hasUnspecified ? value.getUnspecified() : false;
    return [hasUnspecified && spandrel.jsx(BooleanEditor, {
      className: "booleanEditor",
      value: isUnspecified,
      onUxModifiedValue: function onUxModifiedValue(modifiedValue) {
        self.$getDynamicEnumEditorWidget().setEnabled(!modifiedValue);
      },
      properties: {
        displayType: 'checkbox',
        trueText: noneText,
        falseText: noneText
      },
      spandrelKey: "checkbox"
    }), spandrel.jsx(DynamicEnumEditor, {
      spandrelKey: "dynamicEnumEditor",
      value: column,
      enabled: !isUnspecified
    })];
  }));
  return RdbmsColumnSelectionEditor;
});
