/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file Model for Tab Configuration Data for analytics views
 * @author : Komaravolu, sai
 *
 */
define(['baja!', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/base/AnalyticsTabConfigBaseModel', 'jquery'], function (baja, analyticsUtil, AnalyticsTabConfigBaseModel, $) {
  "use strict";

  /**
   * Represents a model for tab configurations.
   * @constructor
   */
  var AnalyticsTableConfigModel = function AnalyticsTableConfigModel(input) {
    AnalyticsTabConfigBaseModel.call(this, $.extend({}, input));
    var that = this;
    that.$exclusionList = input.exclusionList || "";
    that.$columnList = input.columnList || "";
    that.$colOrder = input.colOrder || "";
  };
  AnalyticsTableConfigModel.prototype = Object.create(AnalyticsTabConfigBaseModel.prototype);
  AnalyticsTableConfigModel.prototype.constructor = AnalyticsTableConfigModel;
  AnalyticsTableConfigModel.prototype.getExclusionList = function () {
    return this.$exclusionList;
  };
  AnalyticsTableConfigModel.prototype.setExclusionList = function (exclusionList) {
    this.$exclusionList = exclusionList;
  };
  AnalyticsTableConfigModel.prototype.getColumnList = function () {
    return this.$columnList;
  };
  AnalyticsTableConfigModel.prototype.setColumnList = function (columnList) {
    this.$columnList = columnList;
  };
  AnalyticsTableConfigModel.prototype.getColOrder = function () {
    return this.$colOrder;
  };
  AnalyticsTableConfigModel.prototype.setColOrder = function (colOrder) {
    this.$colOrder = colOrder;
  };

  /**
   * Children should implement the method to rebuild the tab configuration model.
   * @param inModel
   */
  AnalyticsTableConfigModel.prototype.rebuild = function (inModel) {
    this.setExclusionList(inModel.$exclusionList);
    this.setColOrder(inModel.$colOrder);
    return inModel;
  };
  AnalyticsTableConfigModel.prototype.toString = function () {
    var that = this;
    var temp = AnalyticsTabConfigBaseModel.prototype.toString.apply(that);
    temp.exclusionList = that.$exclusionList;
    temp.columnList = that.$columnList;
    temp.colOrder = that.$colOrder;
    return temp;
  };

  /**
   * Open for implementation by children.
   * By default it returns false.
   * @param inModel
   * @returns {boolean}
   */
  AnalyticsTableConfigModel.prototype.equals = function (inModel) {
    return inModel.getExclusionList() === this.getExclusionList();
  };
  return AnalyticsTableConfigModel;
});
