/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 */
define(['baja!', 'Promise', 'jquery', 'underscore', 'nmodule/webEditors/rc/wb/tree/JSONTreeNode'], function (baja, Promise, $, _, JSONTreeNode) {
  'use strict';

  /**
   * @alias module:nmodule/analytics/rc/report/util/AnalyticNodeTreeNode
   * @param comp
   * @param obj
   * @param name
   * @constructor
   */
  var AnalyticNodeTreeNode = function AnalyticNodeTreeNode(comp, obj, name) {
    this.$comp = comp;
    var navName = comp.getName() || name;
    this.$name = navName;
    JSONTreeNode.call(this, navName, obj);
  };
  AnalyticNodeTreeNode.prototype = Object.create(JSONTreeNode.prototype);
  AnalyticNodeTreeNode.prototype.constructor = AnalyticNodeTreeNode;

  /**
   * Right now keep it unselectable
   */
  AnalyticNodeTreeNode.prototype.isSelectable = function () {
    return false;
  }
  /**
   * Returns the component associated with this tree node instance
   * @returns {boolean}
   */;
  AnalyticNodeTreeNode.prototype.getComponent = function () {
    return this.$comp;
  };
  /**
   * Get nav type spec. This node represents analytics:AnalyticNode
   */
  AnalyticNodeTreeNode.prototype.getNavTypeSpec = function () {
    return "analytics:AnalyticNode";
  };
  /**
   * Set the display path of Nav Node
   * @param navNodeDisplay
   */
  AnalyticNodeTreeNode.prototype.setNavNodeDisplay = function (navNodeDisplay) {
    this.$navNodeDisplay = navNodeDisplay;
  };
  /**
   * Get the display path of Nav Node
   * @returns {*}
   */
  AnalyticNodeTreeNode.prototype.getNavNodeDisplay = function () {
    return this.$navNodeDisplay;
  };
  /**
   * Get the display path of Nav Node
   * @returns {*}
   */
  AnalyticNodeTreeNode.prototype.getNavNodeName = function () {
    return this.$name;
  };
  return AnalyticNodeTreeNode;
});
