function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/MissingDataStrategyEditor
 */
define(['baja!', 'baja!analytics:AggregationStrategy,analytics:InterpolationAlgorithm',
// 'log!nmodule.analytics.rc.report.fe.MissingDataStrategyEditor',
'bajaux/Widget', 'bajaux/events', 'bajaux/mixin/subscriberMixIn', 'Promise', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/util/ComplexDiff', 'nmodule/webEditors/rc/fe/fe', 'lex!analytics', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, types,
//log,
Widget, events, subscriberMixIn, Promise, BaseEditor, ComplexDiff, fe, lexs) {
  'use strict';

  var lex = lexs[0];
  var MODIFY_EVENT = events.MODIFY_EVENT;

  // const logSevere = log.severe.bind(log);

  /**
   * Editor for working with `analytics:MissingDataStrategy` instances.
   *
   * @class
   * @alias module:nmodule/analytics/rc/report/fe/MissingDataStrategyEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @mixes module:bajaux/mixin/subscriberMixIn
   */
  var MissingDataStrategyEditor = /*#__PURE__*/function (_BaseEditor) {
    function MissingDataStrategyEditor() {
      var _this;
      _classCallCheck(this, MissingDataStrategyEditor);
      _this = _callSuper(this, MissingDataStrategyEditor, arguments);
      subscriberMixIn(_this);
      return _this;
    }

    /**
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */
    _inherits(MissingDataStrategyEditor, _BaseEditor);
    return _createClass(MissingDataStrategyEditor, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.addClass('MissingDataStrategyEditor');
        var aggS = lex.getSafe("missingdata.agg.strategy"),
          intpAlgorithm = lex.getSafe("missingdata.intrpl.strategy"),
          enabled = lex.getSafe("missingdata.enbld");
        dom.html("\n          <div>\n            <span class=\"mdh-label\"><label>".concat(enabled, "</label></span>\n            <span class=\"mdhEnabler\"></span>\n        </div>\n        <div>\n            <span class=\"mdh-label\"><label>").concat(aggS, "</label></span>\n            <span class=\"aggregationStrategy\"></span>\n        </div>\n        <div>\n            <span class=\"mdh-label\"><label>").concat(intpAlgorithm, "</label></span>\n            <span class=\"interpolationAlgorithm\"></span>\n        </div>\n        <div class=\"config\" style=\"display: none\">\n        </div>\n      "));
        dom.on(MODIFY_EVENT, '.editor', function () {
          _this2.setModified(true);
          return false;
        });
        dom.on(MODIFY_EVENT, '.interpolationAlgorithm', function (e, ed) {
          ed.read().then(function (selectedInterpolation) {
            _this2.$getConfigElement().toggle(selectedInterpolation.getOrdinal() === 2);
            return _this2.$buildConfigForInterpolation(selectedInterpolation.getTag());
          })["catch"]();
        });
        dom.on(MODIFY_EVENT, '.mdhEnabler', function (e, ed) {
          ed.read().then(function (mdhStatus) {
            return _this2.$toggleMDHEditors(mdhStatus);
          })["catch"]();
        });
        var editors = [fe.buildFor({
          dom: this.$getEnablerElement(),
          value: false,
          properties: {
            trueText: " ",
            falseText: " "
          },
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getAggregationElement(),
          value: baja.$('analytics:AggregationStrategy'),
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getInterpolationElement(),
          value: baja.$('analytics:InterpolationAlgorithm'),
          formFactor: 'mini'
        }), this.$buildKNNConfig(1)];
        return Promise.all(editors);
      }

      /**
       * @param {Promise.<baja.Complex>} strat an `analytics:MissingDataStrategy`
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(strat) {
        var _this3 = this;
        var intpAlgorithm = strat.get('interpolationAlgorithm');
        var loadList = [];
        var configElem = this.$getConfigElement();
        loadList.push(this.$getEnablerEditor().load(strat.getEnabled()));
        if (intpAlgorithm.getOrdinal() === 2) {
          configElem.show();
          loadList.push(this.$getKNNConfigEditor().load(strat.getKValue()));
        } else {
          configElem.hide();
        }
        loadList.push(this.$getAggregationEditor().load(strat.get('aggregationStrategy')));
        loadList.push(this.$getInterpolationEditor().load(intpAlgorithm));
        return Promise.all(loadList).then(function () {
          return _this3.$toggleMDHEditors(strat.getEnabled());
        });
      }

      /**
       * @returns {Promise.<baja.Complex>} a promise that resolves to an
       * `analytics:MissingDataStrategy` with the current user entered values
       */
    }, {
      key: "doRead",
      value: function doRead() {
        return Promise.all([this.$getEnablerEditor().read(), this.$getAggregationEditor().read(), this.$getInterpolationEditor().read(), this.$getKNNConfigEditor().read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 4),
            enabledVal = _ref2[0],
            aggregationStrategy = _ref2[1],
            interpolationAlgorithm = _ref2[2],
            knnValue = _ref2[3];
          if (enabledVal) {
            if (isFinite(knnValue)) {
              if (knnValue < 1 || knnValue > 30) {
                throw new Error(lex.get("analytics.mdc.min.max.error"));
              }
            } else {
              knnValue = 1;
            }
          }
          return baja.$('analytics:MissingDataStrategy', {
            enabled: enabledVal,
            aggregationStrategy: aggregationStrategy,
            interpolationAlgorithm: interpolationAlgorithm,
            kValue: knnValue
          });
        });
      }

      /**
       * @param {baja.Complex} readStrat the `MissingDataStrategy` with the user
       * entered values
       * @returns {Promise<baja.Complex>} promise to be resolved when the user
       * entered changes have been saved to the loaded `MissingDataStrategy`
       */
    }, {
      key: "doSave",
      value: function doSave(readStrat) {
        var strat = this.value();
        strat.setEnabled(readStrat.getEnabled());
        strat.setAggregationStrategy(readStrat.getAggregationStrategy());
        strat.setInterpolationAlgorithm(readStrat.getInterpolationAlgorithm());
        strat.setKValue(readStrat.getKValue());
        return strat;
      }

      /**
       * @param {boolean} readonly
       * @returns {Promise}
       */
    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }

      /**
       * @param {boolean} enabled
       * @returns {Promise}
       */
    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }

      /**
       * Build the config for the selected interpolation.
       * @private
       * @param {string} interpolation
       * @returns {Promise}
       */
    }, {
      key: "$buildConfigForInterpolation",
      value: function $buildConfigForInterpolation(interpolation) {
        switch (interpolation) {
          case 'kNearestNeighbour':
            return this.$getKNNConfigEditor().load(this.value().getKValue());
          default:
            return Promise.resolve();
        }
      }

      /**
       * Build editor for KNN algorithm config.
       * @private
       * @returns {Promise<module:bajaux/Widget>}
       */
    }, {
      key: "$buildKNNConfig",
      value: function $buildKNNConfig(knnValue) {
        var configElement = this.$getConfigElement();
        var kValueLabel = lex.getSafe("missingdata.knn.val");
        configElement.html("<span class=\"mdh-label kValLbl\">".concat(kValueLabel, "</span><span class=\"kValueEditor\"></span>"));
        //@TODO read min and max from facets
        return fe.buildFor({
          value: baja.Integer.make(knnValue),
          dom: configElement.children('.kValueEditor'),
          properties: {
            min: 1,
            max: 30,
            nativeHtml: true
          },
          formFactor: 'mini'
        });
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getAggregationElement",
      value: function $getAggregationElement() {
        return this.jq().find('.aggregationStrategy');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getConfigElement",
      value: function $getConfigElement() {
        return this.jq().children('.config');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getInterpolationElement",
      value: function $getInterpolationElement() {
        return this.jq().find('.interpolationAlgorithm');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getEnablerElement",
      value: function $getEnablerElement() {
        return this.jq().find('.mdhEnabler');
      }

      /**
       * @private
       * @returns {Widget}
       */
    }, {
      key: "$getAggregationEditor",
      value: function $getAggregationEditor() {
        if (Widget["in"]) {
          return Widget["in"](this.$getAggregationElement());
        } else {
          return this.$getAggregationElement().data('widget');
        }
      }

      /**
       * @private
       * @returns {Widget}
       */
    }, {
      key: "$getInterpolationEditor",
      value: function $getInterpolationEditor() {
        if (Widget["in"]) {
          return Widget["in"](this.$getInterpolationElement());
        } else {
          return this.$getInterpolationElement().data('widget');
        }
      }

      /**
       * @private
       * @returns {Widget}
       */
    }, {
      key: "$getEnablerEditor",
      value: function $getEnablerEditor() {
        if (Widget["in"]) {
          return Widget["in"](this.$getEnablerElement());
        } else {
          return this.$getEnablerElement().data('widget');
        }
      }

      /**
       * @private
       * @returns {Widget}
       */
    }, {
      key: "$getKNNConfigEditor",
      value: function $getKNNConfigEditor() {
        if (Widget["in"]) {
          return Widget["in"](this.$getConfigElement().find('.kValueEditor'));
        } else {
          return this.$getConfigElement().find('.kValueEditor').data('widget');
        }
      }
    }, {
      key: "$toggleMDHEditors",
      value: function $toggleMDHEditors(mdhStatus) {
        var aggStratEditor = this.$getAggregationEditor();
        var intpEditor = this.$getInterpolationEditor();
        var knnConfigEditor = this.$getKNNConfigEditor();
        return Promise.all([aggStratEditor.setEnabled(mdhStatus), intpEditor.setEnabled(mdhStatus), knnConfigEditor.setEnabled(mdhStatus)]);
      }
    }]);
  }(BaseEditor);
  return MissingDataStrategyEditor;
});
