/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/AnalyticUnitValueFE
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'dialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/UnitEditor', 'nmodule/analytics/rc/chart/fe/AnalyticOptionalValueFE', 'lex!analytics'], function (baja, $, Promise, Widget, dialogs, events, UnitEditor, AnalyticOptionalValueFE, lexicon) {
  'use strict';

  var lex = lexicon[0];

  /**
   * A field editor for selecting units for reports.
   *
   * @class
   * @alias module:nmodule/analytics/rc/report/fe/AnalyticUnitValueFE
   * @extends module:nmodule/analytics/rc/chart/fe/AnalyticOptionalValueFE
   */
  var AnalyticUnitValueFE = function AnalyticUnitValueFE() {
    AnalyticOptionalValueFE.call(this, arguments);
  };
  // Inheriting AnalyticDataEditorFE from BaseEditor
  AnalyticUnitValueFE.prototype = Object.create(AnalyticOptionalValueFE.prototype);
  // Setting the constructor
  AnalyticUnitValueFE.prototype.constructor = AnalyticUnitValueFE;
  AnalyticUnitValueFE.prototype.getFEType = function () {
    return UnitEditor;
  };
  AnalyticUnitValueFE.prototype.isSelected = function () {
    return $(".fe-checkbox", this.jq()).is(":checked");
  };

  /**
   * Get the value of data from type
   * @returns {*|jQuery|HTMLElement}
   */
  AnalyticUnitValueFE.prototype.getDataValue = function (value) {
    return value.getUnitName();
  };

  /**
   * Get the value of data from type
   * @returns {*|jQuery|HTMLElement}
   */
  AnalyticUnitValueFE.prototype.getDataTag = function (value) {
    return value.encodeToString();
  };

  /**
   * Handle the property changed event
   */
  AnalyticUnitValueFE.prototype.handleDataPropertyFEChanged = function (propertyEditor) {
    // Time to register events.
    var that = this;
    propertyEditor.jq().on(events.MODIFY_EVENT, function () {
      that.setModified(true);
      return propertyEditor.doRead().then(function (value) {
        that.$getDataElement().val(that.getDataValue(value));
        that.$getDataElement().attr("tag", that.getDataTag(value));
        // eslint-disable-next-line promise/no-return-wrap
        return Promise.resolve();
      });
    });
    return Promise.resolve();
  };
  AnalyticOptionalValueFE.prototype.getLabel = function () {
    return lex.get("unit");
  };
  return AnalyticUnitValueFE;
});
