/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * LoadDurationChart.js
 * This javascript creates a LoadDuration Chart using d3 javascript.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'underscore', 'd3', 'nmodule/analytics/rc/chart/base/AnalyticC3BaseChart', 'nmodule/analytics/rc/chart/fe/LoadDurationUxWebChartSettingsFE', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/webEditors/rc/wb/util/ICollectionSupport', 'lex!analytics', 'css!nmodule/analytics/rc/chart/loadduration/loadDurationChart'], function (baja, Widget, subscriberMixIn, Promise, $, _, d3, AnalyticC3BaseChart, LoadDurationUxWebChartSettingsFE, analyticsUtil, ICollectionSupport, lexicon) {
  "use strict";

  var lex = lexicon[0];

  /**
   * @class
   * @alias module:nmodule/analytics/rc/chart/loadduration/LoadDurationChart
   * @extends module:nmodule/analytics/rc/chart/base/AnalyticC3BaseChart
   * @mixes module:nmodule/webEditors/rc/wb/util/ICollectionSupport
   * @param {Object} [params]
   */
  var LoadDurationChart = function LoadDurationChart(params) {
    AnalyticC3BaseChart.call(this, $.extend({}, params));
    ICollectionSupport(this);
    this.init();
  };
  LoadDurationChart.prototype = Object.create(AnalyticC3BaseChart.prototype);
  LoadDurationChart.prototype.constructor = LoadDurationChart;

  /**
   * Render the pie
   * @param chartSettingsCollection
   */
  LoadDurationChart.prototype.processData = function (chartSettingsCollection, isRedrawRequest) {
    var that = this;
    chartSettingsCollection.forEach(function (model) {
      var ser = model.getAnalyticTrendArray();
      if (!isRedrawRequest) {
        ser = analyticsUtil.normalize(model, ser);
      }
      var processedSeries = {
        color: model.getBrush(),
        unitSymbol: model.getUnitDisplay(),
        name: model.getSeriesName(),
        ord: model.getOrd(),
        unit: model.getUnitDisplay(),
        chartType: model.getChartType(),
        showOnY2: model.getShowOnY2()
      };
      processedSeries.data = ser.map(function (e) {
        var obj = {
          x: e.date.getMillis()
        };
        obj.y = e.value;
        obj.metaData = {
          interpolationStatus: e.interpolationStatus
        };
        return obj;
      });
      var interval;
      if (processedSeries.data.length > 0) {
        interval = Math.abs(processedSeries.data[1] && processedSeries.data[1].x ? processedSeries.data[1].x - processedSeries.data[0].x : that.getRenderInterval());
      }
      processedSeries.data = _.sortBy(processedSeries.data, function (e) {
        return e.y;
      }).reverse();
      processedSeries.data = _.map(processedSeries.data, function (e, i) {
        e.x = i * interval;
        return e;
      });
      that.series.push(processedSeries);

      // BASELINE
      if (model.getBaseline() && model.getBaseline().baselineEnabled) {
        var blSer = model.getAnalyticChartBaselineTrendArray();
        if (!isRedrawRequest) {
          blSer = analyticsUtil.normalize(model, blSer);
        }
        var processedBlSeries = {
          color: model.getBaseline().baselineColor,
          unitSymbol: model.getUnitDisplay(),
          name: model.getSeriesName() + lex.get("chart.series.append.baseline"),
          ord: model.getOrd(),
          unit: model.getUnitDisplay(),
          chartType: model.getChartType(),
          showOnY2: model.getShowOnY2()
        };
        processedBlSeries.data = blSer.map(function (e) {
          var obj = {
            x: e.date.getMillis()
          };
          obj.y = e.value;
          obj.metaData = {
            interpolationStatus: e.interpolationStatus
          };
          return obj;
        });
        var blInterval;
        if (processedBlSeries.data.length > 0) {
          blInterval = Math.abs(processedBlSeries.data[1] && processedBlSeries.data[1].x ? processedBlSeries.data[1].x - processedBlSeries.data[0].x : that.getRenderInterval());
        }
        processedBlSeries.data = _.sortBy(processedBlSeries.data, function (e) {
          return e.y;
        }).reverse();
        processedBlSeries.data = _.map(processedBlSeries.data, function (e, i) {
          e.x = i * blInterval;
          return e;
        });
        that.series.push(processedBlSeries);
      }
    });
    return analyticsUtil.getRenderableC3Data(that, that.series);
  };

  /**
   *
   * @param data
   * @returns {number}
   */
  LoadDurationChart.prototype.getXData = function (data) {
    return data.x;
  };

  /**
   *
   * @param data
   * @returns {number}
   */
  LoadDurationChart.prototype.getYData = function (data) {
    return data.y;
  };

  /**
   * Handle process move
   * @param eventSource
   * @param chartDataList
   * @param xScale
   * @param wrapper
   * @param div
   */
  LoadDurationChart.prototype.$processMouseMove = function (eventSource, chartDataList, xScale, wrapper, div) {};

  /**
   * This needs a clean slate
   * @returns {boolean}
   */
  LoadDurationChart.prototype.needsCleanSlate = function () {
    return true;
  };

  /**
   * This method should be overridden by subclasses to return respective chart types.
   * The default implementation returns "none".
   * @returns {string}
   */
  LoadDurationChart.prototype.getSupportedExportTypes = function () {
    return ["ldchart", "csv"];
  };

  /**
   * Get the chart margins
   * @type {{top: number, right: number, bottom: number, left: number}}
   */
  LoadDurationChart.prototype.chartMargins = function () {
    return {
      top: 0,
      right: 50,
      bottom: 0,
      left: 70
    };
  };

  /**
   *
   */
  LoadDurationChart.prototype.init = function () {
    this.minValue = baja.Float.MAX_VALUE.valueOf();
    this.maxValue = baja.Float.MIN_VALUE.valueOf();
    this.minDuration = baja.Float.MAX_VALUE.valueOf();
    this.maxDuration = baja.Float.MIN_VALUE.valueOf();
    this.interval = -1;
    this.series = [];
  };

  /**
   *
   * @param text
   * @returns {*}
   */
  LoadDurationChart.prototype.getXAxisLabel = function (text) {
    return lex.get("chart.loadduration.xaxis.label");
  };

  /**
   *
   * @param x
   * @returns {*}
   */
  LoadDurationChart.prototype.getXTickFormat = function (x) {
    return analyticsUtil.formatAsHoursAndMinutes(x);
  };

  /**
   *
   * @returns {string[]}
   */
  LoadDurationChart.prototype.getColumnNames = function () {
    var arr = ['Hours'],
      that = this,
      chartModelList = that.chartModelList;
    _.each(chartModelList, function (chartModel, index) {
      var sn = baja.SlotPath.unescape(chartModel.getSeriesName()),
        unit = chartModel.getUnitDisplay();
      if (unit && unit !== "null") {
        arr.push(lex.get({
          key: 'report.loadduration.colformat',
          args: [sn, unit]
        }));
      } else {
        arr.push(sn);
      }
      arr.push(sn + " " + lex.get("chart.interpolationStatus.label"));
    });
    that.columnNames = arr;
    return arr;
  };

  /**
   *
   * @returns {string[]}
   */
  LoadDurationChart.prototype.getColumnKeys = function () {
    var arr = ['date'],
      that = this,
      chartModelList = that.chartModelList;
    _.each(chartModelList, function (chartModel, index) {
      var sn = chartModel.getSeriesName();
      arr.push(sn);
      arr.push(sn + "interpolationStatus");
    });
    that.columnKeys = arr;
    return arr;
  };
  LoadDurationChart.prototype.getDefaultSettings = function () {
    var defObj = AnalyticC3BaseChart.prototype.getDefaultSettings.apply(this, arguments);
    defObj.chartType = "line";
    return defObj;
  };

  /**
   * Get Settings Editor Type
   * @returns {*}
   */
  LoadDurationChart.prototype.getSettingsEditorType = function () {
    return LoadDurationUxWebChartSettingsFE;
  };

  /**
   *
   * @returns {boolean}
   */
  LoadDurationChart.prototype.needsBreakOnOneIteration = function () {
    return true;
  };

  /**
   *
   * @param data
   * @param timeRange
   * @returns {*}
   */
  LoadDurationChart.prototype.buildModel = function (data, timeRange) {
    var model = AnalyticC3BaseChart.prototype.buildModel.apply(this, arguments);
    model.setShowOnY2(data.getShowOnY2());
    return model;
  };
  LoadDurationChart.prototype.getName = function () {
    return "LoadDurationChart";
  };
  LoadDurationChart.prototype.getDefaultOrdScheme = function () {
    return "analyticBaselineTrend:";
  };
  return LoadDurationChart;
});
