/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file: This file represents the settings window for the Web analytic charts
 * @author Upender Paravastu & Sai Komaravolu
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/chart/fe/AnalyticDataEditorFE', 'nmodule/analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE', 'hbs!nmodule/analytics/rc/chart/templates/fe/spectrumWebChartSettings', 'lex!baja,analytics', 'baja!webEditors:FrozenEnumEditor,webEditors:UnitEditor,webEditors:StringEditor,analytics:AnalyticDataEditor'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, events, fe, feDialogs, BaseEditor, AnalyticDataEditor, AnalyticUxWebChartSettingsFE, spectrumWebChartSettings, lexicon, types) {
  'use strict';

  var lex = lexicon[1];
  /**
   * A field editor for working with Settings of chart widget.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE
   */
  var SpectrumUxWebChartSettingsFE = function SpectrumUxWebChartSettingsFE() {
    AnalyticUxWebChartSettingsFE.apply(this, arguments);
  };
  // Inheriting AnalyticUxWebChartSettingsFE from BaseEditor
  SpectrumUxWebChartSettingsFE.prototype = Object.create(AnalyticUxWebChartSettingsFE.prototype);
  //Setting the constructor
  SpectrumUxWebChartSettingsFE.prototype.constructor = SpectrumUxWebChartSettingsFE;

  /**
   * Creates the necessary setting fields for configuring analytic web chart
   * @param {jQuery} dom
   */
  SpectrumUxWebChartSettingsFE.prototype.doInitialize = function (dom) {
    // Load all properties in to the template
    dom.html(spectrumWebChartSettings({
      interval: lex.get("interval"),
      rollup: lex.get("rollup"),
      aggregation: lex.get("aggregation"),
      unit: lex.get("unit"),
      data: lex.get("data"),
      dataFilter: lex.get("dataFilter"),
      brush1: lex.get("spectrum.brush1"),
      brush2: lex.get("spectrum.brush2"),
      seriesName: lex.get("seriesName"),
      daysToExclude: lex.get("daysToExclude"),
      hisTotEnabled: lex.get("hisTotEnabled"),
      mdhStrategy: lex.get("missingDataStrategy")
    }));
  };
  SpectrumUxWebChartSettingsFE.prototype.initFieldEditors = function (settingsObj) {
    var that = this;
    var fes = AnalyticUxWebChartSettingsFE.prototype.initFieldEditors.apply(that, [settingsObj]);
    fes.push({
      dom: $(".brush2", that.jq()),
      properties: {
        uxFieldEditor: 'gx:ColorEditor'
      },
      value: settingsObj.getBrush2(),
      keyName: "brush2",
      formFactor: "mini"
    });
    return fes;
  };
  return SpectrumUxWebChartSettingsFE;
});
