function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/wb/commands/SetHistoryDisplayNameCommand
 */
define(['baja!', 'lex!history', 'bajaux/commands/Command', 'Promise', 'nmodule/history/rc/servlet/historyRpc', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, lexs, Command, Promise, historyRpc, feDialogs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    historyLex = _lexs[0];
  var getHistoryDisplayNameFormat = historyRpc.getHistoryDisplayNameFormat,
    setHistoryDisplayNameFormat = historyRpc.setHistoryDisplayNameFormat;

  /**
   * Command for setting a History's display name.
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/history/rc/wb/commands/SetHistoryDisplayNameCommand
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_Command) {
    /**
     * @param {baja.NavNode} history a nav node representing a `history:IHistory`
     */
    function SetHistoryDisplayNameCommand(history) {
      var _this;
      _classCallCheck(this, SetHistoryDisplayNameCommand);
      _this = _callSuper(this, SetHistoryDisplayNameCommand, [{
        module: 'history',
        lex: 'commands.setHistoryDisplayName',
        undoable: function undoable() {
          return _this.$makeUndoable();
        }
      }]);
      _this.$history = history;
      return _this;
    }

    /**
     * @private
     * @returns {Promise.<module:bajaux/commands/Command~Undoable>} an undoable that will set this
     * history's display name or revert it to its previous display name.
     */
    _inherits(SetHistoryDisplayNameCommand, _Command);
    return _createClass(SetHistoryDisplayNameCommand, [{
      key: "$makeUndoable",
      value: function $makeUndoable() {
        var _this2 = this;
        var history = this.$history;
        return this.$getDisplayNameFormat().then(function (oldDisplayName) {
          var name = history.getNavName();
          return _this2.$promptForNewDisplayName(oldDisplayName).then(function (newDisplayName) {
            if (!newDisplayName) {
              return;
            }
            return {
              redo: function redo() {
                return _this2.$setDisplayNameFormat(newDisplayName);
              },
              undo: function undo() {
                return _this2.$setDisplayNameFormat(oldDisplayName);
              },
              redoText: historyLex.get({
                key: 'commands.setHistoryDisplayName.redoText',
                args: [name, oldDisplayName, newDisplayName]
              }),
              undoText: historyLex.get({
                key: 'commands.setHistoryDisplayName.undoText',
                args: [name, newDisplayName, oldDisplayName]
              })
            };
          });
        });
      }

      /**
       * @private
       * @param {string} oldDisplayName
       * @returns {Promise.<string|null>} user-entered new display name format, or null if they
       * canceled
       */
    }, {
      key: "$promptForNewDisplayName",
      value: function $promptForNewDisplayName(oldDisplayName) {
        return feDialogs.showFor({
          title: historyLex.get('commands.setHistoryDisplayName.description'),
          value: baja.Format.make(oldDisplayName),
          formFactor: 'mini'
        }).then(function (newFormat) {
          return newFormat && String(newFormat);
        });
      }

      /**
       * @private
       * @returns {Promise.<string>} this history's current display name format (empty if not
       * currently set)
       */
    }, {
      key: "$getDisplayNameFormat",
      value: function $getDisplayNameFormat() {
        return getHistoryDisplayNameFormat(this.$history).then(function (name) {
          return name || '';
        });
      }

      /**
       * @private
       * @param {string} displayNameFormat
       * @returns {Promise} to be resolved after this history has had a new display name format set
       */
    }, {
      key: "$setDisplayNameFormat",
      value: function $setDisplayNameFormat(displayNameFormat) {
        return setHistoryDisplayNameFormat(this.$history, displayNameFormat);
      }
    }]);
  }(Command);
});
