/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/util/CertTabContextMenuSupport
 */
define(['underscore', 'bajaux/commands/CommandGroup', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (_, CommandGroup, ContextMenuSupport, mixinUtils) {
  'use strict';

  var exports = {};
  var MIXIN_NAME = 'certTabContextMenuSupport';
  var applyMixin = mixinUtils.applyMixin;

  /**
   * Returns the key used to determine if the context menu should be attached to a specific dom element
   *
   * @returns {String}
   */
  exports.getContextMenuSelector = function () {
    return 'tr';
  };

  /**
   * Takes the existing command group commands and add them to the context menu if they are enabled
   *
   * @returns {module:bajaux/commands/CommandGroup}
   */
  exports.toContextMenuCommandGroup = function () {
    var cmds = this.getCommandGroup().flatten().filter(function (cmd) {
      return _.result(cmd, 'isEnabled');
    });
    return new CommandGroup({
      commands: cmds
    });
  };

  /**
   * This mixin adds support for context menus to the tables in the certificate tabs.  In doing so
   *  it implements and adds three functions to tabs.
   *
   *  - 'getContextMenuSelector()' : Returns the 'tr' CSS selector used to select the tables
   *      defined in the tab.
   *  - 'toContextMenuCommandGroup()' : Returns a command group of the currently enabled commands for
   *      the tab.
   *
   * In addition to implementing those functions it also adds the ContexMenuSupport mix-in to the
   *  tabs.
   *
   * @alias module:nmodule/platCrypto/rc/wb/cert/util/CertTabContextMenuSupport
   * @param {module:bajaux/Widget} target
   * @param {object} params
   * @param {string} [params.menuModuleId=nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu] a
   *    custom subclass of `CommandGroupContextMenu` can be used instead if desired.
   */
  function addCertTabContextMenuSupport(target, params) {
    ContextMenuSupport(target, params);
    applyMixin(target, MIXIN_NAME, exports);
  }
  return addCertTabContextMenuSupport;
});
