function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnetOws/rc/wb/mgr/commands/GetEventInformationCommand
 */
define(['baja!', 'baja!bacnetOws:GetEventInfoConfig,bacnetOws:GetEventInformationJob', 'lex!bacnetOws', 'bajaux/commands/Command', 'dialogs', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand'], function (baja, types, lexs, Command, dialogs, $, Promise, _, mgrUtils, MgrCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bacnetOwsLex = _lexs[0];
  var getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects;
  var _MgrCommand$flags = MgrCommand.flags,
    ALL_BARS = _MgrCommand$flags.ALL_BARS,
    MAIN_CONTEXT_MENU = _MgrCommand$flags.MAIN_CONTEXT_MENU;
  var GET_ALARM_SUMMARY_SERVICE_CHOICE = 3;
  var GET_EVENT_INFORMATION_SERVICE_CHOICE = 29;
  function getFirstSelectedDevice(mgr) {
    var selection = getMainTableSelectedSubjects(mgr),
      folderType = mgr.getModel().getFolderType();
    function isNotFolder(c) {
      return !c.getType().is(folderType);
    }
    return _.first(_(selection).filter(isNotFolder));
  }

  /**
   * Convenience for getting a device id from a BacnetDevice instance.
   */
  function getDeviceId(dev) {
    return dev.getConfig().getDeviceObject().getObjectId();
  }

  /**
   * Convenience for getting all the string slots from the job. This is how
   * the event information is passed back.
   */
  function getStrings(job) {
    return job.getSlots().properties().is('baja:String').toValueArray();
  }

  /**
   * Command type to invoke a BGetEventInformationJob on the station and obtain the results
   * from dynamic slots on the job when it completes. The job will determine the services
   * supported by the device - initially trying to use a 'getEventInformation' request,
   * and, if that's not available, then trying a 'getAlarmSummary'. When the job completes
   * the handler in this command will look to see which service was actually used, which
   * will affect how it interprets the results.
   *
   * @class
   * @alias module:nmodule/bacnetOws/rc/wb/mgr/commands/GetEventInformationCommand
   * @extends module:bajaux/commands/Command
   */
  var GetEventInformationCommand = function GetEventInformationCommand(mgr) {
    var that = this;
    Command.call(this, {
      displayName: bacnetOwsLex.get('getEventInfo.label'),
      icon: bacnetOwsLex.get('getEventInfo.icon'),
      description: bacnetOwsLex.get('getEventInfo.description'),
      enabled: false,
      flags: ALL_BARS | MAIN_CONTEXT_MENU,
      /**
       * Invoke the command - this will cause a bacnetOws:GetEventInformationJob to
       * be submitted.
       *
       * @alias module:nmodule/bacnet/rc/wb/mgr/commands/GetEventInformationCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        return dialogs.showOkCancel({
          title: bacnetOwsLex.get('getEventInfo.label'),
          text: bacnetOwsLex.get('getEventInfo.confirm')
        }).ok(function () {
          var config,
            network = mgr.getNetwork(),
            device = getFirstSelectedDevice(mgr);
          return Promise["try"](function () {
            if (device) {
              config = baja.$('bacnetOws:GetEventInfoConfig');
              config.setObjectId(getDeviceId(device));
              return network.submitDeviceManagerJob(config).then(function (ord) {
                return mgr.setJob(baja.Ord.make({
                  base: baja.Ord.make('station:'),
                  child: ord.relativizeToSession()
                }));
              });
            }
          })["catch"](function (err) {
            dialogs.showOk({
              title: bacnetOwsLex.get('getEventInfo.title'),
              text: bacnetOwsLex.get('getEventInfo.fail', String(err))
            });
          });
        }).promise();
      }
    });
    mgr.on('jobcomplete', function (job) {
      if (job.getType().is('bacnetOws:GetEventInformationJob')) {
        that.complete(job);
      }
    });
  };
  GetEventInformationCommand.prototype = Object.create(Command.prototype);
  GetEventInformationCommand.prototype.constructor = GetEventInformationCommand;
  GetEventInformationCommand.GET_ALARM_SUMMARY_SERVICE_CHOICE = GET_ALARM_SUMMARY_SERVICE_CHOICE;
  GetEventInformationCommand.GET_EVENT_INFORMATION_SERVICE_CHOICE = GET_EVENT_INFORMATION_SERVICE_CHOICE;

  /**
   * In the event of a failure (e.g. something went wrong sending the request or the device
   * supports neither of the 'getEventInformation' or 'getAlarmSummary' services), the job will
   * place some error text in a dynamic property. This will look for that property and return
   * it, or the empty string if not found.
   *
   * @param {baja.Component} job
   * @returns {string}
   */
  function getFailureCause(job) {
    var cause = job.get('failureCause');
    if (cause === null) {
      cause = '';
    }
    return cause;
  }
  function displayDialogForFailureCause(job) {
    dialogs.showOk({
      title: bacnetOwsLex.get('getEventInfo.title'),
      text: bacnetOwsLex.get('getEventInfo.fail', getFailureCause(job))
    });
  }

  /**
   * Tokenize a single event information string and append it to the results string to
   * be displayed in a dialog.
   *
   * @param {string} results - the string being built containing all the combined event information strings.
   * @param {string} info - an alarm summary response, tokenized by '|' characters.
   * @param {number} index - the index of the event info in the results array.
   * @returns {string} - the results string with the additional info appended.
   */
  function formatEventInfoText(results, info, index) {
    var tokens = info.split('|');
    if (tokens.length < 11) {
      return 'Cannot parse: ' + info;
    }
    if (index > 0) {
      results += '\n';
    }
    return results + bacnetOwsLex.get.apply(bacnetOwsLex, ['getEventInfo.eventInfoFormat'].concat(tokens));
  }

  /**
   * Display the results when the job's service choice property is the 'GET_EVENT_INFORMATION'
   * service.
   *
   * @param {baja.Component} job - a GetEventInformationJob instance
   */
  function displayEventInformationResults(job) {
    dialogs.showOk({
      title: bacnetOwsLex.get('getEventInfo.title'),
      content: function content(dlg) {
        var events = getStrings(job),
          jq = dlg.content();
        jq.append($('<span>').text(bacnetOwsLex.get('getEventInfo.header') + '\n')).append($('<pre>').text(_(events).reduce(formatEventInfoText, '')));
      }
    });
  }

  /**
   * Tokenize a single alarm summary string and append it to the results string to
   * be displayed in a dialog.
   *
   * @param {string} results - the string being built containing all the combined summary strings.
   * @param {string} summary - an alarm summary response, tokenized by '|' characters.
   * @param {number} index - the index of the alarm summary in the results array.
   * @returns {string} the results string with the additional summary appended.
   */
  function formatAlarmSummary(results, summary, index) {
    var tokens = summary.split('|');
    if (tokens.length < 3) {
      return 'Cannot parse: ' + summary;
    }
    if (index > 0) {
      results += '\n';
    }
    return results + bacnetOwsLex.get.apply(bacnetOwsLex, ['getASumm.alarmSummaryFormat'].concat(tokens));
  }

  /**
   * Display the results when the job's service choice property is the 'GET_ALARM_SUMMARY'
   * service. This involves displaying a warning dialog before the results. The results
   * are stored as dynamic string properties on the job.
   *
   * @param {baja.Component} job - a GetEventInformationJob instance
   */
  function displayAlarmSummaryResults(job) {
    dialogs.showOk({
      title: bacnetOwsLex.get('getEventInfo.title'),
      content: function content(dlg) {
        var jq = dlg.content();
        jq.append($('<span>').text(bacnetOwsLex.get('getEventInfo.unsupported') + '\n')).append($('<br>')).append($('<span>').text(bacnetOwsLex.get('getEventInfo.alarmSummary') + '\n')).append($('<br>')).append($('<span>').text('(' + bacnetOwsLex.get('getASumm.warning') + ')'));
      }
    }).ok(function () {
      var alarms = getStrings(job);
      dialogs.showOk({
        title: bacnetOwsLex.get('getASumm.title'),
        content: function content(dlg) {
          var jq = dlg.content();
          jq.append($('<span>').text(bacnetOwsLex.get('getASumm.header') + '\n')).append($('<pre>').text(_(alarms).reduce(formatAlarmSummary, '')));
        }
      });
    });
  }

  /**
   * Called when the submitted job is complete. Will obtain the results from
   * the encoded string properties of the job and display a dialog. This will
   * check the service that was used, depending on the device's supported set.
   *
   * @static
   * @param {baja.Component} job
   */
  GetEventInformationCommand.prototype.complete = function (job) {
    return job.loadSlots().then(function () {
      if (job.getJobState().getTag() === 'success') {
        switch (job.getServiceChoice()) {
          case GET_EVENT_INFORMATION_SERVICE_CHOICE:
            {
              displayEventInformationResults(job);
              break;
            }
          case GET_ALARM_SUMMARY_SERVICE_CHOICE:
            {
              displayAlarmSummaryResults(job);
              break;
            }
          default:
            {
              displayDialogForFailureCause(job);
              break;
            }
        }
      } else {
        displayDialogForFailureCause(job);
      }
    });
  };
  return GetEventInformationCommand;
});
