function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/modbusCore/rc/mgr/model/ModbusPointManagerModel
 */
define(['baja!', 'baja!control:ControlPoint,' + 'control:EnumPoint,' + 'control:EnumWritable,' + 'driver:ProxyExt,' + 'modbusCore:EnumBitsPoint,' + 'modbusCore:EnumBitsWritable,' + 'modbusCore:IModbusBooleanProxyExt,' + 'modbusCore:IModbusEnumBitsProxyExt,' + 'modbusCore:IModbusNumericBitsProxyExt,' + 'modbusCore:IModbusRegisterBitProxyExt,' + 'modbusCore:ModbusClientBooleanProxyExt,' + 'modbusCore:ModbusClientNumericBitsProxyExt,' + 'modbusCore:ModbusClientNumericProxyExt,' + 'modbusCore:ModbusClientPointFolder,' + 'modbusCore:ModbusClientProxyExt,' + 'modbusCore:ModbusClientRegisterBitProxyExt,' + 'modbusCore:ModbusClientStringProxyExt,' + 'modbusCore:ModbusProxyExt,' + 'modbusCore:NumericBitsPoint,' + 'modbusCore:NumericBitsWritable,' + 'modbusCore:RegisterBitPoint,' + 'modbusCore:RegisterBitWritable,' + 'modbusCore:RegisterTypeEnum,' + 'modbusCore:StatusTypeEnum', 'lex!driver,modbusCore', 'Promise', 'underscore', 'nmodule/driver/rc/wb/mgr/PointMgrModel', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/table/model/columns/ToStringColumn', 'nmodule/modbusCore/rc/util/dataTypeUtil'], function (baja, types, lexs, Promise, _, PointMgrModel, typeUtils, MgrTypeInfo, NameMgrColumn, PathMgrColumn, PropertyMgrColumn, PropertyPathMgrColumn, TypeMgrColumn, Column, IconColumn, ToStringColumn, dataTypeUtil) {
  'use strict';

  var _Column$flags = Column.flags,
    UNSEEN = _Column$flags.UNSEEN,
    EDITABLE = _Column$flags.EDITABLE;
  var _lexs = _slicedToArray(lexs, 2),
    driverLex = _lexs[0],
    modbusCoreLex = _lexs[1];
  var hasType = baja.hasType;
  var getRegisterCount = dataTypeUtil.getRegisterCount;
  var BOOLEAN_EXT_TYPE = baja.lt('modbusCore:ModbusClientBooleanProxyExt');
  var CONTROL_POINT_TYPE = baja.lt('control:ControlPoint');
  var MODBUS_CLIENT_PROXY_EXT_TYPE = baja.lt('modbusCore:ModbusClientProxyExt');
  var MODBUS_PROXY_EXT_TYPE = baja.lt('modbusCore:ModbusProxyExt');
  var NUMERIC_BITS_PROXY_EXT_TYPE = baja.lt('modbusCore:ModbusClientNumericBitsProxyExt');
  var NUMERIC_PROXY_EXT_TYPE = baja.lt('modbusCore:ModbusClientNumericProxyExt');
  var PROXY_EXT_TYPE = baja.lt('driver:ProxyExt');
  var REGISTER_BIT_PROXY_EXT_TYPE = baja.lt('modbusCore:ModbusClientRegisterBitProxyExt');
  var STRING_PROXY_EXT_TYPE = baja.lt('modbusCore:ModbusClientStringProxyExt');

  /**
   * Return `true` if the given argument is one of the writable control point types.
   *
   * @param {baja.Component} pt - a `control:ControlPoint` instance.
   * @returns {boolean}
   */
  function isWritablePoint(pt) {
    var type = pt.getType().toString();
    return /^control:.+Writable$/.test(type);
  }
  var ModbusTypeColumn = /*#__PURE__*/function (_TypeMgrColumn) {
    function ModbusTypeColumn() {
      _classCallCheck(this, ModbusTypeColumn);
      return _callSuper(this, ModbusTypeColumn, arguments);
    }
    _inherits(ModbusTypeColumn, _TypeMgrColumn);
    return _createClass(ModbusTypeColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        var value = _superPropGet(ModbusTypeColumn, "getValueFor", this, 3)(arguments);
        var controlPoint = row.getSubject();
        var isWritable = isWritablePoint(controlPoint);
        var proxyExt = controlPoint.getProxyExt();
        var type;
        if (hasType(proxyExt, 'modbusCore:IModbusEnumBitsProxyExt')) {
          type = isWritable ? 'modbusCore:EnumBitsWritable' : 'modbusCore:EnumBitsPoint';
        } else if (hasType(proxyExt, 'modbusCore:IModbusNumericBitsProxyExt')) {
          type = isWritable ? 'modbusCore:NumericBitsWritable' : 'modbusCore:NumericBitsPoint';
        } else if (hasType(proxyExt, 'modbusCore:IModbusRegisterBitProxyExt')) {
          type = isWritable ? 'modbusCore:RegisterBitWritable' : 'modbusCore:RegisterBitPoint';
        }
        if (type) {
          return baja.lt(type);
        }
        return value;
      }
    }]);
  }(TypeMgrColumn);
  var ModbusCoreColumn = /*#__PURE__*/function (_PropertyPathMgrColum) {
    function ModbusCoreColumn(name, params) {
      var _this;
      _classCallCheck(this, ModbusCoreColumn);
      _this = _callSuper(this, ModbusCoreColumn, arguments);
      _this.$isModbusServer = params.isModbusServer;
      return _this;
    }
    _inherits(ModbusCoreColumn, _PropertyPathMgrColum);
    return _createClass(ModbusCoreColumn, [{
      key: "coalesceRows",
      value: function coalesceRows(rows) {
        var _this2 = this;
        rows.forEach(function (row) {
          var container = _this2.getComplexFromPath(row);
          var prop = _this2.getPropertyName();
          var writablePoint = isWritablePoint(container.getParent());
          if (!container.has(prop) || writablePoint && !_this2.$isModbusServer && (prop === 'regType' || prop === 'statusType')) {
            throw new Error('cannot edit slot: ' + _this2.getName());
          }
        });
        return _superPropGet(ModbusCoreColumn, "coalesceRows", this, 3)([rows]);
      }
    }]);
  }(PropertyPathMgrColumn);
  function getColumns(_ref) {
    var isModbusServer = _ref.isModbusServer;
    var colIcon = new IconColumn();
    var colPath = new PathMgrColumn({
      flags: UNSEEN
    });
    var colName = new NameMgrColumn({
      flags: EDITABLE
    });
    var colType = new ModbusTypeColumn({
      flags: EDITABLE | UNSEEN
    });
    var colValue = new ToStringColumn('out', {
      displayName: driverLex.get('out')
    });
    var colPollFreq = new PropertyPathMgrColumn('proxyExt/pollFrequency', {
      type: MODBUS_PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN
    });
    var colDataAddress = new PropertyPathMgrColumn('proxyExt/dataAddress', {
      type: MODBUS_PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN
    });
    var colDeviceFacets = new PropertyPathMgrColumn('proxyExt/deviceFacets', {
      type: PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN
    });
    var colFacets = new PropertyPathMgrColumn('facets', {
      type: CONTROL_POINT_TYPE,
      flags: EDITABLE | UNSEEN
    });
    var colConversion = new PropertyPathMgrColumn('proxyExt/conversion', {
      type: PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN
    });
    var colEnabled = new PropertyPathMgrColumn('proxyExt/enabled', {
      type: PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN
    });
    var colDeviceValue = new PropertyPathMgrColumn('proxyExt/readValue', {
      type: PROXY_EXT_TYPE,
      flags: UNSEEN
    });
    var colExeResult = new PropertyPathMgrColumn('proxyExt/writeValue', {
      type: PROXY_EXT_TYPE,
      flags: UNSEEN
    });
    var colTuning = new PropertyPathMgrColumn('proxyExt/tuningPolicyName', {
      type: PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN
    });
    var colFaultCause = new PropertyPathMgrColumn('proxyExt/faultCause', {
      type: PROXY_EXT_TYPE,
      flags: UNSEEN
    });
    var colAbsAddress = new PropertyPathMgrColumn('proxyExt/absoluteAddress', {
      type: MODBUS_CLIENT_PROXY_EXT_TYPE,
      displayName: modbusCoreLex.get('table.columnTitle.absAddress'),
      getDefaultValue: function getDefaultValue() {
        return '';
      }
    });
    var colRegType = new ModbusCoreColumn('proxyExt/regType', {
      type: NUMERIC_PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN,
      displayName: modbusCoreLex.get('table.columnTitle.regType'),
      getDefaultValue: function getDefaultValue() {
        return '';
      },
      isModbusServer: isModbusServer
    });
    var colDataType = new ModbusCoreColumn('proxyExt/dataType', {
      type: NUMERIC_PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN,
      displayName: modbusCoreLex.get('table.columnTitle.dataType'),
      getDefaultValue: function getDefaultValue() {
        return '';
      },
      isModbusServer: isModbusServer
    });
    var colStatusType = new ModbusCoreColumn('proxyExt/statusType', {
      type: BOOLEAN_EXT_TYPE,
      flags: EDITABLE | UNSEEN,
      displayName: modbusCoreLex.get('table.columnTitle.statusType'),
      getDefaultValue: function getDefaultValue() {
        return '';
      },
      isModbusServer: isModbusServer
    });
    var colBitNumber = new ModbusCoreColumn('proxyExt/bitNumber', {
      type: REGISTER_BIT_PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN,
      displayName: modbusCoreLex.get('table.columnTitle.bitNumber'),
      getDefaultValue: function getDefaultValue() {
        return '';
      },
      isModbusServer: isModbusServer
    });
    var colBeginningBit = new ModbusCoreColumn('proxyExt/beginningBit', {
      type: NUMERIC_BITS_PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN,
      displayName: modbusCoreLex.get('table.columnTitle.beginningBit'),
      getDefaultValue: function getDefaultValue() {
        return '';
      },
      isModbusServer: isModbusServer
    });
    var colNumberOfBits = new ModbusCoreColumn('proxyExt/numberOfBits', {
      type: NUMERIC_BITS_PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN,
      displayName: modbusCoreLex.get('table.columnTitle.numberOfBits'),
      getDefaultValue: function getDefaultValue() {
        return '';
      },
      isModbusServer: isModbusServer
    });
    var colDataSource = new ModbusCoreColumn('proxyExt/dataSource', {
      type: MODBUS_CLIENT_PROXY_EXT_TYPE,
      flags: UNSEEN,
      displayName: modbusCoreLex.get('table.columnTitle.dataSource'),
      getDefaultValue: function getDefaultValue() {
        return '';
      },
      isModbusServer: isModbusServer
    });
    var colNumRegisters = new ModbusCoreColumn('proxyExt/numberRegisters', {
      type: STRING_PROXY_EXT_TYPE,
      flags: EDITABLE | UNSEEN,
      displayName: modbusCoreLex.get('table.columnTitle.numberRegisters'),
      getDefaultValue: function getDefaultValue() {
        return '';
      },
      isModbusServer: isModbusServer
    });
    var clientColumns = [colIcon, colPath, colName, colType, colValue, colEnabled, colTuning, colAbsAddress, colFaultCause, colPollFreq, colDataAddress, colRegType, colDataType, colStatusType, colBitNumber, colBeginningBit, colNumberOfBits, colDataSource, colNumRegisters, colDeviceFacets, colFacets, colConversion, colDeviceValue, colExeResult];
    var serverColumns = [colIcon, colPath, colName, colType, colValue, colEnabled, colTuning, colPollFreq, colDataAddress, colFaultCause, colRegType, colDataType, colStatusType, colBitNumber, colBeginningBit, colNumberOfBits, colDeviceFacets, colFacets, colConversion, colDeviceValue, colExeResult];
    return isModbusServer ? serverColumns : clientColumns;
  }
  function getNewTypes(isModbusServer) {
    var types = [];
    PointMgrModel.addBooleanPointTypes(true, types);
    PointMgrModel.addNumericPointTypes(true, types);
    types.push('modbusCore:RegisterBitWritable');
    types.push('modbusCore:RegisterBitPoint');
    if (!isModbusServer) {
      PointMgrModel.addStringPointTypes(false, types);
      types.push('modbusCore:EnumBitsWritable');
      types.push('modbusCore:EnumBitsPoint');
      types.push('modbusCore:NumericBitsWritable');
      types.push('modbusCore:NumericBitsPoint');
    }
    return MgrTypeInfo.make(types);
  }
  function getRegType(address) {
    if (address.isModbusFormat()) {
      if (address.isModbusHoldingAddress()) {
        return baja.$('modbusCore:RegisterTypeEnum', 'holding');
      } else if (address.isModbusInputAddress()) {
        return baja.$('modbusCore:RegisterTypeEnum', 'input');
      }
    }
  }

  /**
   * Represents the model backing the Modbus Point Manager
   *
   * @class
   * @extends module:nmodule/driver/rc/wb/mgr/PointMgrModel
   * @alias module:nmodule/modbusCore/rc/mgr/model/ModbusPointManagerModel
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_PointMgrModel) {
    function ModbusPointManagerModel(params) {
      var _this3;
      _classCallCheck(this, ModbusPointManagerModel);
      _this3 = _callSuper(this, ModbusPointManagerModel, arguments);
      _this3.$isModbusServer = params.isModbusServer || false;
      return _this3;
    }

    /**
     * @return {boolean}
     */
    _inherits(ModbusPointManagerModel, _PointMgrModel);
    return _createClass(ModbusPointManagerModel, [{
      key: "isModbusServer",
      value: function isModbusServer() {
        return this.$isModbusServer;
      }

      /**
       * @param {module:nmodule/webEditors/rc/wb/mgr/commands/NewCommand~params} params
       * @returns {Promise}
       */
    }, {
      key: "newInstances",
      value: function newInstances(params) {
        var _this4 = this;
        var count = params.count;
        return Promise.all(Array(count).fill().map(function (value, index) {
          var instanceParams = Object.assign({
            index: index
          }, params);
          return _this4.$newInstance(instanceParams);
        }));
      }

      /**
       * @override
       */
    }, {
      key: "newInstance",
      value: function newInstance(typeInfo) {
        var index = 0,
          startAddress = baja.$('modbusCore:FlexAddress'),
          dataType = baja.$('modbusCore:DataTypeEnum');
        return this.$newInstance({
          typeInfo: typeInfo,
          index: index,
          startAddress: startAddress,
          dataType: dataType
        });
      }

      /**
       *
       * @private
       * @param {module:nmodule/webEditors/rc/wb/mgr/commands/NewCommand~params} params
       * @returns {Promise}
       */
    }, {
      key: "$newInstance",
      value: function $newInstance(_ref2) {
        var _this5 = this;
        var typeInfo = _ref2.typeInfo,
          index = _ref2.index,
          startAddress = _ref2.startAddress,
          dataType = _ref2.dataType;
        var offset = index;
        return typeInfo.newInstance().then(function (point) {
          var pointType = point.getType(),
            proxyExtType = '';
          var isModbusServer = _this5.isModbusServer();
          var address;
          var bitNumber;
          var regType;
          var statusType;
          var beginningBit;
          var proxyDataType;
          if (!pointType.is('control:ControlPoint')) {
            address = baja.$('modbusCore:FlexAddress');
            address.setAddressFormat(startAddress.getAddressFormat());
            address.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + Math.floor(offset / 16));
            regType = getRegType(address);
          }
          if (pointType.is('modbusCore:RegisterBitPoint') || pointType.is('modbusCore:RegisterBitWritable')) {
            pointType = pointType.is('modbusCore:RegisterBitWritable') ? 'control:BooleanWritable' : 'control:BooleanPoint';
            proxyExtType = 'modbusCore:Modbus' + (isModbusServer ? 'Server' : 'Client') + 'RegisterBitProxyExt';
            bitNumber = offset % 16;
          } else if (pointType.is('modbusCore:EnumBitsPoint') || pointType.is('modbusCore:EnumBitsWritable')) {
            pointType = pointType.is('modbusCore:EnumBitsWritable') ? 'control:EnumWritable' : 'control:EnumPoint';
            proxyExtType = isModbusServer ? 'control:NullProxyExt' : 'modbusCore:ModbusClientEnumBitsProxyExt';
            if (!isModbusServer) {
              beginningBit = offset % 16;
            }
          } else if (pointType.is('modbusCore:NumericBitsPoint') || pointType.is('modbusCore:NumericBitsWritable')) {
            pointType = pointType.is('modbusCore:NumericBitsWritable') ? 'control:NumericWritable' : 'control:NumericPoint';
            proxyExtType = isModbusServer ? 'control:NullProxyExt' : 'modbusCore:ModbusClientNumericBitsProxyExt';
            if (!isModbusServer) {
              beginningBit = offset % 16;
            }
          } else if (pointType.is('control:BooleanPoint')) {
            proxyExtType = 'modbusCore:Modbus' + (isModbusServer ? 'Server' : 'Client') + 'BooleanProxyExt';
            address = baja.$('modbusCore:FlexAddress');
            address.setAddressFormat(startAddress.getAddressFormat());
            address.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset);
            if (address.isModbusFormat()) {
              if (address.isModbusCoilAddress()) {
                statusType = baja.$('modbusCore:StatusTypeEnum', 'coil');
              } else if (address.isModbusInputAddress()) {
                statusType = baja.$('modbusCore:StatusTypeEnum', 'input');
              }
            }
          } else if (pointType.is('control:NumericPoint')) {
            proxyExtType = 'modbusCore:Modbus' + (isModbusServer ? 'Server' : 'Client') + 'NumericProxyExt';
            address = baja.$('modbusCore:FlexAddress');
            address.setAddressFormat(startAddress.getAddressFormat());
            address.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset);
            proxyDataType = dataType;
            address.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset * getRegisterCount(dataType));
            regType = getRegType(address);
          } else if (pointType.is('control:StringPoint')) {
            proxyExtType = isModbusServer ? 'control:NullProxyExt' : 'modbusCore:ModbusClientStringProxyExt';
            if (!isModbusServer) {
              address = baja.$('modbusCore:FlexAddress');
              address.setAddressFormat(startAddress.getAddressFormat());
              address.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset);
            }
          } else {
            throw new Error("UnexpectedType: " + pointType);
          }
          point = baja.$(pointType);
          return baja.importTypes([proxyExtType]).then(function () {
            var proxyExt = baja.$(proxyExtType);
            if (_.isFunction(proxyExt.setDeviceFacets)) {
              proxyExt.setDeviceFacets(point.get('facets').newCopy());
            }
            point.setProxyExt(proxyExt);
            if (address !== undefined && _.isFunction(proxyExt.setDataAddress)) {
              proxyExt.setDataAddress(address);
            }
            if (bitNumber !== undefined) {
              proxyExt.setBitNumber(bitNumber);
            }
            if (regType !== undefined) {
              proxyExt.setRegType(regType);
            }
            if (statusType !== undefined) {
              proxyExt.setStatusType(statusType);
            }
            if (beginningBit !== undefined) {
              proxyExt.setBeginningBit(beginningBit);
            }
            if (proxyDataType !== undefined) {
              proxyExt.setDataType(proxyDataType);
            }
            return point;
          });
        });
      }

      /**
       * Makes the main model.
       * @param {baja.Component} component
       * @param {Object} params
       * @returns {Promise<module:nmodule/modbusCore/rc/mgr/model/ModbusPointManagerModel>}
       */
    }], [{
      key: "make",
      value: function make(component, params) {
        var folderType = params.folderType,
          proxyExtType = params.proxyExtType,
          isModbusServer = params.isModbusServer;
        isModbusServer = isModbusServer || false;
        return getNewTypes(isModbusServer).then(function (newTypes) {
          return new ModbusPointManagerModel({
            component: component,
            columns: getColumns({
              isModbusServer: isModbusServer
            }),
            folderType: folderType,
            newTypes: newTypes,
            proxyExtType: proxyExtType,
            isModbusServer: isModbusServer
          });
        });
      }
    }]);
  }(PointMgrModel);
});
