/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'baja!videoDriver:VideoCompressionEnum,videoDriver:VideoFrameRateEnum,' + 'videoDriver:VideoResolutionEnum', 'underscore'], function (baja, types, _) {
  'use strict';

  var isNumber = _.isNumber,
    isString = _.isString;

  /**
   * API Status: **Private**
   * @exports module:nmodule/xprotect/rc/xprotect/xprotectUtils
   */
  var exports = {};

  /**
   * Converts from `videoDriver:VideoCompressionEnum` to a JPEG compression
   * level (0-100 where 100 is best quality).
   * @param {number|string|baja.Enum} en
   * @returns {number}
   */
  exports.getJpegCompressionLevel = function (en) {
    if (isNumber(en)) {
      return en;
    }
    switch (toTag(en, 'videoDriver:VideoCompressionEnum')) {
      case 'none':
        return 100;
      case 'low':
        return 75;
      case 'medium':
        return 50;
      case 'high':
        return 25;
    }
  };

  /**
   * Converts from `videoDriver:VideoFrameRateEnum` to FPS.
   * @param {number|string|baja.Enum} en
   * @returns {number}
   */
  exports.getFps = function (en) {
    if (typeof en === 'number') {
      return en;
    }
    switch (toTag(en, 'videoDriver:VideoFrameRateEnum')) {
      case 'low':
        return 5;
      case 'medium':
        return 10;
      case 'high':
        return 15;
    }
  };

  /**
   * Converts from `videoDriver:VideoResolutionEnum` to a pixel multiplier.
   * @param {number|string|baja.Enum} en
   * @returns {number}
   */
  exports.getPixelMultiplier = function (en) {
    if (typeof en === 'number') {
      return en;
    }
    switch (toTag(en, 'videoDriver:VideoResolutionEnum')) {
      case 'low':
        return 3;
      case 'medium':
        return 2;
      case 'high':
        return 1;
    }
  };
  function requireType(en, type) {
    if (!baja.hasType(en, type)) {
      throw new Error(type + ' required');
    }
  }
  function toTag(en, type) {
    if (isString(en)) {
      en = baja.$(type, en);
    }
    requireType(en, type);
    return en.getTag();
  }
  return exports;
});
