/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */
/* exported doSubmit */
/* exported updateSubmitButton */
/* global sjcl, checkPasswords */

function doSubmit() {
  "use strict";
  var newPassword = document.getElementById("new-password");
  var confirmPassword = document.getElementById("confirm-password");
  var token = document.getElementById("token");

  if (newPassword.parentElement.style.display !== "none") {
    if (newPassword.value !== confirmPassword.value) {
      alert('Passwords do not match.');
      return false;
    }

    var newPasswordBits = sjcl.codec.utf8String.toBits(newPassword.value);
    document.getElementById("resetToken").value = sjcl.codec.base64.fromBits(newPasswordBits);
  }

  if (token.parentElement.style.display !== "none") {
    var tokenBits = sjcl.codec.utf8String.toBits(token.value);
    document.getElementById("confirmToken").value = sjcl.codec.base64.fromBits(tokenBits);
  }

  // Nuke these textfields just in case a custom template
  // assigned 'name' attributes, which would send these
  // values over the wire in plain text
  document.getElementById("new-password").value = "";
  document.getElementById("confirm-password").value = "";
  document.getElementById("token").value = "";

  document.forms[0].submit();

  return false;
}

function updateSubmitButton(passwordStrength) {
  "use strict";

  var token = document.getElementById("token"),
    password = document.getElementById("new-password"),
    submitButton = document.getElementById("login-submit");

  submitButton.disabled = false;
  // Call checkPasswords, which will enable the Submit button if the passwords meet
  // the password strength requirements as match, and disable it otherwise.
  if (password.parentElement.style.display !== "none") {
    checkPasswords(passwordStrength);
  }

  // If the token has the wrong length, or the button was already disabled due to
  // the password check, disable the button.
  if (token.parentElement.style.display !== "none") {
    submitButton.disabled = submitButton.disabled || token.value.length !== 6;
  }
}
