function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/lonworks/rc/wb/mgr/UxLonPointManager
 */

define(['baja!', 'baja!lonworks:LonPointDeviceExt', 'bajaux/mixin/subscriberMixIn', 'Promise', 'underscore', 'nmodule/driver/rc/wb/mgr/PointMgr', 'nmodule/driver/rc/wb/mgr/PointMgrModel', 'nmodule/driver/rc/wb/mgr/point/PointLearnNode', 'nmodule/lonworks/rc/wb/mgr/model/LonPointLearnModel', 'nmodule/lonworks/rc/wb/mgr/model/LonPointManagerModel', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/commands/LearnModeCommand', 'nmodule/webEditors/rc/wb/mgr/commands/MatchCommand', 'nmodule/webEditors/rc/wb/mgr/commands/NewCommand', 'nmodule/webEditors/rc/wb/mgr/componentStatusUtils'], function (baja, types, subscribable, Promise, _, PointMgr, PointMgrModel, PointLearnNode, LonPointLearnModel, LonPointManagerModel, compUtils, DepthSubscriber, MgrLearn, MgrTypeInfo, LearnModeCommand, MatchCommand, NewCommand) {
  'use strict';

  var closest = compUtils.closest;
  var addNumericPointTypes = PointMgrModel.addNumericPointTypes,
    addBooleanPointTypes = PointMgrModel.addBooleanPointTypes,
    addEnumPointTypes = PointMgrModel.addEnumPointTypes,
    addStringPointTypes = PointMgrModel.addStringPointTypes;

  /**
   * @inner
   * @class
   * @extends module:nmodule/driver/rc/wb/mgr/point/PointLearnNode
   */
  var LonPointLearnNode = /*#__PURE__*/function (_PointLearnNode) {
    function LonPointLearnNode() {
      _classCallCheck(this, LonPointLearnNode);
      return _callSuper(this, LonPointLearnNode, arguments);
    }
    _inherits(LonPointLearnNode, _PointLearnNode);
    return _createClass(LonPointLearnNode, [{
      key: "getIcon",
      value: function getIcon() {
        return this.$value.getIcon();
      }
    }, {
      key: "$loadKids",
      value: function $loadKids() {
        var entries = this.$value.getSlots().properties().is("lonworks:LonCreationEntry").toValueArray();
        return entries.map(function (entry) {
          return new LonPointLearnNode(entry);
        });
      }
    }, {
      key: "mayHaveKids",
      value: function mayHaveKids() {
        return this.$value.getSlots().properties().is("lonworks:LonCreationEntry").toValueArray().length > 0;
      }
    }]);
  }(PointLearnNode);
  /**
   * UX Point manager for Lon Devices
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/lonworks/rc/wb/mgr/UxLonPointManager
   * @extends module:nmodule/driver/rc/wb/mgr/PointMgr
   */
  return /*#__PURE__*/function (_PointMgr) {
    function UxLonPointManager() {
      var _this;
      _classCallCheck(this, UxLonPointManager);
      _this = _callSuper(this, UxLonPointManager, [{
        moduleName: 'lonworks',
        keyName: 'UxLonPointManager',
        folderType: 'lonworks:LonPointFolder'
      }]);
      _this.$subscriber = new DepthSubscriber(3);
      subscribable(_this);
      MgrLearn(_this);
      return _this;
    }

    /**
     * Makes the main model
     * @param {baja.Component} component
     * @returns {Promise<module:nmodule/lonworks/rc/wb/mgr/model/LonPointManagerModel>}
     */
    _inherits(UxLonPointManager, _PointMgr);
    return _createClass(UxLonPointManager, [{
      key: "makeModel",
      value: function makeModel(component) {
        return LonPointManagerModel.make(component);
      }

      /**
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
       */
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return LonPointLearnModel.make();
      }
    }, {
      key: "doLoad",
      value: function doLoad() {
        var _this2 = this;
        return _superPropGet(UxLonPointManager, "doLoad", this, 3)(arguments).then(function () {
          if (_this2.$getLearnModeCommand().isSelected()) {
            return _this2.discover();
          }
        });
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var _this3 = this;
        return this.$getDiscoveryInfo().then(function (results) {
          var learnModel = _this3.getLearnModel();
          var entries = results.getSlots().properties().is("lonworks:LonCreationEntry").toValueArray();
          entries = entries.map(function (entry) {
            return new LonPointLearnNode(entry);
          });
          return learnModel.clearRows().then(function () {
            return learnModel.insertRows(entries, 0);
          });
        });
      }

      /**
       * @param {baja.Component} discovery a `lonworks:LonCreationEntry`
       * @returns {Promise.resolve<Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(discovery) {
        var pointTypes = [];
        var writable = discovery.getIsTargetComponentWritable();
        var typeString = discovery.getTargetType().encodeToString();
        return baja.importTypes([typeString]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 1),
            type = _ref2[0];
          if (type.is('lonworks:LonFloat') || type.is('lonworks:LonInteger') || type.is('lonworks:LonDouble') || type.is('lonworks:LonLong') || type.is('lonworks:LonBigInteger')) {
            pointTypes = addNumericPointTypes(writable, pointTypes);
            pointTypes = addBooleanPointTypes(writable, pointTypes);
            pointTypes = addStringPointTypes(writable, pointTypes);
            pointTypes = addEnumPointTypes(writable, pointTypes);
          } else if (type.is('lonworks:LonBoolean')) {
            pointTypes = addBooleanPointTypes(writable, pointTypes);
            pointTypes = addNumericPointTypes(writable, pointTypes);
            pointTypes = addStringPointTypes(writable, pointTypes);
          } else if (type.is('lonworks:LonEnum')) {
            pointTypes = addEnumPointTypes(writable, pointTypes);
            pointTypes = addStringPointTypes(writable, pointTypes);
            pointTypes = addNumericPointTypes(writable, pointTypes);
            pointTypes = addBooleanPointTypes(writable, pointTypes);
          } else {
            pointTypes = addStringPointTypes(writable, pointTypes);
          }
          return MgrTypeInfo.make(pointTypes);
        });
      }
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery) {
        return {
          name: discovery.getDefaultName(),
          values: {
            targetComp: discovery.getTargetPathName(),
            targetName: discovery.getElementName(),
            facets: discovery.getTargetFacets()
          }
        };
      }
    }, {
      key: "isExisting",
      value: function isExisting(creatEntry, point) {
        if (!baja.hasType(point, 'control:ControlPoint')) {
          return false;
        }
        var ext = point.getProxyExt();
        var targetName = ext.getTargetComp();
        return targetName === creatEntry.getTargetName() && ext.getTargetName() === creatEntry.getElementName();
      }

      /**
       * Removes the new command and adds other necessary commands
       * @returns {Promise.<Array.<module:bajaux/commands/Command>>}
       */
    }, {
      key: "makeCommands",
      value: function makeCommands() {
        return _superPropGet(UxLonPointManager, "makeCommands", this, 3)([]).then(function (cmds) {
          cmds = cmds.filter(function (c) {
            return !(c instanceof MatchCommand || c instanceof NewCommand);
          });
          return cmds;
        });
      }
    }, {
      key: "$isSuitableColumnForFolder",
      value: function $isSuitableColumnForFolder(col) {
        return _superPropGet(UxLonPointManager, "$isSuitableColumnForFolder", this, 3)([col]) || _.contains(['__type'], col.getName());
      }

      /**
       * Returns the point ext for the current loaded component. As we may have a folder
       * loaded, this may be several levels up in the component tree.
       *
       * @private
       * @returns {baja.Component}
       */
    }, {
      key: "$getPointDeviceExt",
      value: function $getPointDeviceExt() {
        return closest(this.value(), 'lonworks:LonPointDeviceExt');
      }

      /**
       * @private
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$getDiscoveryInfo",
      value: function $getDiscoveryInfo() {
        return baja.rpc({
          typeSpec: "lonworks:LonworksRpc",
          method: "getPointDiscoveryBson",
          args: [String(this.$getPointDeviceExt().getNavOrd())]
        }).then(function (bsonEncoding) {
          return baja.bson.decodeAsync(JSON.parse(bsonEncoding));
        });
      }
    }]);
  }(PointMgr);
});
