function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/** @jsx spandrel.jsx */

define(['baja!', 'lex!lonworks', 'dialogs', 'bajaux/spandrel', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/compat/RelevantStringEditor', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'Promise'], function (baja, lexs, dialogs, spandrel, feDialogs, RelevantStringEditor, IconEditor, Promise) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    lonLex = _lexs[0];

  /**
   * API Status: **Private**
   * @exports nmodule/lonworks/rc/util/lonUtils
   * @since Niagara 4.14
   */
  var exports = {};

  /**
   * Returns the Lon Manufacturer's display name and corresponding ordinal as a map.
   *
   * @returns {Promise.<Object>}
   */
  exports.getLonManufacturerMap = function () {
    return baja.rpc({
      typeSpec: 'lonworks:LonMfgId',
      method: 'getConversionMap'
    });
  };

  /**
   * Utility function to open a Commission or Replace dialog on LonRouterManager and LonDeviceManager.
   *
   * @param {string} title
   * @param {Array.<baja.Simple>} neuronIds
   * @param {Object} handlers
   * @param {Function} handlers.okHandler
   * @returns {Promise}
   */
  exports.showCommissionOrReplaceDialog = function (title, neuronIds, handlers) {
    var okHandler = handlers.okHandler;
    return feDialogs.showFor({
      value: neuronIds[0],
      type: RelevantStringEditor,
      properties: {
        datalist: neuronIds.join(";"),
        filterWhileTyping: false
      },
      title: title,
      summary: lonLex.get('commands.commReplace.dialog.summary'),
      formFactor: 'compact',
      buttons: {
        ok: {
          displayName: lonLex.get('commands.commReplace.dialog.apply'),
          handler: function handler(dlg, event, editor) {
            return okHandler(editor, false);
          }
        },
        cancel: {
          displayName: lonLex.get('commands.commReplace.dialog.cancel')
        },
        servicePin: {
          displayName: lonLex.get('commands.commReplace.dialog.servicePin'),
          handler: function handler(dlg, event, editor) {
            return okHandler(editor, true);
          }
        }
      }
    });
  };

  /**
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} mgr
   * @param {String} jobName the slot name of the job to execute
   * @param {baja.Component} jobParameter the 'lonworks:CommissionParameter' parameters for the job
   * @returns {Promise}
   */
  exports.runJob = function (mgr, jobName, jobParameter) {
    var netmgt = mgr.getNetwork().getLonNetmgmt();
    return netmgt.invoke({
      slot: jobName,
      value: jobParameter
    }).then(function (jobOrd) {
      var ord = baja.Ord.make({
        base: baja.Ord.make('station:'),
        child: jobOrd.relativizeToSession()
      });
      return mgr.setJob(ord);
    });
  };

  /**
   * @param {Array.<baja.Simple>} subnetNodeIds
   * @returns {string}
   */
  exports.subNetNodeIdsToString = function (subnetNodeIds) {
    return subnetNodeIds.map(function (subnetNodeId) {
      return subnetNodeId.encodeToString();
    }).join('\t');
  };
  return exports;
});
