function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/CountBySeverityWidget
 */
define(['jquery', 'Promise', 'underscore', 'bajaux/commands/ToggleCommand', 'bajaux/events', 'bajaux/util/CommandButton', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/nss/rc/fe/SeverityWidget', 'lex!nss', 'css!nmodule/nss/rc/nss'], function ($, Promise, _, ToggleCommand, events, CommandButton, htmlUtils, BaseWidget, fe, SeverityWidget, lexicon) {
  'use strict';

  var _lexicon = _slicedToArray(lexicon, 1),
    nssLex = _lexicon[0];
  var showText = nssLex.get('CountsBySeverityWidget.filter.show');
  var hideText = nssLex.get('CountsBySeverityWidget.filter.displayName');
  var className = 'CountsBySeverityWidget';

  /**
   * Displays {Severity -> Severity-Count}, ordered by Severity types; Healthy, Warning and Critical.
   *
   * emits a `severityFilterChanged` tinyevent with an array of
   * {module:nmodule/nss/rc/model/Severity} severity items which
   * are currently selected to `show`.
   *
   * @class
   * @alias module:nmodule/nss/rc/fe/CountsBySeverityWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */
  return /*#__PURE__*/function (_BaseWidget) {
    function CountsBySeverityWidget() {
      _classCallCheck(this, CountsBySeverityWidget);
      return _callSuper(this, CountsBySeverityWidget, arguments);
    }
    _inherits(CountsBySeverityWidget, _BaseWidget);
    return _createClass(CountsBySeverityWidget, [{
      key: "doInitialize",
      value:
      /**
       * Initializes the CountBySeverityWidget with html.
       *
       * @param {JQuery} dom - Html to fill.
       */
      function doInitialize(dom) {
        this.$severities = {};
        this.$noShowSeverities = {};
        dom.addClass(className);
        this.jq().toggleClass('horizontal', this.properties().getValue('horizontal', false));
      }

      /**
       * Loads the content for the widget.
       *
       * @param {Object[]} severityArr - Array of severity & count objects .
       * @param {module:nmodule/nss/rc/model/Severity} severityArr[].severity - Severity Object.
       * @param {Number} severityArr[].count - Count of the severities.
       * @returns {Promise} Rendered SecurityWidgets wrapped as a Promise.
       */
    }, {
      key: "doLoad",
      value: function doLoad(severityArr) {
        var _this = this;
        severityArr = severityArr || [];
        // Map of severities that we do not want to show.
        this.$noShowSeverities = _.extend({}, this.$severities, true);
        severityArr.map(function (value) {
          return delete _this.$noShowSeverities[value.severity.getName()];
        });
        // Update severity widgets.
        return this.updateSeverityWidgets(severityArr);
      }

      /**
       * Removes the class from the jq() at the end of widget life cycle.
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('horizontal');
        return this.getChildWidgets().destroyAll();
      }
    }, {
      key: "doChanged",
      value: function doChanged(prop) {
        if (prop === 'horizontal') {
          this.jq().toggleClass('horizontal', this.properties().getValue('horizontal'));
        }
      }

      /**
       * Update the severity widgets along with the count and filter for
       * each item in the given array.
       *
       * severityArr[].severity is used as a key for each widget
       *
       * @param {Object[]} severityArr - Array of severity & count objects .
       * @param {module:nmodule/nss/rc/model/Severity} severityArr[].severity - Severity Object.
       * @param {Number} severityArr[].count - Count of the severities.
       * @returns {Promise} Resolves when the severity widgets have been updated
       */
    }, {
      key: "updateSeverityWidgets",
      value: function updateSeverityWidgets(severityArr) {
        var _this2 = this;
        this.jq().empty();
        return Promise.all(severityArr.map(function (value) {
          var severityCount = htmlUtils.escapeHtml(value.count);
          var severityName = htmlUtils.escapeHtml(value.severity.getName());
          var severityElement = $("<span class=\"".concat(severityName, " summary\">"));
          var countElement = $("<span class=\"count\">".concat(severityCount, "<span>"));
          var container = $("<div class=\"".concat(severityName, "Widget\"></div>"));
          var toggleFilter = $("<div class=\"filterCommand\"></div>");
          var toggleCommand = new ToggleCommand({
            module: 'nss',
            lex: 'CountsBySeverityWidget.filter',
            selected: true
          });
          toggleCommand.on(events.command.SELECTION_EVENT, function () {
            var selected = toggleCommand.isSelected();
            toggleCommand.setDisplayNameFormat(selected ? hideText : showText);
            _this2.$emitFilterEvent();
          });
          _this2.jq().append(container.append(severityElement).append(countElement).append(toggleFilter));
          _this2.$severities[severityName] = {
            countElement: countElement,
            toggleCommand: toggleCommand,
            severity: value.severity
          };
          return Promise.all([fe.buildFor({
            dom: severityElement,
            type: SeverityWidget,
            value: value.severity
          }), fe.buildFor({
            formFactor: 'mini',
            dom: toggleFilter,
            type: CommandButton,
            value: toggleCommand
          })]);
        }));
      }

      /**
       * Emit the `severityFilterChanged` tinyevent.
       *
       * @private
       */
    }, {
      key: "$emitFilterEvent",
      value: function $emitFilterEvent() {
        var activeFilters = [];
        for (var severityName in this.$severities) {
          if (this.$severities[severityName].toggleCommand.isSelected()) {
            activeFilters.push(this.$severities[severityName].severity);
          }
        }
        this.trigger('severityFilterChanged', activeFilters);
      }
    }]);
  }(BaseWidget);
});
