/*
 * Copyright (c) 2017 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.testng;

import static org.testng.Assert.*;

import java.util.function.BooleanSupplier;
import java.util.logging.Logger;

import javax.baja.test.TestHelper;

/**
 * Wrapper for TestHelper.
 * Established so existing test classes don't need to be changed
 * due to migration of utility methods from TestUtil to TestHelper
 * in the javax.baja public API space in Niagara 4.14
 *
 * @author Eric Anderson on 4/19/2017
 * @since Niagara 4.4
 */
public final class TestUtil
  extends TestHelper
{

  /**
   * @deprecated use {@link #assertWillBeTrue(BooleanSupplier, long, String)} instead; the seconds
   * parameter value will need to be converted to milliseconds
   */
  @Deprecated
  public static void waitFor(int seconds, BooleanSupplier condition, String message)
  {
    //noinspection MagicNumber
    assertTrue(waitFor(condition, seconds * 1000L, WAIT_FOR_TRUE_INTERVAL), message + ": wait time expired");
  }

  /**
   * @deprecated use {@link #waitFor(BooleanSupplier, long)} instead; the timeout parameter value
   * will need to be adjusted from seconds to milliseconds.
   */
  @Deprecated
  public static boolean waitFor(BooleanSupplier condition, double timeout)
  {
    return waitFor(condition, (long)(timeout * 1000), WAIT_FOR_TRUE_INTERVAL);
  }

  /**
   * @deprecated use {@link #waitFor(BooleanSupplier, long, long)} instead; the timeout parameter
   * value will need to be adjusted from seconds to milliseconds and the interval and timeout
   * parameters must switch positions
   */
  @Deprecated
  public static boolean waitFor(BooleanSupplier condition, long interval, double timeout)
  {
    return waitFor(condition, (long)(timeout * 1000), interval);
  }

  /**
   * You can use this log handler to spy on the last log message
   */
  public static class LatestHandler extends TestHelper.LatestLogHandler
  {
    public static LatestHandler addLogHandler(String logName)
    {
      LatestHandler logHandler = new LatestHandler();
      Logger.getLogger(logName).addHandler(logHandler);
      return logHandler;
    }
  }
}
