/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BLonElementType class provides enumeration for the element type
 * as specified in <code>BLonElementQualifiers</code>. It indicates
 * the type of data for a particular data element when encoded in
 * network byte format.
 *
 * @author Robert Adams on 14 Dec 00
 * @since Niagara 3.0
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("c8"),
    @Range("s8"),
    @Range("u8"),
    @Range("s16"),
    @Range("u16"),
    @Range("s32"),
    @Range("b8"),
    @Range("e8"),
    @Range("f32"),
    @Range("eb"),
    @Range("esb"),
    @Range("bb"),
    @Range("ub"),
    @Range("sb"),
    @Range("st"),
    @Range("na"),
    @Range("u32"),
    @Range("f64"),
    @Range("s64"),
    @Range("u64")
  }
)
public final class BLonElementType
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.lonworks.enums.BLonElementType(2468782266)1.0$ @*/
/* Generated Tue Jun 06 14:04:01 EDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  /** Ordinal value for c8. */
  @Generated
  public static final int C_8 = 0;
  /** Ordinal value for s8. */
  @Generated
  public static final int S_8 = 1;
  /** Ordinal value for u8. */
  @Generated
  public static final int U_8 = 2;
  /** Ordinal value for s16. */
  @Generated
  public static final int S_16 = 3;
  /** Ordinal value for u16. */
  @Generated
  public static final int U_16 = 4;
  /** Ordinal value for s32. */
  @Generated
  public static final int S_32 = 5;
  /** Ordinal value for b8. */
  @Generated
  public static final int B_8 = 6;
  /** Ordinal value for e8. */
  @Generated
  public static final int E_8 = 7;
  /** Ordinal value for f32. */
  @Generated
  public static final int F_32 = 8;
  /** Ordinal value for eb. */
  @Generated
  public static final int EB = 9;
  /** Ordinal value for esb. */
  @Generated
  public static final int ESB = 10;
  /** Ordinal value for bb. */
  @Generated
  public static final int BB = 11;
  /** Ordinal value for ub. */
  @Generated
  public static final int UB = 12;
  /** Ordinal value for sb. */
  @Generated
  public static final int SB = 13;
  /** Ordinal value for st. */
  @Generated
  public static final int ST = 14;
  /** Ordinal value for na. */
  @Generated
  public static final int NA = 15;
  /** Ordinal value for u32. */
  @Generated
  public static final int U_32 = 16;
  /** Ordinal value for f64. */
  @Generated
  public static final int F_64 = 17;
  /** Ordinal value for s64. */
  @Generated
  public static final int S_64 = 18;
  /** Ordinal value for u64. */
  @Generated
  public static final int U_64 = 19;

  /** BLonElementType constant for c8. */
  @Generated
  public static final BLonElementType c8 = new BLonElementType(C_8);
  /** BLonElementType constant for s8. */
  @Generated
  public static final BLonElementType s8 = new BLonElementType(S_8);
  /** BLonElementType constant for u8. */
  @Generated
  public static final BLonElementType u8 = new BLonElementType(U_8);
  /** BLonElementType constant for s16. */
  @Generated
  public static final BLonElementType s16 = new BLonElementType(S_16);
  /** BLonElementType constant for u16. */
  @Generated
  public static final BLonElementType u16 = new BLonElementType(U_16);
  /** BLonElementType constant for s32. */
  @Generated
  public static final BLonElementType s32 = new BLonElementType(S_32);
  /** BLonElementType constant for b8. */
  @Generated
  public static final BLonElementType b8 = new BLonElementType(B_8);
  /** BLonElementType constant for e8. */
  @Generated
  public static final BLonElementType e8 = new BLonElementType(E_8);
  /** BLonElementType constant for f32. */
  @Generated
  public static final BLonElementType f32 = new BLonElementType(F_32);
  /** BLonElementType constant for eb. */
  @Generated
  public static final BLonElementType eb = new BLonElementType(EB);
  /** BLonElementType constant for esb. */
  @Generated
  public static final BLonElementType esb = new BLonElementType(ESB);
  /** BLonElementType constant for bb. */
  @Generated
  public static final BLonElementType bb = new BLonElementType(BB);
  /** BLonElementType constant for ub. */
  @Generated
  public static final BLonElementType ub = new BLonElementType(UB);
  /** BLonElementType constant for sb. */
  @Generated
  public static final BLonElementType sb = new BLonElementType(SB);
  /** BLonElementType constant for st. */
  @Generated
  public static final BLonElementType st = new BLonElementType(ST);
  /** BLonElementType constant for na. */
  @Generated
  public static final BLonElementType na = new BLonElementType(NA);
  /** BLonElementType constant for u32. */
  @Generated
  public static final BLonElementType u32 = new BLonElementType(U_32);
  /** BLonElementType constant for f64. */
  @Generated
  public static final BLonElementType f64 = new BLonElementType(F_64);
  /** BLonElementType constant for s64. */
  @Generated
  public static final BLonElementType s64 = new BLonElementType(S_64);
  /** BLonElementType constant for u64. */
  @Generated
  public static final BLonElementType u64 = new BLonElementType(U_64);

  /** Factory method with ordinal. */
  @Generated
  public static BLonElementType make(int ordinal)
  {
    return (BLonElementType)c8.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BLonElementType make(String tag)
  {
    return (BLonElementType)c8.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BLonElementType(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BLonElementType DEFAULT = c8;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BLonElementType.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  //DEVELOPER SLOT NOTE: Update Annotation version of Slot-o-matic uses a slightly different name derivation
  //                     function such that c8 becomes C_8, s8 becomes S_8. Provide backwards compatible ordinal
  //                     (c8 -> C8, s8 -> S8) values that allow old code to continue to function without having
  //                      to update to new variable names.

  /** Backwards compatible ordinal value for c8. */
  public static final int C8 = C_8;
  /** Backwards compatible ordinal value for s8. */
  public static final int S8 = S_8;
  /** Backwards compatible ordinal value for u8. */
  public static final int U8 = U_8;
  /** Backwards compatible ordinal value for s16. */
  public static final int S16 = S_16;
  /** Backwards compatible ordinal value for u16. */
  public static final int U16 = U_16;
  /** Backwards compatible ordinal value for s32. */
  public static final int S32 = S_32;
  /** Backwards compatible ordinal value for b8. */
  public static final int B8 = B_8;
  /** Backwards compatible ordinal value for e8. */
  public static final int E8 = E_8;
  /** Backwards compatible ordinal value for f32. */
  public static final int F32 = F_32;
  /** Backwards compatible ordinal value for u32. */
  public static final int U32 = U_32;
  /** Backwards compatible ordinal value for f64. */
  public static final int F64 = F_64;
  /** Backwards compatible ordinal value for s64. */
  public static final int S64 = S_64;
  /** Backwards compatible ordinal value for u64. */
  public static final int U64 = U_64;
}
