/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.file.types.text;

import javax.baja.file.BIFileStore;
import javax.baja.nre.annotations.FileExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Turtle file.
 *
 * @author Tim Urenda on 14 Sep 2022
 * @since Niagara 4.14
 */
@NiagaraType(
  ext = @FileExt(name = "ttl")
)
public class BTtlFile
  extends BTextFile
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.file.types.text.BTtlFile(181476638)1.0$ @*/
/* Generated Fri Sep 23 10:19:19 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BTtlFile.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  /**
   * Construct a file with the specified store.
   */
  public BTtlFile(BIFileStore store)
  {
    super(store);
  }

  /**
   * Construct (must call setStore()).
   */
  public BTtlFile()
  {
  }

  /**
   * Return {@code "text/plain"}.
   */
  @Override
  public String getMimeType()
  {
    return "text/plain";
  }

  /**
   * Get the icon.
   */
  @Override
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("file.png");
}
