/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security.crypto;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.baja.sys.NotRunningException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.sys.Nre;

/**
 * CryptoManagerFactory is a simple factory for gaining access to
 * crypto components like keystores and socket factories.
 *
 * @author    $Author$
 * @creation  29 June 2011
 * @version   $Revision$ $Date$
 * @since     Niagara 3.7
 */

public class CertManagerFactory
{
  /**
   * @return an instance of an ICryptoManager that matches the calling environment
   */

  public static boolean isCertManagerActive()
  {
    try
    {
      CertManagerFactory.getInstance();
      synchronized(mutex)
      {
        if (instance != null)
          return true;
      }
    }
    catch(Exception e)
    {
    }

    return false;
  }

  public static ICryptoManager getInstance()
    throws Exception
  {
    synchronized (mutex)
    {
      // singleton model, only need one
      if (instance == null)
      {
        // are we a station instance
        if (Nre.protectedStationHome != null)
        {
          if (Sys.getStation() != null)
          {
            // is the station running? platform services aren't available if it isn't
            if (Sys.getStation().isRunning())
            {
              instance = (ICryptoManager)Sys.getService(Sys.getType("platCrypto:CertManagerService"));
              if (instance == null)
                throw new ServiceNotFoundException("unable to find CertManagerService");
            }
          }
          else
          {
            throw new NotRunningException("station hasn't finished loading services, can't retrieve ICryptoManager instance");
          }
        }
        else
        {
          // are we a wbapplet instance
          if (Nre.bootEnv.isRemote())
          {
            // need reflection
            Type type = Sys.getType("platCrypto:WbAppletCertManager");
            instance = make(type.getTypeClass());
            if (instance == null)
              throw new ServiceNotFoundException("unable to find WbAppletCertManager instance");
           }
          // are we a workbench instance
          else
          {
            Type type = Sys.getType("platCrypto:WbCertManager");
            instance = make(type.getTypeClass());
            if (instance == null)
              throw new ServiceNotFoundException("unable to find WbCertManager instance");
          }
        }
      }

      return instance;
    }
  }

  /**
   * Helper method for handling the reflection components of
   * instantiating an ICryptoManager instance.
   *
   * @param cls The concrete ICryptoManager class to instantiate
   * @return an instance of ICryptoManager
   */
  private static ICryptoManager make(Class<?> cls)
  {
    try
    {
      Method mthd = cls.getMethod("make");
      ICryptoManager instance = (ICryptoManager) mthd.invoke(cls);
      return instance;
    }
    catch(Exception e)
    {
      e.printStackTrace();
      log.log(Level.SEVERE, "unable to call make on " + cls.getName(), e);
    }

    return null;
  }

  private static Logger log = Logger.getLogger("crypto");
  private static ICryptoManager instance = null;
  private static final Object mutex = new Object();
}
