/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BUsernameAndPassword is a simple implementation of 
 * BICredentials that stores a username and password.
 *
 * @author    Brian Frank
 * @creation  28 Jan 03
 * @version   $Revision: 6$ $Date: 7/21/10 2:20:49 PM EDT$
 * @since     Baja 1.0
 */
@NiagaraType(
  agent = @AgentOn(
    types = "baja:ClientCredentials"
  )
)
@NiagaraProperty(
  name = "username",
  type = "String",
  defaultValue = "BString.DEFAULT"
)
@NiagaraProperty(
  name = "password",
  type = "BPassword",
  defaultValue = "BPassword.DEFAULT"
)
public class BUsernameAndPassword
  extends BStruct
  implements BIUserCredentials, BIAgent, BIDeferOwnership
{ 
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BUsernameAndPassword(1380395834)1.0$ @*/
/* Generated Thu Jun 02 14:30:01 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "username"

  /**
   * Slot for the {@code username} property.
   * @see #getUsername
   * @see #setUsername
   */
  @Generated
  public static final Property username = newProperty(0, BString.DEFAULT, null);

  /**
   * Get the {@code username} property.
   * @see #username
   */
  @Generated
  public String getUsername() { return getString(username); }

  /**
   * Set the {@code username} property.
   * @see #username
   */
  @Generated
  public void setUsername(String v) { setString(username, v, null); }

  //endregion Property "username"

  //region Property "password"

  /**
   * Slot for the {@code password} property.
   * @see #getPassword
   * @see #setPassword
   */
  @Generated
  public static final Property password = newProperty(0, BPassword.DEFAULT, null);

  /**
   * Get the {@code password} property.
   * @see #password
   */
  @Generated
  public BPassword getPassword() { return (BPassword)get(password); }

  /**
   * Set the {@code password} property.
   * @see #password
   */
  @Generated
  public void setPassword(BPassword v) { set(password, v, null); }

  //endregion Property "password"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BUsernameAndPassword.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Constructor with username and password.
   */
  public BUsernameAndPassword(String username, BPassword password)
  {
    setUsername(username);
    setPassword(password);
  }

  /**
   * Constructor with username and password.
   */
  public BUsernameAndPassword(String username, String password)
  {
    this(username, BPassword.make(password, (Context)null));
  }

  /**
   * Default constructor.
   */
  public BUsernameAndPassword()
  {
  }

////////////////////////////////////////////////////////////////
// BICredentials
////////////////////////////////////////////////////////////////

  /**
   * Encode the credentials into a byte array which 
   * may stored in a credential database.
   */
  @Override
  public byte[] encodeCredentials(Context context)
    throws IOException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(bout);
    BString.make(getUsername()).encode(out);
    getPassword().encode(out, context);
    out.flush();
    return bout.toByteArray();
  }
  
  /**
   * Decode the credentials from a byte array generated
   * using encode().
   */
  @Override
  public BICredentials decodeCredentials(byte[] encoding, Context context)
    throws IOException
  {
    ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
    DataInputStream in = new DataInputStream(bin);
    BUsernameAndPassword x = (BUsernameAndPassword)newCopy();
    x.set(username, (BValue)BString.DEFAULT.decode(in));
    x.set(password, (BValue)BPassword.DEFAULT.decode(in, context));
    return x;
  }

  /**
   * Two BUsernameAndPassword objects are equivalent if they have the same class, username
   * and password.
   */
  @Override
  public boolean equivalent(Object obj)
  {
    if (obj != null &&
      obj.getClass() == getClass() &&
      SecurityUtil.equals(((BUsernameAndPassword)obj).getUsername(), getUsername()))
    {
      BPassword p = ((BUsernameAndPassword)obj).getPassword();
      return (p.equals(getPassword()) ||
              (p.getPasswordEncoder().isReversible() &&
               getPassword().getPasswordEncoder().isReversible() &&
               p.validate(getPassword())));
    }
    else
    {
      return false;
    }
  }

  ////////////////////////////////////////////////////////////////
// BIUserCredentials
////////////////////////////////////////////////////////////////
  @Override
  public boolean isNewUser()  { return newUser; }
  public void setNewUser(boolean newUser)  { this.newUser = newUser; }

  private boolean newUser = false;
}
