/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import java.util.ArrayList;

import javax.baja.bacnet.enums.access.BBacnetAccessAuthenticationFactorDisable;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisable;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisableReason;
import javax.baja.bacnet.enums.access.BBacnetAccessEvent;
import javax.baja.bacnet.enums.access.BBacnetAccessUserType;
import javax.baja.bacnet.enums.access.BBacnetAccessZoneOccupancyState;
import javax.baja.bacnet.enums.access.BBacnetAuthorizationExemption;
import javax.baja.bacnet.enums.access.BBacnetAuthorizationMode;
import javax.baja.bacnet.enums.access.BBacnetDoorAlarmState;
import javax.baja.bacnet.enums.access.BBacnetDoorStatus;
import javax.baja.bacnet.enums.lighting.BBacnetBinaryLightingPv;
import javax.baja.bacnet.enums.lighting.BBacnetLightingOperation;
import javax.baja.bacnet.enums.lighting.BBacnetLightingTransition;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

/**
 * BExtensibleEnumList is a container for managing a device's knowledge of
 * any proprietary extensions to any of the extensible enumerations
 * are defined by Bacnet.  It contains one BDynamicEnum for
 * each extensible enumeration type, available for use within the device.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 15 May 02
 * @since Niagara 3 Bacnet 1.0
 */
@NiagaraType
@NiagaraProperty(
  name = "errorClassFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetErrorClass.TYPE))"
)
@NiagaraProperty(
  name = "errorCodeFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetErrorCode.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "abortReasonFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetAbortReason.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "accessAuthenticationFactorDisableFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetAccessAuthenticationFactorDisable.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "accessCredentialDisableFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetAccessCredentialDisable.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "accessCredentialDisableReasonFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetAccessCredentialDisableReason.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "accessEventFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetAccessEvent.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "accessUserTypeFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetAccessUserType.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "accessZoneOccupancyStateFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetAccessZoneOccupancyState.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "authorizationExemptionFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetAuthorizationExemption.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "authorizationModeFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetAuthorizationMode.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "binaryLightingPvFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetBinaryLightingPv.TYPE))"
)
@NiagaraProperty(
  name = "deviceStatusFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetDeviceStatus.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "doorAlarmStateFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetDoorAlarmState.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "doorStatusFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetDoorStatus.TYPE))"
)
@NiagaraProperty(
  name = "engineeringUnitsFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetEngineeringUnits.TYPE))"
)
@NiagaraProperty(
  name = "eventStateFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetEventState.TYPE))"
)
@NiagaraProperty(
  name = "eventTypeFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetEventType.TYPE))"
)
@NiagaraProperty(
  name = "lifeSafetyModeFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetLifeSafetyMode.TYPE))"
)
@NiagaraProperty(
  name = "lifeSafetyOperationFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetLifeSafetyOperation.TYPE))"
)
@NiagaraProperty(
  name = "lifeSafetyStateFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetLifeSafetyState.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "lightingOperationFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetLightingOperation.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "lightingTransitionFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetLightingTransition.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "loggingTypeFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetLoggingType.TYPE))"
)
@NiagaraProperty(
  name = "maintenanceFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetMaintenance.TYPE))"
)
@NiagaraProperty(
  name = "objectTypeFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetObjectType.TYPE))"
)
@NiagaraProperty(
  name = "programErrorFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetProgramError.TYPE))"
)
@NiagaraProperty(
  name = "propertyIdFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetPropertyIdentifier.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "rejectReasonFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetRejectReason.TYPE))"
)
@NiagaraProperty(
  name = "reliabilityFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetReliability.TYPE))"
)
/*
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "restartReasonFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetRestartReason.TYPE))"
)
@NiagaraProperty(
  name = "silencedStateFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetSilencedState.TYPE))"
)
@NiagaraProperty(
  name = "vtClassFacets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum(BEnumRange.make(BBacnetVtClass.TYPE))"
)
public class BExtensibleEnumList
  extends BStruct
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BExtensibleEnumList(1073355908)1.0$ @*/
/* Generated Thu Aug 10 22:38:57 CDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "errorClassFacets"

  /**
   * Slot for the {@code errorClassFacets} property.
   * @see #getErrorClassFacets
   * @see #setErrorClassFacets
   */
  @Generated
  public static final Property errorClassFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetErrorClass.TYPE)), null);

  /**
   * Get the {@code errorClassFacets} property.
   * @see #errorClassFacets
   */
  @Generated
  public BFacets getErrorClassFacets() { return (BFacets)get(errorClassFacets); }

  /**
   * Set the {@code errorClassFacets} property.
   * @see #errorClassFacets
   */
  @Generated
  public void setErrorClassFacets(BFacets v) { set(errorClassFacets, v, null); }

  //endregion Property "errorClassFacets"

  //region Property "errorCodeFacets"

  /**
   * Slot for the {@code errorCodeFacets} property.
   * @see #getErrorCodeFacets
   * @see #setErrorCodeFacets
   */
  @Generated
  public static final Property errorCodeFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetErrorCode.TYPE)), null);

  /**
   * Get the {@code errorCodeFacets} property.
   * @see #errorCodeFacets
   */
  @Generated
  public BFacets getErrorCodeFacets() { return (BFacets)get(errorCodeFacets); }

  /**
   * Set the {@code errorCodeFacets} property.
   * @see #errorCodeFacets
   */
  @Generated
  public void setErrorCodeFacets(BFacets v) { set(errorCodeFacets, v, null); }

  //endregion Property "errorCodeFacets"

  //region Property "abortReasonFacets"

  /**
   * Slot for the {@code abortReasonFacets} property.
   * @since Niagara 4.14
   * @see #getAbortReasonFacets
   * @see #setAbortReasonFacets
   */
  @Generated
  public static final Property abortReasonFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetAbortReason.TYPE)), null);

  /**
   * Get the {@code abortReasonFacets} property.
   * @since Niagara 4.14
   * @see #abortReasonFacets
   */
  @Generated
  public BFacets getAbortReasonFacets() { return (BFacets)get(abortReasonFacets); }

  /**
   * Set the {@code abortReasonFacets} property.
   * @since Niagara 4.14
   * @see #abortReasonFacets
   */
  @Generated
  public void setAbortReasonFacets(BFacets v) { set(abortReasonFacets, v, null); }

  //endregion Property "abortReasonFacets"

  //region Property "accessAuthenticationFactorDisableFacets"

  /**
   * Slot for the {@code accessAuthenticationFactorDisableFacets} property.
   * @since Niagara 4.14
   * @see #getAccessAuthenticationFactorDisableFacets
   * @see #setAccessAuthenticationFactorDisableFacets
   */
  @Generated
  public static final Property accessAuthenticationFactorDisableFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetAccessAuthenticationFactorDisable.TYPE)), null);

  /**
   * Get the {@code accessAuthenticationFactorDisableFacets} property.
   * @since Niagara 4.14
   * @see #accessAuthenticationFactorDisableFacets
   */
  @Generated
  public BFacets getAccessAuthenticationFactorDisableFacets() { return (BFacets)get(accessAuthenticationFactorDisableFacets); }

  /**
   * Set the {@code accessAuthenticationFactorDisableFacets} property.
   * @since Niagara 4.14
   * @see #accessAuthenticationFactorDisableFacets
   */
  @Generated
  public void setAccessAuthenticationFactorDisableFacets(BFacets v) { set(accessAuthenticationFactorDisableFacets, v, null); }

  //endregion Property "accessAuthenticationFactorDisableFacets"

  //region Property "accessCredentialDisableFacets"

  /**
   * Slot for the {@code accessCredentialDisableFacets} property.
   * @since Niagara 4.14
   * @see #getAccessCredentialDisableFacets
   * @see #setAccessCredentialDisableFacets
   */
  @Generated
  public static final Property accessCredentialDisableFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetAccessCredentialDisable.TYPE)), null);

  /**
   * Get the {@code accessCredentialDisableFacets} property.
   * @since Niagara 4.14
   * @see #accessCredentialDisableFacets
   */
  @Generated
  public BFacets getAccessCredentialDisableFacets() { return (BFacets)get(accessCredentialDisableFacets); }

  /**
   * Set the {@code accessCredentialDisableFacets} property.
   * @since Niagara 4.14
   * @see #accessCredentialDisableFacets
   */
  @Generated
  public void setAccessCredentialDisableFacets(BFacets v) { set(accessCredentialDisableFacets, v, null); }

  //endregion Property "accessCredentialDisableFacets"

  //region Property "accessCredentialDisableReasonFacets"

  /**
   * Slot for the {@code accessCredentialDisableReasonFacets} property.
   * @since Niagara 4.14
   * @see #getAccessCredentialDisableReasonFacets
   * @see #setAccessCredentialDisableReasonFacets
   */
  @Generated
  public static final Property accessCredentialDisableReasonFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetAccessCredentialDisableReason.TYPE)), null);

  /**
   * Get the {@code accessCredentialDisableReasonFacets} property.
   * @since Niagara 4.14
   * @see #accessCredentialDisableReasonFacets
   */
  @Generated
  public BFacets getAccessCredentialDisableReasonFacets() { return (BFacets)get(accessCredentialDisableReasonFacets); }

  /**
   * Set the {@code accessCredentialDisableReasonFacets} property.
   * @since Niagara 4.14
   * @see #accessCredentialDisableReasonFacets
   */
  @Generated
  public void setAccessCredentialDisableReasonFacets(BFacets v) { set(accessCredentialDisableReasonFacets, v, null); }

  //endregion Property "accessCredentialDisableReasonFacets"

  //region Property "accessEventFacets"

  /**
   * Slot for the {@code accessEventFacets} property.
   * @since Niagara 4.14
   * @see #getAccessEventFacets
   * @see #setAccessEventFacets
   */
  @Generated
  public static final Property accessEventFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetAccessEvent.TYPE)), null);

  /**
   * Get the {@code accessEventFacets} property.
   * @since Niagara 4.14
   * @see #accessEventFacets
   */
  @Generated
  public BFacets getAccessEventFacets() { return (BFacets)get(accessEventFacets); }

  /**
   * Set the {@code accessEventFacets} property.
   * @since Niagara 4.14
   * @see #accessEventFacets
   */
  @Generated
  public void setAccessEventFacets(BFacets v) { set(accessEventFacets, v, null); }

  //endregion Property "accessEventFacets"

  //region Property "accessUserTypeFacets"

  /**
   * Slot for the {@code accessUserTypeFacets} property.
   * @since Niagara 4.14
   * @see #getAccessUserTypeFacets
   * @see #setAccessUserTypeFacets
   */
  @Generated
  public static final Property accessUserTypeFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetAccessUserType.TYPE)), null);

  /**
   * Get the {@code accessUserTypeFacets} property.
   * @since Niagara 4.14
   * @see #accessUserTypeFacets
   */
  @Generated
  public BFacets getAccessUserTypeFacets() { return (BFacets)get(accessUserTypeFacets); }

  /**
   * Set the {@code accessUserTypeFacets} property.
   * @since Niagara 4.14
   * @see #accessUserTypeFacets
   */
  @Generated
  public void setAccessUserTypeFacets(BFacets v) { set(accessUserTypeFacets, v, null); }

  //endregion Property "accessUserTypeFacets"

  //region Property "accessZoneOccupancyStateFacets"

  /**
   * Slot for the {@code accessZoneOccupancyStateFacets} property.
   * @since Niagara 4.14
   * @see #getAccessZoneOccupancyStateFacets
   * @see #setAccessZoneOccupancyStateFacets
   */
  @Generated
  public static final Property accessZoneOccupancyStateFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetAccessZoneOccupancyState.TYPE)), null);

  /**
   * Get the {@code accessZoneOccupancyStateFacets} property.
   * @since Niagara 4.14
   * @see #accessZoneOccupancyStateFacets
   */
  @Generated
  public BFacets getAccessZoneOccupancyStateFacets() { return (BFacets)get(accessZoneOccupancyStateFacets); }

  /**
   * Set the {@code accessZoneOccupancyStateFacets} property.
   * @since Niagara 4.14
   * @see #accessZoneOccupancyStateFacets
   */
  @Generated
  public void setAccessZoneOccupancyStateFacets(BFacets v) { set(accessZoneOccupancyStateFacets, v, null); }

  //endregion Property "accessZoneOccupancyStateFacets"

  //region Property "authorizationExemptionFacets"

  /**
   * Slot for the {@code authorizationExemptionFacets} property.
   * @since Niagara 4.14
   * @see #getAuthorizationExemptionFacets
   * @see #setAuthorizationExemptionFacets
   */
  @Generated
  public static final Property authorizationExemptionFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetAuthorizationExemption.TYPE)), null);

  /**
   * Get the {@code authorizationExemptionFacets} property.
   * @since Niagara 4.14
   * @see #authorizationExemptionFacets
   */
  @Generated
  public BFacets getAuthorizationExemptionFacets() { return (BFacets)get(authorizationExemptionFacets); }

  /**
   * Set the {@code authorizationExemptionFacets} property.
   * @since Niagara 4.14
   * @see #authorizationExemptionFacets
   */
  @Generated
  public void setAuthorizationExemptionFacets(BFacets v) { set(authorizationExemptionFacets, v, null); }

  //endregion Property "authorizationExemptionFacets"

  //region Property "authorizationModeFacets"

  /**
   * Slot for the {@code authorizationModeFacets} property.
   * @since Niagara 4.14
   * @see #getAuthorizationModeFacets
   * @see #setAuthorizationModeFacets
   */
  @Generated
  public static final Property authorizationModeFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetAuthorizationMode.TYPE)), null);

  /**
   * Get the {@code authorizationModeFacets} property.
   * @since Niagara 4.14
   * @see #authorizationModeFacets
   */
  @Generated
  public BFacets getAuthorizationModeFacets() { return (BFacets)get(authorizationModeFacets); }

  /**
   * Set the {@code authorizationModeFacets} property.
   * @since Niagara 4.14
   * @see #authorizationModeFacets
   */
  @Generated
  public void setAuthorizationModeFacets(BFacets v) { set(authorizationModeFacets, v, null); }

  //endregion Property "authorizationModeFacets"

  //region Property "binaryLightingPvFacets"

  /**
   * Slot for the {@code binaryLightingPvFacets} property.
   * @since Niagara 4.14
   * @see #getBinaryLightingPvFacets
   * @see #setBinaryLightingPvFacets
   */
  @Generated
  public static final Property binaryLightingPvFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetBinaryLightingPv.TYPE)), null);

  /**
   * Get the {@code binaryLightingPvFacets} property.
   * @since Niagara 4.14
   * @see #binaryLightingPvFacets
   */
  @Generated
  public BFacets getBinaryLightingPvFacets() { return (BFacets)get(binaryLightingPvFacets); }

  /**
   * Set the {@code binaryLightingPvFacets} property.
   * @since Niagara 4.14
   * @see #binaryLightingPvFacets
   */
  @Generated
  public void setBinaryLightingPvFacets(BFacets v) { set(binaryLightingPvFacets, v, null); }

  //endregion Property "binaryLightingPvFacets"

  //region Property "deviceStatusFacets"

  /**
   * Slot for the {@code deviceStatusFacets} property.
   * @see #getDeviceStatusFacets
   * @see #setDeviceStatusFacets
   */
  @Generated
  public static final Property deviceStatusFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetDeviceStatus.TYPE)), null);

  /**
   * Get the {@code deviceStatusFacets} property.
   * @see #deviceStatusFacets
   */
  @Generated
  public BFacets getDeviceStatusFacets() { return (BFacets)get(deviceStatusFacets); }

  /**
   * Set the {@code deviceStatusFacets} property.
   * @see #deviceStatusFacets
   */
  @Generated
  public void setDeviceStatusFacets(BFacets v) { set(deviceStatusFacets, v, null); }

  //endregion Property "deviceStatusFacets"

  //region Property "doorAlarmStateFacets"

  /**
   * Slot for the {@code doorAlarmStateFacets} property.
   * @since Niagara 4.14
   * @see #getDoorAlarmStateFacets
   * @see #setDoorAlarmStateFacets
   */
  @Generated
  public static final Property doorAlarmStateFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetDoorAlarmState.TYPE)), null);

  /**
   * Get the {@code doorAlarmStateFacets} property.
   * @since Niagara 4.14
   * @see #doorAlarmStateFacets
   */
  @Generated
  public BFacets getDoorAlarmStateFacets() { return (BFacets)get(doorAlarmStateFacets); }

  /**
   * Set the {@code doorAlarmStateFacets} property.
   * @since Niagara 4.14
   * @see #doorAlarmStateFacets
   */
  @Generated
  public void setDoorAlarmStateFacets(BFacets v) { set(doorAlarmStateFacets, v, null); }

  //endregion Property "doorAlarmStateFacets"

  //region Property "doorStatusFacets"

  /**
   * Slot for the {@code doorStatusFacets} property.
   * @since Niagara 4.14
   * @see #getDoorStatusFacets
   * @see #setDoorStatusFacets
   */
  @Generated
  public static final Property doorStatusFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetDoorStatus.TYPE)), null);

  /**
   * Get the {@code doorStatusFacets} property.
   * @since Niagara 4.14
   * @see #doorStatusFacets
   */
  @Generated
  public BFacets getDoorStatusFacets() { return (BFacets)get(doorStatusFacets); }

  /**
   * Set the {@code doorStatusFacets} property.
   * @since Niagara 4.14
   * @see #doorStatusFacets
   */
  @Generated
  public void setDoorStatusFacets(BFacets v) { set(doorStatusFacets, v, null); }

  //endregion Property "doorStatusFacets"

  //region Property "engineeringUnitsFacets"

  /**
   * Slot for the {@code engineeringUnitsFacets} property.
   * @see #getEngineeringUnitsFacets
   * @see #setEngineeringUnitsFacets
   */
  @Generated
  public static final Property engineeringUnitsFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetEngineeringUnits.TYPE)), null);

  /**
   * Get the {@code engineeringUnitsFacets} property.
   * @see #engineeringUnitsFacets
   */
  @Generated
  public BFacets getEngineeringUnitsFacets() { return (BFacets)get(engineeringUnitsFacets); }

  /**
   * Set the {@code engineeringUnitsFacets} property.
   * @see #engineeringUnitsFacets
   */
  @Generated
  public void setEngineeringUnitsFacets(BFacets v) { set(engineeringUnitsFacets, v, null); }

  //endregion Property "engineeringUnitsFacets"

  //region Property "eventStateFacets"

  /**
   * Slot for the {@code eventStateFacets} property.
   * @see #getEventStateFacets
   * @see #setEventStateFacets
   */
  @Generated
  public static final Property eventStateFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetEventState.TYPE)), null);

  /**
   * Get the {@code eventStateFacets} property.
   * @see #eventStateFacets
   */
  @Generated
  public BFacets getEventStateFacets() { return (BFacets)get(eventStateFacets); }

  /**
   * Set the {@code eventStateFacets} property.
   * @see #eventStateFacets
   */
  @Generated
  public void setEventStateFacets(BFacets v) { set(eventStateFacets, v, null); }

  //endregion Property "eventStateFacets"

  //region Property "eventTypeFacets"

  /**
   * Slot for the {@code eventTypeFacets} property.
   * @see #getEventTypeFacets
   * @see #setEventTypeFacets
   */
  @Generated
  public static final Property eventTypeFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetEventType.TYPE)), null);

  /**
   * Get the {@code eventTypeFacets} property.
   * @see #eventTypeFacets
   */
  @Generated
  public BFacets getEventTypeFacets() { return (BFacets)get(eventTypeFacets); }

  /**
   * Set the {@code eventTypeFacets} property.
   * @see #eventTypeFacets
   */
  @Generated
  public void setEventTypeFacets(BFacets v) { set(eventTypeFacets, v, null); }

  //endregion Property "eventTypeFacets"

  //region Property "lifeSafetyModeFacets"

  /**
   * Slot for the {@code lifeSafetyModeFacets} property.
   * @see #getLifeSafetyModeFacets
   * @see #setLifeSafetyModeFacets
   */
  @Generated
  public static final Property lifeSafetyModeFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetLifeSafetyMode.TYPE)), null);

  /**
   * Get the {@code lifeSafetyModeFacets} property.
   * @see #lifeSafetyModeFacets
   */
  @Generated
  public BFacets getLifeSafetyModeFacets() { return (BFacets)get(lifeSafetyModeFacets); }

  /**
   * Set the {@code lifeSafetyModeFacets} property.
   * @see #lifeSafetyModeFacets
   */
  @Generated
  public void setLifeSafetyModeFacets(BFacets v) { set(lifeSafetyModeFacets, v, null); }

  //endregion Property "lifeSafetyModeFacets"

  //region Property "lifeSafetyOperationFacets"

  /**
   * Slot for the {@code lifeSafetyOperationFacets} property.
   * @see #getLifeSafetyOperationFacets
   * @see #setLifeSafetyOperationFacets
   */
  @Generated
  public static final Property lifeSafetyOperationFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetLifeSafetyOperation.TYPE)), null);

  /**
   * Get the {@code lifeSafetyOperationFacets} property.
   * @see #lifeSafetyOperationFacets
   */
  @Generated
  public BFacets getLifeSafetyOperationFacets() { return (BFacets)get(lifeSafetyOperationFacets); }

  /**
   * Set the {@code lifeSafetyOperationFacets} property.
   * @see #lifeSafetyOperationFacets
   */
  @Generated
  public void setLifeSafetyOperationFacets(BFacets v) { set(lifeSafetyOperationFacets, v, null); }

  //endregion Property "lifeSafetyOperationFacets"

  //region Property "lifeSafetyStateFacets"

  /**
   * Slot for the {@code lifeSafetyStateFacets} property.
   * @see #getLifeSafetyStateFacets
   * @see #setLifeSafetyStateFacets
   */
  @Generated
  public static final Property lifeSafetyStateFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetLifeSafetyState.TYPE)), null);

  /**
   * Get the {@code lifeSafetyStateFacets} property.
   * @see #lifeSafetyStateFacets
   */
  @Generated
  public BFacets getLifeSafetyStateFacets() { return (BFacets)get(lifeSafetyStateFacets); }

  /**
   * Set the {@code lifeSafetyStateFacets} property.
   * @see #lifeSafetyStateFacets
   */
  @Generated
  public void setLifeSafetyStateFacets(BFacets v) { set(lifeSafetyStateFacets, v, null); }

  //endregion Property "lifeSafetyStateFacets"

  //region Property "lightingOperationFacets"

  /**
   * Slot for the {@code lightingOperationFacets} property.
   * @since Niagara 4.14
   * @see #getLightingOperationFacets
   * @see #setLightingOperationFacets
   */
  @Generated
  public static final Property lightingOperationFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetLightingOperation.TYPE)), null);

  /**
   * Get the {@code lightingOperationFacets} property.
   * @since Niagara 4.14
   * @see #lightingOperationFacets
   */
  @Generated
  public BFacets getLightingOperationFacets() { return (BFacets)get(lightingOperationFacets); }

  /**
   * Set the {@code lightingOperationFacets} property.
   * @since Niagara 4.14
   * @see #lightingOperationFacets
   */
  @Generated
  public void setLightingOperationFacets(BFacets v) { set(lightingOperationFacets, v, null); }

  //endregion Property "lightingOperationFacets"

  //region Property "lightingTransitionFacets"

  /**
   * Slot for the {@code lightingTransitionFacets} property.
   * @since Niagara 4.14
   * @see #getLightingTransitionFacets
   * @see #setLightingTransitionFacets
   */
  @Generated
  public static final Property lightingTransitionFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetLightingTransition.TYPE)), null);

  /**
   * Get the {@code lightingTransitionFacets} property.
   * @since Niagara 4.14
   * @see #lightingTransitionFacets
   */
  @Generated
  public BFacets getLightingTransitionFacets() { return (BFacets)get(lightingTransitionFacets); }

  /**
   * Set the {@code lightingTransitionFacets} property.
   * @since Niagara 4.14
   * @see #lightingTransitionFacets
   */
  @Generated
  public void setLightingTransitionFacets(BFacets v) { set(lightingTransitionFacets, v, null); }

  //endregion Property "lightingTransitionFacets"

  //region Property "loggingTypeFacets"

  /**
   * Slot for the {@code loggingTypeFacets} property.
   * @since Niagara 4.14
   * @see #getLoggingTypeFacets
   * @see #setLoggingTypeFacets
   */
  @Generated
  public static final Property loggingTypeFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetLoggingType.TYPE)), null);

  /**
   * Get the {@code loggingTypeFacets} property.
   * @since Niagara 4.14
   * @see #loggingTypeFacets
   */
  @Generated
  public BFacets getLoggingTypeFacets() { return (BFacets)get(loggingTypeFacets); }

  /**
   * Set the {@code loggingTypeFacets} property.
   * @since Niagara 4.14
   * @see #loggingTypeFacets
   */
  @Generated
  public void setLoggingTypeFacets(BFacets v) { set(loggingTypeFacets, v, null); }

  //endregion Property "loggingTypeFacets"

  //region Property "maintenanceFacets"

  /**
   * Slot for the {@code maintenanceFacets} property.
   * @see #getMaintenanceFacets
   * @see #setMaintenanceFacets
   */
  @Generated
  public static final Property maintenanceFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetMaintenance.TYPE)), null);

  /**
   * Get the {@code maintenanceFacets} property.
   * @see #maintenanceFacets
   */
  @Generated
  public BFacets getMaintenanceFacets() { return (BFacets)get(maintenanceFacets); }

  /**
   * Set the {@code maintenanceFacets} property.
   * @see #maintenanceFacets
   */
  @Generated
  public void setMaintenanceFacets(BFacets v) { set(maintenanceFacets, v, null); }

  //endregion Property "maintenanceFacets"

  //region Property "objectTypeFacets"

  /**
   * Slot for the {@code objectTypeFacets} property.
   * @see #getObjectTypeFacets
   * @see #setObjectTypeFacets
   */
  @Generated
  public static final Property objectTypeFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetObjectType.TYPE)), null);

  /**
   * Get the {@code objectTypeFacets} property.
   * @see #objectTypeFacets
   */
  @Generated
  public BFacets getObjectTypeFacets() { return (BFacets)get(objectTypeFacets); }

  /**
   * Set the {@code objectTypeFacets} property.
   * @see #objectTypeFacets
   */
  @Generated
  public void setObjectTypeFacets(BFacets v) { set(objectTypeFacets, v, null); }

  //endregion Property "objectTypeFacets"

  //region Property "programErrorFacets"

  /**
   * Slot for the {@code programErrorFacets} property.
   * @see #getProgramErrorFacets
   * @see #setProgramErrorFacets
   */
  @Generated
  public static final Property programErrorFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetProgramError.TYPE)), null);

  /**
   * Get the {@code programErrorFacets} property.
   * @see #programErrorFacets
   */
  @Generated
  public BFacets getProgramErrorFacets() { return (BFacets)get(programErrorFacets); }

  /**
   * Set the {@code programErrorFacets} property.
   * @see #programErrorFacets
   */
  @Generated
  public void setProgramErrorFacets(BFacets v) { set(programErrorFacets, v, null); }

  //endregion Property "programErrorFacets"

  //region Property "propertyIdFacets"

  /**
   * Slot for the {@code propertyIdFacets} property.
   * @see #getPropertyIdFacets
   * @see #setPropertyIdFacets
   */
  @Generated
  public static final Property propertyIdFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetPropertyIdentifier.TYPE)), null);

  /**
   * Get the {@code propertyIdFacets} property.
   * @see #propertyIdFacets
   */
  @Generated
  public BFacets getPropertyIdFacets() { return (BFacets)get(propertyIdFacets); }

  /**
   * Set the {@code propertyIdFacets} property.
   * @see #propertyIdFacets
   */
  @Generated
  public void setPropertyIdFacets(BFacets v) { set(propertyIdFacets, v, null); }

  //endregion Property "propertyIdFacets"

  //region Property "rejectReasonFacets"

  /**
   * Slot for the {@code rejectReasonFacets} property.
   * @since Niagara 4.14
   * @see #getRejectReasonFacets
   * @see #setRejectReasonFacets
   */
  @Generated
  public static final Property rejectReasonFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetRejectReason.TYPE)), null);

  /**
   * Get the {@code rejectReasonFacets} property.
   * @since Niagara 4.14
   * @see #rejectReasonFacets
   */
  @Generated
  public BFacets getRejectReasonFacets() { return (BFacets)get(rejectReasonFacets); }

  /**
   * Set the {@code rejectReasonFacets} property.
   * @since Niagara 4.14
   * @see #rejectReasonFacets
   */
  @Generated
  public void setRejectReasonFacets(BFacets v) { set(rejectReasonFacets, v, null); }

  //endregion Property "rejectReasonFacets"

  //region Property "reliabilityFacets"

  /**
   * Slot for the {@code reliabilityFacets} property.
   * @see #getReliabilityFacets
   * @see #setReliabilityFacets
   */
  @Generated
  public static final Property reliabilityFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetReliability.TYPE)), null);

  /**
   * Get the {@code reliabilityFacets} property.
   * @see #reliabilityFacets
   */
  @Generated
  public BFacets getReliabilityFacets() { return (BFacets)get(reliabilityFacets); }

  /**
   * Set the {@code reliabilityFacets} property.
   * @see #reliabilityFacets
   */
  @Generated
  public void setReliabilityFacets(BFacets v) { set(reliabilityFacets, v, null); }

  //endregion Property "reliabilityFacets"

  //region Property "restartReasonFacets"

  /**
   * Slot for the {@code restartReasonFacets} property.
   * @since Niagara 4.14
   * @see #getRestartReasonFacets
   * @see #setRestartReasonFacets
   */
  @Generated
  public static final Property restartReasonFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetRestartReason.TYPE)), null);

  /**
   * Get the {@code restartReasonFacets} property.
   * @since Niagara 4.14
   * @see #restartReasonFacets
   */
  @Generated
  public BFacets getRestartReasonFacets() { return (BFacets)get(restartReasonFacets); }

  /**
   * Set the {@code restartReasonFacets} property.
   * @since Niagara 4.14
   * @see #restartReasonFacets
   */
  @Generated
  public void setRestartReasonFacets(BFacets v) { set(restartReasonFacets, v, null); }

  //endregion Property "restartReasonFacets"

  //region Property "silencedStateFacets"

  /**
   * Slot for the {@code silencedStateFacets} property.
   * @see #getSilencedStateFacets
   * @see #setSilencedStateFacets
   */
  @Generated
  public static final Property silencedStateFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetSilencedState.TYPE)), null);

  /**
   * Get the {@code silencedStateFacets} property.
   * @see #silencedStateFacets
   */
  @Generated
  public BFacets getSilencedStateFacets() { return (BFacets)get(silencedStateFacets); }

  /**
   * Set the {@code silencedStateFacets} property.
   * @see #silencedStateFacets
   */
  @Generated
  public void setSilencedStateFacets(BFacets v) { set(silencedStateFacets, v, null); }

  //endregion Property "silencedStateFacets"

  //region Property "vtClassFacets"

  /**
   * Slot for the {@code vtClassFacets} property.
   * @see #getVtClassFacets
   * @see #setVtClassFacets
   */
  @Generated
  public static final Property vtClassFacets = newProperty(0, BFacets.makeEnum(BEnumRange.make(BBacnetVtClass.TYPE)), null);

  /**
   * Get the {@code vtClassFacets} property.
   * @see #vtClassFacets
   */
  @Generated
  public BFacets getVtClassFacets() { return (BFacets)get(vtClassFacets); }

  /**
   * Set the {@code vtClassFacets} property.
   * @see #vtClassFacets
   */
  @Generated
  public void setVtClassFacets(BFacets v) { set(vtClassFacets, v, null); }

  //endregion Property "vtClassFacets"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BExtensibleEnumList.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Constructor.
   */
  public BExtensibleEnumList()
  {
  }

  public BExtensibleEnumList(XElem xlm)
  {
    XElem[] enums = xlm.elems();
    for (int i = 0; i < enums.length; i++)
    {
      XElem[] vals = enums[i].elems("value");
      String enumName = enums[i].name();
      Property enumProp = loadSlots().getProperty(enumName + "Facets");
      BFacets enumFacets = (BFacets)get(enumProp);
      BEnumRange r = (BEnumRange)enumFacets.get(BFacets.RANGE);

      int[] newOrds = new int[vals.length];
      String[] newTags = new String[vals.length];
      for (int j = 0; j < vals.length; j++)
      {
        newTags[j] = vals[j].get("n");
        newOrds[j] = vals[j].geti("v");
      }
      ArrayList<Integer> vOrds = new ArrayList<>();
      ArrayList<String> vTags = new ArrayList<>();
      int[] ords = r.getOrdinals();
      String[] tags = getTags(r);
      for (int j = 0; j < ords.length; j++)
      {
        if (r.isDynamicOrdinal(ords[j]))
        {
          vOrds.add(Integer.valueOf(ords[j]));
          vTags.add(tags[j]);
        }
      }
      int[] mergeOrds = new int[vOrds.size() + newOrds.length];
      String[] mergeTags = new String[vTags.size() + newTags.length];
      for (int j = 0; j < vOrds.size(); j++)
        mergeOrds[j] = vOrds.get(j).intValue();
      System.arraycopy(newOrds, 0, mergeOrds, vOrds.size(), newOrds.length);
      for (int j = 0; j < vTags.size(); j++)
        mergeTags[j] = vTags.get(j);
      System.arraycopy(newTags, 0, mergeTags, vTags.size(), newTags.length);

      set(enumProp, BFacets.makeEnum(BEnumRange.make(r.getFrozenType(), mergeOrds, mergeTags)));
    }
  }


////////////////////////////////////////////////////////////////
// BDynamicEnum Access
////////////////////////////////////////////////////////////////

  /**
   * Convenience method for error-class.
   *
   * @return the error-class enumeration.
   */
  public BDynamicEnum getErrorClass()
  {
    return BDynamicEnum.make(0, getErrorClassRange());
  }

  /**
   * Convenience method for error-code.
   *
   * @return the error-code enumeration.
   */
  public BDynamicEnum getErrorCode()
  {
    return BDynamicEnum.make(0, getErrorCodeRange());
  }

  /**
   * Convenience method for BacnetAbortReason.
   *
   * @return the BacnetAbortReason enumeration.
   */
  public BDynamicEnum getAbortReason()
  {
    return BDynamicEnum.make(0, getAbortReasonRange());
  }

  /**
   * Convenience method for BacnetAccessAuthenticationFactorDisable.
   *
   * @return the BacnetAccessAuthenticationFactorDisable enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getAccessAuthenticationFactorDisable()
  {
    return BDynamicEnum.make(0, getAccessAuthenticationFactorDisableRange());
  }

  /**
   * Convenience method for BacnetAccessCredentialDisable.
   *
   * @return the BacnetAccessCredentialDisable enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getAccessCredentialDisable()
  {
    return BDynamicEnum.make(0, getAccessCredentialDisableRange());
  }

  /**
   * Convenience method for BacnetAccessCredentialDisableReason.
   *
   * @return the BacnetAccessCredentialDisableReason enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getAccessCredentialDisableReason()
  {
    return BDynamicEnum.make(0, getAccessCredentialDisableReasonRange());
  }

  /**
   * Convenience method for BacnetAccessEvent.
   *
   * @return the BacnetAccessEvent enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getAccessEvent()
  {
    return BDynamicEnum.make(0, getAccessEventRange());
  }

  /**
   * Convenience method for BacnetAccessUserType.
   *
   * @return the BacnetAccessUserType enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getAccessUserType()
  {
    return BDynamicEnum.make(0, getAccessUserTypeRange());
  }

  /**
   * Convenience method for BacnetAccessZoneOccupancyStateType.
   *
   * @return the BacnetAccessZoneOccupancyStateType enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getAccessZoneOccupancyState()
  {
    return BDynamicEnum.make(0, getAccessZoneOccupancyStateRange());
  }

  /**
   * Convenience method for BacnetAuthorizationExemption.
   *
   * @return the BacnetAuthorizationExemption enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getAuthorizationExemption()
  {
    return BDynamicEnum.make(0, getAuthorizationExemptionRange());
  }

  /**
   * Convenience method for BacnetAuthorizationMode.
   *
   * @return the BacnetAuthorizationMode enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getAuthorizationMode()
  {
    return BDynamicEnum.make(0, getAuthorizationModeRange());
  }

  /**
   * Convenience method for BacnetBinaryLightingPv.
   *
   * @return the BacnetBinaryLightingPv enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getBinaryLightingPv()
  {
    return BDynamicEnum.make(0, getBinaryLightingPvRange());
  }

  /**
   * Convenience method for BacnetDeviceStatus.
   *
   * @return the BacnetDeviceStatus enumeration.
   */
  public BDynamicEnum getDeviceStatus()
  {
    return BDynamicEnum.make(0, getDeviceStatusRange());
  }

  /**
   * Convenience method for BacnetDoorAlarmState.
   *
   * @return the BacnetDoorAlarmState enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getDoorAlarmState()
  {
    return BDynamicEnum.make(0, getDoorAlarmStateRange());
  }

  /**
   * Convenience method for BacnetDoorStatus.
   *
   * @return the BacnetDoorStatus enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getDoorStatus()
  {
    return BDynamicEnum.make(0, getDoorStatusRange());
  }

  /**
   * Convenience method for BacnetEngineeringUnits.
   *
   * @return the BacnetEngineeringUnits enumeration.
   */
  public BDynamicEnum getEngineeringUnits()
  {
    return BDynamicEnum.make(0, getEngineeringUnitsRange());
  }

  /**
   * Convenience method for BacnetEventState.
   *
   * @return the BacnetEventState enumeration.
   */
  public BDynamicEnum getEventState()
  {
    return BDynamicEnum.make(0, getEventStateRange());
  }

  /**
   * Convenience method for BacnetEventType.
   *
   * @return the BacnetEventType enumeration.
   */
  public BDynamicEnum getEventType()
  {
    return BDynamicEnum.make(0, getEventTypeRange());
  }

  /**
   * Convenience method for BacnetLifeSafetyMode.
   *
   * @return the BacnetLifeSafetyMode enumeration.
   */
  public BDynamicEnum getLifeSafetyMode()
  {
    return BDynamicEnum.make(0, getLifeSafetyModeRange());
  }

  /**
   * Convenience method for BacnetLifeSafetyOperation.
   *
   * @return the BacnetLifeSafetyOperation enumeration.
   */
  public BDynamicEnum getLifeSafetyOperation()
  {
    return BDynamicEnum.make(0, getLifeSafetyOperationRange());
  }

  /**
   * Convenience method for BacnetLifeSafetyState.
   *
   * @return the BacnetLifeSafetyState enumeration.
   */
  public BDynamicEnum getLifeSafetyState()
  {
    return BDynamicEnum.make(0, getLifeSafetyStateRange());
  }

  /**
   * Convenience method for BacnetLightingOperation.
   *
   * @return the BacnetLightingOperation enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getLightingOperation()
  {
    return BDynamicEnum.make(0, getLightingOperationRange());
  }

  /**
   * Convenience method for BacnetLightingTransition.
   *
   * @return the BacnetLightingTransition enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getLightingTransition()
  {
    return BDynamicEnum.make(0, getLightingTransitionRange());
  }

  /**
   * Convenience method for BacnetLoggingType.
   *
   * @return the BacnetLoggingType enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getLoggingType()
  {
    return BDynamicEnum.make(0, getLoggingTypeRange());
  }

  /**
   * Convenience method for BacnetMaintenance.
   *
   * @return the BacnetMaintenance enumeration.
   */
  public BDynamicEnum getMaintenance()
  {
    return BDynamicEnum.make(0, getMaintenanceRange());
  }

  /**
   * Convenience method for BacnetObjectType.
   *
   * @return the BacnetObjectType enumeration.
   */
  public BDynamicEnum getObjectType()
  {
    return BDynamicEnum.make(0, getObjectTypeRange());
  }

  /**
   * Convenience method for BacnetProgramError.
   *
   * @return the BacnetProgramError enumeration.
   */
  public BDynamicEnum getProgramError()
  {
    return BDynamicEnum.make(0, getProgramErrorRange());
  }

  /**
   * Convenience method for BacnetPropertyId.
   *
   * @return the BacnetPropertyId enumeration.
   */
  public BDynamicEnum getPropertyId()
  {
    return BDynamicEnum.make(0, getPropertyIdRange());
  }

  /**
   * Convenience method for BacnetRejectReason.
   *
   * @return the BacnetRejectReason enumeration.
   */
  public BDynamicEnum getRejectReason()
  {
    return BDynamicEnum.make(0, getRejectReasonRange());
  }

  /**
   * Convenience method for BacnetReliability.
   *
   * @return the BacnetReliability enumeration.
   */
  public BDynamicEnum getReliability()
  {
    return BDynamicEnum.make(0, getReliabilityRange());
  }

  /**
   * Convenience method for BacnetRestartReason.
   *
   * @return the BacnetRestartReason enumeration.
   * @since Niagara 4.14
   */
  public BDynamicEnum getRestartReason()
  {
    return BDynamicEnum.make(0, getRestartReasonRange());
  }

  /**
   * Convenience method for BacnetSilencedState.
   *
   * @return the BacnetSilencedState enumeration.
   */
  public BDynamicEnum getSilencedState()
  {
    return BDynamicEnum.make(0, getSilencedStateRange());
  }

  /**
   * Convenience method for BacnetVtClass.
   *
   * @return the BacnetVtClass enumeration.
   */
  public BDynamicEnum getVtClass()
  {
    return BDynamicEnum.make(0, getVtClassRange());
  }


////////////////////////////////////////////////////////////////
// Range Access
////////////////////////////////////////////////////////////////

  /**
   * Convenience method for error-class range.
   *
   * @return the known range for the error-class enumeration.
   */
  public BEnumRange getErrorClassRange()
  {
    return getRange(errorClassFacets);
  }

  /**
   * Convenience method for error-code range.
   *
   * @return the known range for the error-code enumeration.
   */
  public BEnumRange getErrorCodeRange()
  {
    return getRange(errorCodeFacets);
  }

  /**
   * Convenience method for BacnetAbortReason range.
   *
   * @return the known range for the BacnetAbortReason enumeration.
   */
  public BEnumRange getAbortReasonRange()
  {
    return getRange(abortReasonFacets);
  }

  /**
   * Convenience method for BacnetAccessAuthenticationFactorDisable range.
   *
   * @return the known range for the BacnetAccessAuthenticationFactorDisable enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getAccessAuthenticationFactorDisableRange()
  {
    return getRange(accessAuthenticationFactorDisableFacets);
  }

  /**
   * Convenience method for BacnetAccessCredentialDisable range.
   *
   * @return the known range for the BacnetAccessCredentialDisable enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getAccessCredentialDisableRange()
  {
    return getRange(accessCredentialDisableFacets);
  }

  /**
   * Convenience method for BacnetAccessCredentialDisableReason range.
   *
   * @return the known range for the BacnetAccessCredentialDisableReason enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getAccessCredentialDisableReasonRange()
  {
    return getRange(accessCredentialDisableReasonFacets);
  }

  /**
   * Convenience method for BacnetAccessEvent range.
   *
   * @return the known range for the BacnetAccessEvent enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getAccessEventRange()
  {
    return getRange(accessEventFacets);
  }

  /**
   * Convenience method for BacnetAccessUserType range.
   *
   * @return the known range for the BacnetAccessUserType enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getAccessUserTypeRange()
  {
    return getRange(accessUserTypeFacets);
  }

  /**
   * Convenience method for BacnetAccessZoneOccupancyState range.
   *
   * @return the known range for the BacnetAccessZoneOccupancyState enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getAccessZoneOccupancyStateRange()
  {
    return getRange(accessZoneOccupancyStateFacets);
  }

  /**
   * Convenience method for BacnetAuthorizationExemption range.
   *
   * @return the known range for the BacnetAuthorizationExemption enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getAuthorizationExemptionRange()
  {
    return getRange(authorizationExemptionFacets);
  }

  /**
   * Convenience method for BacnetAuthorizationMode range.
   *
   * @return the known range for the BacnetAuthorizationMode enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getAuthorizationModeRange()
  {
    return getRange(authorizationModeFacets);
  }

  /**
   * Convenience method for BacnetBinaryLightingPv range.
   *
   * @return the known range for the BacnetBinaryLightingPv enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getBinaryLightingPvRange()
  {
    return getRange(binaryLightingPvFacets);
  }

  /**
   * Convenience method for BacnetDeviceStatus range.
   *
   * @return the known range for the BacnetDeviceStatus enumeration.
   */
  public BEnumRange getDeviceStatusRange()
  {
    return getRange(deviceStatusFacets);
  }

  /**
   * Convenience method for BacnetDoorAlarmState range.
   *
   * @return the known range for the BacnetDoorAlarmState enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getDoorAlarmStateRange()
  {
    return getRange(doorAlarmStateFacets);
  }

  /**
   * Convenience method for BacnetDoorStatus range.
   *
   * @return the known range for the BacnetDoorStatus enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getDoorStatusRange()
  {
    return getRange(doorStatusFacets);
  }

  /**
   * Convenience method for BacnetEngineeringUnits range.
   *
   * @return the known range for the BacnetEngineeringUnits enumeration.
   */
  public BEnumRange getEngineeringUnitsRange()
  {
    return getRange(engineeringUnitsFacets);
  }

  /**
   * Convenience method for BacnetEventState range.
   *
   * @return the known range for the BacnetEventState enumeration.
   */
  public BEnumRange getEventStateRange()
  {
    return getRange(eventStateFacets);
  }

  /**
   * Convenience method for BacnetEventType range.
   *
   * @return the known range for the BacnetEventType enumeration.
   */
  public BEnumRange getEventTypeRange()
  {
    return getRange(eventTypeFacets);
  }

  /**
   * Convenience method for BacnetLifeSafetyMode range.
   *
   * @return the known range for the BacnetLifeSafetyMode enumeration.
   */
  public BEnumRange getLifeSafetyModeRange()
  {
    return getRange(lifeSafetyModeFacets);
  }

  /**
   * Convenience method for BacnetLifeSafetyOperation range.
   *
   * @return the known range for the BacnetLifeSafetyOperation enumeration.
   */
  public BEnumRange getLifeSafetyOperationRange()
  {
    return getRange(lifeSafetyOperationFacets);
  }

  /**
   * Convenience method for BacnetLifeSafetyState range.
   *
   * @return the known range for the BacnetLifeSafetyState enumeration.
   */
  public BEnumRange getLifeSafetyStateRange()
  {
    return getRange(lifeSafetyStateFacets);
  }

  /**
   * Convenience method for BacnetLightingOperation range.
   *
   * @return the known range for the BacnetLightingOperation enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getLightingOperationRange()
  {
    return getRange(lightingOperationFacets);
  }

  /**
   * Convenience method for BacnetLightingTransition range.
   *
   * @return the known range for the BacnetLightingTransition enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getLightingTransitionRange()
  {
    return getRange(lightingTransitionFacets);
  }

  /**
   * Convenience method for BacnetLoggingType range.
   *
   * @return the known range for the BacnetLoggingType enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getLoggingTypeRange()
  {
    return getRange(loggingTypeFacets);
  }

  /**
   * Convenience method for BacnetMaintenance range.
   *
   * @return the known range for the BacnetMaintenance enumeration.
   */
  public BEnumRange getMaintenanceRange()
  {
    return getRange(maintenanceFacets);
  }

  /**
   * Convenience method for BacnetObjectType range.
   *
   * @return the known range for the BacnetObjectType enumeration.
   */
  public BEnumRange getObjectTypeRange()
  {
    return getRange(objectTypeFacets);
  }

  /**
   * Convenience method for BacnetProgramError range.
   *
   * @return the known range for the BacnetProgramError enumeration.
   */
  public BEnumRange getProgramErrorRange()
  {
    return getRange(programErrorFacets);
  }

  /**
   * Convenience method for BacnetPropertyId range.
   *
   * @return the known range for the BacnetPropertyId enumeration.
   */
  public BEnumRange getPropertyIdRange()
  {
    return getRange(propertyIdFacets);
  }

  /**
   * Convenience method for BacnetRejectReason range.
   *
   * @return the known range for the BacnetRejectReason enumeration.
   */
  public BEnumRange getRejectReasonRange()
  {
    return getRange(rejectReasonFacets);
  }

  /**
   * Convenience method for BacnetReliability range.
   *
   * @return the known range for the BacnetReliability enumeration.
   */
  public BEnumRange getReliabilityRange()
  {
    return getRange(reliabilityFacets);
  }

  /**
   * Convenience method for BacnetRestartReason range.
   *
   * @return the known range for the BacnetRestartReason enumeration.
   * @since Niagara 4.14
   */
  public BEnumRange getRestartReasonRange()
  {
    return getRange(restartReasonFacets);
  }

  /**
   * Convenience method for BacnetSilencedState range.
   *
   * @return the known range for the BacnetSilencedState enumeration.
   */
  public BEnumRange getSilencedStateRange()
  {
    return getRange(silencedStateFacets);
  }

  /**
   * Convenience method for BacnetVtClass range.
   *
   * @return the known range for the BacnetVtClass enumeration.
   */
  public BEnumRange getVtClassRange()
  {
    return getRange(vtClassFacets);
  }

  private BEnumRange getRange(Property property)
  {
    return (BEnumRange) ((BFacets) get(property)).getFacet(BFacets.RANGE);
  }

  public BEnumRange getEnumRange(String type)
  {
    if (type == null || !type.startsWith("bacnet:Bacnet"))
    {
      return null;
    }

    if (type.equals(BBacnetPropertyIdentifier.TYPE.toString()))
    {
      return getPropertyIdRange();
    }

    String propertyName = type.substring("bacnet:Bacnet".length()) + "Facets";
    Property property = getProperty(TextUtil.decapitalize(propertyName));
    if (property != null)
    {
      return getRange(property);
    }

    return null;
  }

////////////////////////////////////////////////////////////////
// Extensible Enumeration Management
////////////////////////////////////////////////////////////////

  public void addNewErrorClass(int enumValue)
  {
    addNewErrorClass(BBacnetErrorClass.tag(enumValue), enumValue);
  }

  public void addNewErrorClass(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getErrorClassRange(),
      enumValue,
      enumName);
    setErrorClassFacets(BFacets.makeEnum(newRange));
  }

  public void addNewErrorCode(int enumValue)
  {
    addNewErrorCode(BBacnetErrorCode.tag(enumValue), enumValue);
  }

  public void addNewErrorCode(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getErrorCodeRange(),
      enumValue,
      enumName);
    setErrorCodeFacets(BFacets.makeEnum(newRange));
  }

  public void addNewAbortReason(int enumValue)
  {
    addNewAbortReason(BBacnetAbortReason.tag(enumValue), enumValue);
  }

  public void addNewAbortReason(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getAbortReasonRange(),
      enumValue,
      enumName);
    setAbortReasonFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetAccessAuthenticationFactorDisable range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessAuthenticationFactorDisable(int enumValue)
  {
    addNewAccessAuthenticationFactorDisable(BBacnetAccessAuthenticationFactorDisable.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetAccessAuthenticationFactorDisable range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessAuthenticationFactorDisable(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getAccessAuthenticationFactorDisableRange(),
      enumValue,
      enumName);
    setAccessAuthenticationFactorDisableFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetAccessCredentialDisable range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessCredentialDisable(int enumValue)
  {
    addNewAccessCredentialDisable(BBacnetAccessCredentialDisable.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetAccessCredentialDisable range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessCredentialDisable(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getAccessCredentialDisableRange(),
      enumValue,
      enumName);
    setAccessCredentialDisableFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetAccessCredentialDisableReason range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessCredentialDisableReason(int enumValue)
  {
    addNewAccessCredentialDisableReason(BBacnetAccessCredentialDisableReason.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetAccessCredentialDisableReason range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessCredentialDisableReason(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getAccessCredentialDisableReasonRange(),
      enumValue,
      enumName);
    setAccessCredentialDisableReasonFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetAccessEvent range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessEvent(int enumValue)
  {
    addNewAccessEvent(BBacnetAccessEvent.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetAccessEvent range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessEvent(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getAccessEventRange(),
      enumValue,
      enumName);
    setAccessEventFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetAccessUserType range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessUserType(int enumValue)
  {
    addNewAccessUserType(BBacnetAccessUserType.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetAccessUserType range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessUserType(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getAccessUserTypeRange(),
      enumValue,
      enumName);
    setAccessUserTypeFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetAccessZoneOccupancyState range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessZoneOccupancyState(int enumValue)
  {
    addNewAccessZoneOccupancyState(BBacnetAccessZoneOccupancyState.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetAccessZoneOccupancyState range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAccessZoneOccupancyState(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getAccessZoneOccupancyStateRange(),
      enumValue,
      enumName);
    setAccessZoneOccupancyStateFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetAuthorizationExemption range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAuthorizationExemption(int enumValue)
  {
    addNewAuthorizationExemption(BBacnetAuthorizationExemption.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetAuthorizationExemption range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAuthorizationExemption(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getAuthorizationExemptionRange(),
      enumValue,
      enumName);
    setAuthorizationExemptionFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetAuthorizationMode range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAuthorizationMode(int enumValue)
  {
    addNewAuthorizationMode(BBacnetAuthorizationMode.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetAuthorizationMode range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewAuthorizationMode(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getAuthorizationModeRange(),
      enumValue,
      enumName);
    setAuthorizationModeFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetBinaryLightingPv range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewBinaryLightingPv(int enumValue)
  {
    addNewBinaryLightingPv(BBacnetBinaryLightingPv.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetBinaryLightingPv range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewBinaryLightingPv(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getBinaryLightingPvRange(),
      enumValue,
      enumName);
    setBinaryLightingPvFacets(BFacets.makeEnum(newRange));
  }

  public void addNewDeviceStatus(int enumValue)
  {
    addNewDeviceStatus(BBacnetDeviceStatus.tag(enumValue), enumValue);
  }

  public void addNewDeviceStatus(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getDeviceStatusRange(),
      enumValue,
      enumName);
    setDeviceStatusFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetDoorAlarmState range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewDoorAlarmState(int enumValue)
  {
    addNewDoorAlarmState(BBacnetDoorAlarmState.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetDoorAlarmState range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewDoorAlarmState(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getDoorAlarmStateRange(),
      enumValue,
      enumName);
    setDoorAlarmStateFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetDoorStatus range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewDoorStatus(int enumValue)
  {
    addNewDoorStatus(BBacnetDoorStatus.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetDoorStatus range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewDoorStatus(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getDoorStatusRange(),
      enumValue,
      enumName);
    setDoorStatusFacets(BFacets.makeEnum(newRange));
  }

  public void addNewEngineeringUnits(int enumValue)
  {
    addNewEngineeringUnits(BBacnetEngineeringUnits.tag(enumValue), enumValue);
  }

  public void addNewEngineeringUnits(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getEngineeringUnitsRange(),
      enumValue,
      enumName);
    setEngineeringUnitsFacets(BFacets.makeEnum(newRange));
  }

  public void addNewEventState(int enumValue)
  {
    addNewEventState(BBacnetEventState.tag(enumValue), enumValue);
  }

  public void addNewEventState(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getEventStateRange(),
      enumValue,
      enumName);
    setEventStateFacets(BFacets.makeEnum(newRange));
  }

  public void addNewEventType(int enumValue)
  {
    addNewEventType(BBacnetEventType.tag(enumValue), enumValue);
  }

  public void addNewEventType(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getEventTypeRange(),
      enumValue,
      enumName);
    setEventTypeFacets(BFacets.makeEnum(newRange));
  }

  public void addNewLifeSafetyMode(int enumValue)
  {
    addNewLifeSafetyMode(BBacnetLifeSafetyMode.tag(enumValue), enumValue);
  }

  public void addNewLifeSafetyMode(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getLifeSafetyModeRange(),
      enumValue,
      enumName);
    setLifeSafetyModeFacets(BFacets.makeEnum(newRange));
  }

  public void addNewLifeSafetyOperation(int enumValue)
  {
    addNewLifeSafetyOperation(BBacnetLifeSafetyOperation.tag(enumValue), enumValue);
  }

  public void addNewLifeSafetyOperation(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getLifeSafetyOperationRange(),
      enumValue,
      enumName);
    setLifeSafetyOperationFacets(BFacets.makeEnum(newRange));
  }

  public void addNewLifeSafetyState(int enumValue)
  {
    addNewLifeSafetyState(BBacnetLifeSafetyState.tag(enumValue), enumValue);
  }

  public void addNewLifeSafetyState(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getLifeSafetyStateRange(),
      enumValue,
      enumName);
    setLifeSafetyStateFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetLightingOperation range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewLightingOperation(int enumValue)
  {
    addNewLightingOperation(BBacnetLightingOperation.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetLightingOperation range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewLightingOperation(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getLightingOperationRange(),
      enumValue,
      enumName);
    setLightingOperationFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetLightingTransition range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewLightingTransition(int enumValue)
  {
    addNewLightingTransition(BBacnetLightingTransition.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetLightingTransition range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewLightingTransition(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getLightingTransitionRange(),
      enumValue,
      enumName);
    setLightingTransitionFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetLoggingType range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewLoggingType(int enumValue)
  {
    addNewLoggingType(BBacnetLoggingType.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetLoggingType range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewLoggingType(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getLoggingTypeRange(),
      enumValue,
      enumName);
    setLoggingTypeFacets(BFacets.makeEnum(newRange));
  }

  public void addNewMaintenance(int enumValue)
  {
    addNewMaintenance(BBacnetMaintenance.tag(enumValue), enumValue);
  }

  public void addNewMaintenance(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getMaintenanceRange(),
      enumValue,
      enumName);
    setMaintenanceFacets(BFacets.makeEnum(newRange));
  }

  public void addNewObjectType(int enumValue)
  {
    addNewObjectType(BBacnetObjectType.tag(enumValue), enumValue);
  }

  public void addNewObjectType(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getObjectTypeRange(),
      enumValue,
      enumName);
    setObjectTypeFacets(BFacets.makeEnum(newRange));
  }

  public void addNewProgramError(int enumValue)
  {
    addNewProgramError(BBacnetProgramError.tag(enumValue), enumValue);
  }

  public void addNewProgramError(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getProgramErrorRange(),
      enumValue,
      enumName);
    setProgramErrorFacets(BFacets.makeEnum(newRange));
  }

  public void addNewPropertyId(int enumValue)
  {
    addNewPropertyId(BBacnetPropertyIdentifier.tag(enumValue), enumValue);
  }

  public void addNewPropertyId(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getPropertyIdRange(),
      enumValue,
      enumName);
    setPropertyIdFacets(BFacets.makeEnum(newRange));
  }

  public void addNewRejectReason(int enumValue)
  {
    addNewRejectReason(BBacnetRejectReason.tag(enumValue), enumValue);
  }

  public void addNewRejectReason(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getRejectReasonRange(),
      enumValue,
      enumName);
    setRejectReasonFacets(BFacets.makeEnum(newRange));
  }

  public void addNewReliability(int enumValue)
  {
    addNewReliability(BBacnetReliability.tag(enumValue), enumValue);
  }

  public void addNewReliability(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getReliabilityRange(),
      enumValue,
      enumName);
    setReliabilityFacets(BFacets.makeEnum(newRange));
  }

  /**
   * Convenience method to set the new enumValue in BacnetRestartReason range.
   *
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewRestartReason(int enumValue)
  {
    addNewRestartReason(BBacnetRestartReason.tag(enumValue), enumValue);
  }

  /**
   * Convenience method to set the new enumName and enumValue in BacnetRestartReason range.
   *
   * @param enumName the new enum name.
   * @param enumValue the new enum value.
   * @since Niagara 4.14
   */
  public void addNewRestartReason(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getRestartReasonRange(),
      enumValue,
      enumName);
    setRestartReasonFacets(BFacets.makeEnum(newRange));
  }

  public void addNewSilencedState(int enumValue)
  {
    addNewSilencedState(BBacnetSilencedState.tag(enumValue), enumValue);
  }

  public void addNewSilencedState(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getSilencedStateRange(),
      enumValue,
      enumName);
    setSilencedStateFacets(BFacets.makeEnum(newRange));
  }

  public void addNewVtClass(int enumValue)
  {
    addNewVtClass(BBacnetVtClass.tag(enumValue), enumValue);
  }

  public void addNewVtClass(String enumName, int enumValue)
  {
    BEnumRange newRange = addNewEnum(
      getVtClassRange(),
      enumValue,
      enumName);
    setVtClassFacets(BFacets.makeEnum(newRange));
  }

  private BEnumRange addNewEnum(BEnumRange r, int enumValue, String enumName)
  {
    if (r.isOrdinal(enumValue))
      throw new InvalidEnumException("Enum value already used by " + r.getTag(enumValue));
    if (r.isTag(enumName))
      throw new InvalidEnumException("Enum name already used by " + r.tagToOrdinal(enumName));

    int[] o = r.getOrdinals();
    ArrayList<Integer> olist = new ArrayList<>();
    ArrayList<String> tlist = new ArrayList<>();
    int count = 0;
    for (int i = 0; i < o.length; i++)
    {
      if (r.isDynamicOrdinal(o[i]))
      {
        count++;
        olist.add(Integer.valueOf(o[i]));
        tlist.add(r.getTag(o[i]));
      }
    }
    olist.add(Integer.valueOf(enumValue));
    tlist.add(enumName);
    int[] ords = new int[count + 1];
    for (int i = 0; i <= count; i++)
      ords[i] = olist.get(i).intValue();

    //NCCB-62906: Intentionally using count + 1 to null terminate the resulting ord and tags Array
    String[] tags = tlist.toArray(new String[count + 1]);

    return BEnumRange.make(r.getFrozenType(), ords, tags);
  }


////////////////////////////////////////////////////////////////
//  Utility
////////////////////////////////////////////////////////////////

  private String[] getTags(BEnumRange r)
  {
    int[] ordinals = r.getOrdinals();
    String[] tags = new String[ordinals.length];
    for (int i = 0; i < tags.length; i++)
      tags[i] = r.getTag(ordinals[i]);
    return tags;
  }

  /**
   * Incorporate extensions from list into this object.
   * Duplicates are rejected.
   */
  public void merge(BExtensibleEnumList list)
  {
    SlotCursor<Property> c = getProperties();
    while (c.next(BFacets.class))
    {
      Property p = c.property();
      if (p.isFrozen())
      {
        BFacets fThis = (BFacets)c.get();
        BEnumRange rThis = (BEnumRange)fThis.get(BFacets.RANGE);
        int[] ordsThis = rThis.getOrdinals();
        String[] tagsThis = getTags(rThis);

        BFacets fList = (BFacets)list.get(p);
        BEnumRange rList = (BEnumRange)fList.get(BFacets.RANGE);
        int[] ordsList = rList.getOrdinals();
        String[] tagsList = getTags(rList);

        // sanity check
        if (rThis.getFrozenType() != rList.getFrozenType())
          throw new IllegalStateException("Mismatch between frozen types!");

        ArrayList<Integer> vOrds = new ArrayList<>();
        ArrayList<String> vTags = new ArrayList<>();
        for (int i = 0; i < ordsThis.length; i++)
        {
          if (rThis.isDynamicOrdinal(ordsThis[i]))
          {
            vOrds.add(Integer.valueOf(ordsThis[i]));
            vTags.add(tagsThis[i]);
          }
        }
        for (int i = 0; i < ordsList.length; i++)
        {
          if (rList.isDynamicOrdinal(ordsList[i]))
          {
            vOrds.add(Integer.valueOf(ordsList[i]));
            vTags.add(tagsList[i]);
          }
        }

        int[] ords = new int[vOrds.size()];
        String[] tags = new String[vTags.size()];
        for (int i = 0; i < ords.length; i++)
          ords[i] = vOrds.get(i).intValue();
        for (int i = 0; i < tags.length; i++)
          tags[i] = vTags.get(i);


        set(p, BFacets.makeEnum(BEnumRange.make(rThis.getFrozenType(), ords, tags)));
      }
    }
  }

////////////////////////////////////////////////////////////////
//  Niagara Enumeration List
////////////////////////////////////////////////////////////////

  public static final BExtensibleEnumList niagaraEnums = new BExtensibleEnumList();

  static
  {
    niagaraEnums.setErrorCodeFacets(BFacets.makeEnum(BBacnetErrorCode.NIAGARA_ERROR_CODES_RANGE));
  }
}
