/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.*;

/**
 * BBacnetNodeType represents the BACnetNodeType enumeration.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 20 Jan 2009
 * @since Niagara 3.5
 */

@NiagaraType
@NiagaraEnum(
  range = {
    @Range("unknown"),
    @Range("system"),
    @Range("network"),
    @Range("device"),
    @Range("organizational"),
    @Range("area"),
    @Range("equipment"),
    @Range("point"),
    @Range("collection"),
    @Range("property"),
    @Range("functional"),
    @Range("other")
  }
)
public final class BBacnetNodeType
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetNodeType(128625200)1.0$ @*/
/* Generated Thu Jun 02 14:30:02 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  /** Ordinal value for unknown. */
  @Generated
  public static final int UNKNOWN = 0;
  /** Ordinal value for system. */
  @Generated
  public static final int SYSTEM = 1;
  /** Ordinal value for network. */
  @Generated
  public static final int NETWORK = 2;
  /** Ordinal value for device. */
  @Generated
  public static final int DEVICE = 3;
  /** Ordinal value for organizational. */
  @Generated
  public static final int ORGANIZATIONAL = 4;
  /** Ordinal value for area. */
  @Generated
  public static final int AREA = 5;
  /** Ordinal value for equipment. */
  @Generated
  public static final int EQUIPMENT = 6;
  /** Ordinal value for point. */
  @Generated
  public static final int POINT = 7;
  /** Ordinal value for collection. */
  @Generated
  public static final int COLLECTION = 8;
  /** Ordinal value for property. */
  @Generated
  public static final int PROPERTY = 9;
  /** Ordinal value for functional. */
  @Generated
  public static final int FUNCTIONAL = 10;
  /** Ordinal value for other. */
  @Generated
  public static final int OTHER = 11;

  /** BBacnetNodeType constant for unknown. */
  @Generated
  public static final BBacnetNodeType unknown = new BBacnetNodeType(UNKNOWN);
  /** BBacnetNodeType constant for system. */
  @Generated
  public static final BBacnetNodeType system = new BBacnetNodeType(SYSTEM);
  /** BBacnetNodeType constant for network. */
  @Generated
  public static final BBacnetNodeType network = new BBacnetNodeType(NETWORK);
  /** BBacnetNodeType constant for device. */
  @Generated
  public static final BBacnetNodeType device = new BBacnetNodeType(DEVICE);
  /** BBacnetNodeType constant for organizational. */
  @Generated
  public static final BBacnetNodeType organizational = new BBacnetNodeType(ORGANIZATIONAL);
  /** BBacnetNodeType constant for area. */
  @Generated
  public static final BBacnetNodeType area = new BBacnetNodeType(AREA);
  /** BBacnetNodeType constant for equipment. */
  @Generated
  public static final BBacnetNodeType equipment = new BBacnetNodeType(EQUIPMENT);
  /** BBacnetNodeType constant for point. */
  @Generated
  public static final BBacnetNodeType point = new BBacnetNodeType(POINT);
  /** BBacnetNodeType constant for collection. */
  @Generated
  public static final BBacnetNodeType collection = new BBacnetNodeType(COLLECTION);
  /** BBacnetNodeType constant for property. */
  @Generated
  public static final BBacnetNodeType property = new BBacnetNodeType(PROPERTY);
  /** BBacnetNodeType constant for functional. */
  @Generated
  public static final BBacnetNodeType functional = new BBacnetNodeType(FUNCTIONAL);
  /** BBacnetNodeType constant for other. */
  @Generated
  public static final BBacnetNodeType other = new BBacnetNodeType(OTHER);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetNodeType make(int ordinal)
  {
    return (BBacnetNodeType)unknown.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetNodeType make(String tag)
  {
    return (BBacnetNodeType)unknown.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetNodeType(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetNodeType DEFAULT = unknown;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetNodeType.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
