/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * BBacnetShedLevel represents the BACnetShedLevel data type.
 *
 * @author Bishal Debbarma
 * @since Niagara 4.14
 */

@NiagaraType
@NiagaraProperty(
  name = "choice",
  type = "int",
  defaultValue = "0",
  facets = @Facet("BFacets.makeInt(0,2)")
)
@NiagaraProperty(
  name = "percent",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT"
)
@NiagaraProperty(
  name = "level",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT"
)
@NiagaraProperty(
  name = "amount",
  type = "float",
  defaultValue = "0.0f"
)
public final class BBacnetShedLevel
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetShedLevel(4191504533)1.0$ @*/
/* Generated Fri Dec 09 15:22:33 IST 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "choice"

  /**
   * Slot for the {@code choice} property.
   * @see #getChoice
   * @see #setChoice
   */
  @Generated
  public static final Property choice = newProperty(0, 0, BFacets.makeInt(0,2));

  /**
   * Get the {@code choice} property.
   * @see #choice
   */
  @Generated
  public int getChoice() { return getInt(choice); }

  /**
   * Set the {@code choice} property.
   * @see #choice
   */
  @Generated
  public void setChoice(int v) { setInt(choice, v, null); }

  //endregion Property "choice"

  //region Property "percent"

  /**
   * Slot for the {@code percent} property.
   * @see #getPercent
   * @see #setPercent
   */
  @Generated
  public static final Property percent = newProperty(0, BBacnetUnsigned.DEFAULT, null);

  /**
   * Get the {@code percent} property.
   * @see #percent
   */
  @Generated
  public BBacnetUnsigned getPercent() { return (BBacnetUnsigned)get(percent); }

  /**
   * Set the {@code percent} property.
   * @see #percent
   */
  @Generated
  public void setPercent(BBacnetUnsigned v) { set(percent, v, null); }

  //endregion Property "percent"

  //region Property "level"

  /**
   * Slot for the {@code level} property.
   * @see #getLevel
   * @see #setLevel
   */
  @Generated
  public static final Property level = newProperty(0, BBacnetUnsigned.DEFAULT, null);

  /**
   * Get the {@code level} property.
   * @see #level
   */
  @Generated
  public BBacnetUnsigned getLevel() { return (BBacnetUnsigned)get(level); }

  /**
   * Set the {@code level} property.
   * @see #level
   */
  @Generated
  public void setLevel(BBacnetUnsigned v) { set(level, v, null); }

  //endregion Property "level"

  //region Property "amount"

  /**
   * Slot for the {@code amount} property.
   * @see #getAmount
   * @see #setAmount
   */
  @Generated
  public static final Property amount = newProperty(0, 0.0f, null);

  /**
   * Get the {@code amount} property.
   * @see #amount
   */
  @Generated
  public float getAmount() { return getFloat(amount); }

  /**
   * Set the {@code amount} property.
   * @see #amount
   */
  @Generated
  public void setAmount(float v) { setFloat(amount, v, null); }

  //endregion Property "amount"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetShedLevel.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Write the value to the Asn output stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    switch (getChoice())
    {
      case PERCENT_TAG:
        out.writeUnsigned(PERCENT_TAG, getPercent());
        break;
      case LEVEL_TAG:
        out.writeUnsigned(LEVEL_TAG, getLevel());
        break;
      case AMOUNT_TAG:
        out.writeReal(AMOUNT_TAG, getAmount());
        break;
      default:
        throw new IllegalStateException("Invalid BACnetShedLevel type: " + getChoice());
    }
  }

  /**
   * Read the value from the Asn input stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();

    if (in.isValueTag(PERCENT_TAG))
    {
      set(percent, in.readUnsigned(PERCENT_TAG), noWrite);
    }
    else if (in.isValueTag(LEVEL_TAG))
    {
      set(level, in.readUnsigned(LEVEL_TAG), noWrite);
    }
    else if (in.isValueTag(AMOUNT_TAG))
    {
      setFloat(amount, in.readReal(AMOUNT_TAG), noWrite);
    }
    else
    {
      throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }

    setInt(choice, tag, noWrite);
  }

  @Override
  public String toString(Context context)
  {
    switch (getChoice())
    {
      case PERCENT_TAG:
        return "BACnetShedLevel:percent = " + getPercent().toString(context);
      case LEVEL_TAG:
        return "BACnetShedLevel:level = " + getLevel().toString(context);
      case AMOUNT_TAG:
        return "BACnetShedLevel:amount = " + BFloat.toString(getAmount(), context);
      default:
        return "BACnetShedLevel:unknown";
    }
  }

  private static final int PERCENT_TAG = 0;
  private static final int LEVEL_TAG = 1;
  private static final int AMOUNT_TAG = 2;
}
