/*
 * Copyright 2025 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * Represents the BACnetProcessIdSelection choice that is used in the selection of event
 * notification service requests that are to be forwarded by the Notification Forwarder object.
 *
 * @author Uday Rapuru on 09-Jan-2025
 * @since Niagara 4.14U2
 * @since Niagara 4.15U1
 */
@NiagaraType
@NiagaraProperty(
  name = "isNull",
  type = "boolean",
  defaultValue = "true"
)
@NiagaraProperty(
  name = "processIdentifier",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.make(0)"
)
public final class BBacnetProcessIdSelection
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetProcessIdSelection(2302296546)1.0$ @*/
/* Generated Mon Jan 13 14:55:17 CST 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  //region Property "isNull"

  /**
   * Slot for the {@code isNull} property.
   * @see #getIsNull
   * @see #setIsNull
   */
  @Generated
  public static final Property isNull = newProperty(0, true, null);

  /**
   * Get the {@code isNull} property.
   * @see #isNull
   */
  @Generated
  public boolean getIsNull() { return getBoolean(isNull); }

  /**
   * Set the {@code isNull} property.
   * @see #isNull
   */
  @Generated
  public void setIsNull(boolean v) { setBoolean(isNull, v, null); }

  //endregion Property "isNull"

  //region Property "processIdentifier"

  /**
   * Slot for the {@code processIdentifier} property.
   * @see #getProcessIdentifier
   * @see #setProcessIdentifier
   */
  @Generated
  public static final Property processIdentifier = newProperty(0, BBacnetUnsigned.make(0), null);

  /**
   * Get the {@code processIdentifier} property.
   * @see #processIdentifier
   */
  @Generated
  public BBacnetUnsigned getProcessIdentifier() { return (BBacnetUnsigned)get(processIdentifier); }

  /**
   * Set the {@code processIdentifier} property.
   * @see #processIdentifier
   */
  @Generated
  public void setProcessIdentifier(BBacnetUnsigned v) { set(processIdentifier, v, null); }

  //endregion Property "processIdentifier"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetProcessIdSelection.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Default (NULL) constructor
   */
  public BBacnetProcessIdSelection()
  {
  }

  /**
   * Process Identifier constructor.
   */
  public BBacnetProcessIdSelection(BBacnetUnsigned processIdentifier)
  {
    setIsNull(false);
    setProcessIdentifier(processIdentifier);
  }

  /**
   * @return true if choice is null
   */
  @Override
  public boolean isNull()
  {
    return getIsNull();
  }

  @Override
  public void writeAsn(AsnOutput out)
  {
    if (getIsNull())
    {
      out.writeNull();
    }
    else
    {
      long processIdentifier = getProcessIdentifier().getLong();
      if (processIdentifier < 0 || processIdentifier > BBacnetUnsigned.MAX_UNSIGNED_VALUE)
      {
        throw new IllegalStateException("BACnetProcessIdSelection.processIdentifier must be between zero and max Unsigned32 (inclusive)" +
          "; actual: " + processIdentifier);
      }
      out.writeUnsigned(getProcessIdentifier());
    }
  }

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    switch (tag)
    {
      case BacnetConst.ASN_NULL:
        in.readNull();
        setBoolean(isNull, true, noWrite);
        break;
      case BacnetConst.ASN_UNSIGNED:
        BBacnetUnsigned processIdentifier = in.readUnsigned();
        if (processIdentifier.getLong() > BBacnetUnsigned.MAX_UNSIGNED_VALUE)
        {
          throw new OutOfRangeException("BACnetProcessIdSelection.processIdentifier must be less than or equal to max Unsigned32" +
            "; actual: " + processIdentifier.getLong());
        }

        setBoolean(isNull, false, noWrite);
        set(BBacnetProcessIdSelection.processIdentifier, processIdentifier, noWrite);
        break;
      default:
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }
  }

  @Override
  public String toString(Context context)
  {
    StringBuilder builder = new StringBuilder("processId: ");
    if (getIsNull())
    {
      builder.append("null");
    }
    else
    {
      builder.append(getProcessIdentifier().getInt());
    }
    return builder.toString();
  }
}
