/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * Represents the BACnetActionList structure, which contains a sequence of BACnetActionCommands
 *
 * @author Uday Rapuru on 04-Nov-2022
 * @since Niagara 4.14
 */
@NiagaraType
public final class BBacnetActionList
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetActionList(2979906276)1.0$ @*/
/* Generated Mon Nov 14 10:46:09 CST 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetActionList.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * return true if child is a BBacnetActionCommand
   */
  @Override
  public boolean isChildLegal(BComponent child)
  {
    return child instanceof BBacnetActionCommand;
  }

  /**
   * Read the value from the Asn input stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    List<BBacnetActionCommand> actionCommands = new ArrayList<>();
    in.skipOpeningTag(0);
    int tag = in.peekTag();
    while (!in.isClosingTag(0))
    {
      if (tag == AsnInput.END_OF_DATA)
      {
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + AsnInput.END_OF_DATA);
      }

      BBacnetActionCommand actionCommand = new BBacnetActionCommand();
      actionCommand.readAsn(in);
      actionCommands.add(actionCommand);
      tag = in.peekTag();
    }
    in.skipClosingTag(0);

    removeAll(noWrite);
    for (BBacnetActionCommand actionCommand : actionCommands)
    {
      add(null, actionCommand, noWrite);
    }
  }

  /**
   * Write the value to the Asn output stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeOpeningTag(0);
    for (BBacnetActionCommand actionCommand : getChildren(BBacnetActionCommand.class))
    {
      actionCommand.writeAsn(out);
    }
    out.writeClosingTag(0);
  }

  @Override
  public String toString(Context context)
  {
    // Handle PropertySheet with just the top level string
    if (context != null)
    {
      return super.toString(context);
    }

    loadSlots();
    StringJoiner joiner = new StringJoiner(",", "{", "}");
    for (BBacnetActionCommand actionCommand : getChildren(BBacnetActionCommand.class))
    {
      joiner.add(actionCommand.toString(context));
    }
    return joiner.toString();
  }
}
