/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.enums.BBacnetAccumulatorStatus;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetAccumulatorRecord represents the BACnetAccumulatorRecord sequence.
 *
 * @author Bishal Debbarma
 * @since Niagara 4.14
 */
@NiagaraType
@NiagaraProperty(
  name = "timestamp",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()"
)
@NiagaraProperty(
  name = "presentValue",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT"
)
@NiagaraProperty(
  name = "accumulateValue",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT"
)
@NiagaraProperty(
  name = "accumulatorStatus",
  type = "BBacnetAccumulatorStatus",
  defaultValue = "BBacnetAccumulatorStatus.normal"
)
public final class BBacnetAccumulatorRecord
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetAccumulatorRecord(2056699116)1.0$ @*/
/* Generated Tue Jul 25 19:50:04 CDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "timestamp"

  /**
   * Slot for the {@code timestamp} property.
   * @see #getTimestamp
   * @see #setTimestamp
   */
  @Generated
  public static final Property timestamp = newProperty(0, new BBacnetDateTime(), null);

  /**
   * Get the {@code timestamp} property.
   * @see #timestamp
   */
  @Generated
  public BBacnetDateTime getTimestamp() { return (BBacnetDateTime)get(timestamp); }

  /**
   * Set the {@code timestamp} property.
   * @see #timestamp
   */
  @Generated
  public void setTimestamp(BBacnetDateTime v) { set(timestamp, v, null); }

  //endregion Property "timestamp"

  //region Property "presentValue"

  /**
   * Slot for the {@code presentValue} property.
   * @see #getPresentValue
   * @see #setPresentValue
   */
  @Generated
  public static final Property presentValue = newProperty(0, BBacnetUnsigned.DEFAULT, null);

  /**
   * Get the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public BBacnetUnsigned getPresentValue() { return (BBacnetUnsigned)get(presentValue); }

  /**
   * Set the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public void setPresentValue(BBacnetUnsigned v) { set(presentValue, v, null); }

  //endregion Property "presentValue"

  //region Property "accumulateValue"

  /**
   * Slot for the {@code accumulateValue} property.
   * @see #getAccumulateValue
   * @see #setAccumulateValue
   */
  @Generated
  public static final Property accumulateValue = newProperty(0, BBacnetUnsigned.DEFAULT, null);

  /**
   * Get the {@code accumulateValue} property.
   * @see #accumulateValue
   */
  @Generated
  public BBacnetUnsigned getAccumulateValue() { return (BBacnetUnsigned)get(accumulateValue); }

  /**
   * Set the {@code accumulateValue} property.
   * @see #accumulateValue
   */
  @Generated
  public void setAccumulateValue(BBacnetUnsigned v) { set(accumulateValue, v, null); }

  //endregion Property "accumulateValue"

  //region Property "accumulatorStatus"

  /**
   * Slot for the {@code accumulatorStatus} property.
   * @see #getAccumulatorStatus
   * @see #setAccumulatorStatus
   */
  @Generated
  public static final Property accumulatorStatus = newProperty(0, BBacnetAccumulatorStatus.normal, null);

  /**
   * Get the {@code accumulatorStatus} property.
   * @see #accumulatorStatus
   */
  @Generated
  public BBacnetAccumulatorStatus getAccumulatorStatus() { return (BBacnetAccumulatorStatus)get(accumulatorStatus); }

  /**
   * Set the {@code accumulatorStatus} property.
   * @see #accumulatorStatus
   */
  @Generated
  public void setAccumulatorStatus(BBacnetAccumulatorStatus v) { set(accumulatorStatus, v, null); }

  //endregion Property "accumulatorStatus"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetAccumulatorRecord.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeOpeningTag(0);
    getTimestamp().writeAsn(out);
    out.writeClosingTag(0);

    out.writeUnsigned(1, getPresentValue());
    out.writeUnsigned(2, getAccumulateValue());
    out.writeEnumerated(3, getAccumulatorStatus().getOrdinal());
  }

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    in.skipOpeningTag(0);
    BBacnetDate date = in.readDate();
    BBacnetTime time = in.readTime();
    in.skipClosingTag(0);
    BBacnetUnsigned presentValue = in.readUnsigned(1);
    BBacnetUnsigned accumulateValue = in.readUnsigned(2);
    int accumulatorStatus = in.readEnumerated(3);

    BBacnetDateTime timestamp = getTimestamp();
    timestamp.set(BBacnetDateTime.date, date, noWrite);
    timestamp.set(BBacnetDateTime.time, time, noWrite);
    set(BBacnetAccumulatorRecord.presentValue, presentValue, noWrite);
    set(BBacnetAccumulatorRecord.accumulateValue, accumulateValue, noWrite);
    set(BBacnetAccumulatorRecord.accumulatorStatus, BBacnetAccumulatorStatus.make(accumulatorStatus), noWrite);
  }

  @Override
  public String toString(Context context)
  {
    return "BBacnetAccumulatorRecord" +
      ": timestamp = " + getTimestamp().toString(context) +
      "; presentValue = " + getPresentValue().toString(context) +
      "; accumulateValue = " + getAccumulateValue().toString(context) +
      "; accumulatorStatus = " + getAccumulatorStatus().toString(context);
  }
}
