/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOptionalDoorValue;
import javax.baja.bacnet.datatypes.BBacnetPriorityValue;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.enums.access.BBacnetDoorValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetAccessDoor represents the BacnetAccessDoor config.
 *
 * @author Bishal Debbarma
 * @since  Niagara 4.14
 */
@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.ACCESS_DOOR)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.ACCESS_DOOR, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "presentValue",
  type = "BBacnetDoorValue",
  defaultValue = "BBacnetDoorValue.lock",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "statusFlags",
  type = "BBacnetBitString",
  defaultValue = "BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetStatusFlags\"))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP)")
)
/*
 eventState indicates if this object has an active event state.
 */
@NiagaraProperty(
  name = "eventState",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetEventState.NORMAL, BEnumRange.make(BBacnetEventState.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.EVENT_STATE, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "reliability",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetReliability.NO_FAULT_DETECTED, BEnumRange.make(BBacnetReliability.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.RELIABILITY, ASN_ENUMERATED)")
)
/*
 is the physical point represented by this object out of service?
 if TRUE, then this point's Present_Value does NOT reflect the actual state
 of the point.
 */
@NiagaraProperty(
  name = "outOfService",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE, ASN_BOOLEAN)")
)
@NiagaraProperty(
  name = "priorityArray",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BBacnetPriorityValue.TYPE, 16)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.PRIORITY_ARRAY, ASN_BACNET_ARRAY)")
)
@NiagaraProperty(
  name = "relinquishDefault",
  type = "BBacnetDoorValue",
  defaultValue = "BBacnetDoorValue.lock",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.RELINQUISH_DEFAULT, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "doorPulseTime",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.DOOR_PULSE_TIME, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "doorExtendedPulseTime",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.DOOR_EXTENDED_PULSE_TIME, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "doorOpenTooLongTime",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.DOOR_OPEN_TOO_LONG_TIME, ASN_UNSIGNED)")
)
public class BBacnetAccessDoor
  extends BBacnetObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetAccessDoor(3214383509)1.0$ @*/
/* Generated Fri Jul 14 15:16:02 CDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.ACCESS_DOOR), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.ACCESS_DOOR, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "presentValue"

  /**
   * Slot for the {@code presentValue} property.
   * @see #getPresentValue
   * @see #setPresentValue
   */
  @Generated
  public static final Property presentValue = newProperty(0, BBacnetDoorValue.lock, makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE, ASN_ENUMERATED));

  /**
   * Get the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public BBacnetDoorValue getPresentValue() { return (BBacnetDoorValue)get(presentValue); }

  /**
   * Set the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public void setPresentValue(BBacnetDoorValue v) { set(presentValue, v, null); }

  //endregion Property "presentValue"

  //region Property "statusFlags"

  /**
   * Slot for the {@code statusFlags} property.
   * @see #getStatusFlags
   * @see #setStatusFlags
   */
  @Generated
  public static final Property statusFlags = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));

  /**
   * Get the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public BBacnetBitString getStatusFlags() { return (BBacnetBitString)get(statusFlags); }

  /**
   * Set the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public void setStatusFlags(BBacnetBitString v) { set(statusFlags, v, null); }

  //endregion Property "statusFlags"

  //region Property "eventState"

  /**
   * Slot for the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #getEventState
   * @see #setEventState
   */
  @Generated
  public static final Property eventState = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetEventState.NORMAL, BEnumRange.make(BBacnetEventState.TYPE)), makeFacets(BBacnetPropertyIdentifier.EVENT_STATE, ASN_ENUMERATED));

  /**
   * Get the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #eventState
   */
  @Generated
  public BEnum getEventState() { return (BEnum)get(eventState); }

  /**
   * Set the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #eventState
   */
  @Generated
  public void setEventState(BEnum v) { set(eventState, v, null); }

  //endregion Property "eventState"

  //region Property "reliability"

  /**
   * Slot for the {@code reliability} property.
   * @see #getReliability
   * @see #setReliability
   */
  @Generated
  public static final Property reliability = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetReliability.NO_FAULT_DETECTED, BEnumRange.make(BBacnetReliability.TYPE)), makeFacets(BBacnetPropertyIdentifier.RELIABILITY, ASN_ENUMERATED));

  /**
   * Get the {@code reliability} property.
   * @see #reliability
   */
  @Generated
  public BEnum getReliability() { return (BEnum)get(reliability); }

  /**
   * Set the {@code reliability} property.
   * @see #reliability
   */
  @Generated
  public void setReliability(BEnum v) { set(reliability, v, null); }

  //endregion Property "reliability"

  //region Property "outOfService"

  /**
   * Slot for the {@code outOfService} property.
   * is the physical point represented by this object out of service?
   * if TRUE, then this point's Present_Value does NOT reflect the actual state
   * of the point.
   * @see #getOutOfService
   * @see #setOutOfService
   */
  @Generated
  public static final Property outOfService = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE, ASN_BOOLEAN));

  /**
   * Get the {@code outOfService} property.
   * is the physical point represented by this object out of service?
   * if TRUE, then this point's Present_Value does NOT reflect the actual state
   * of the point.
   * @see #outOfService
   */
  @Generated
  public boolean getOutOfService() { return getBoolean(outOfService); }

  /**
   * Set the {@code outOfService} property.
   * is the physical point represented by this object out of service?
   * if TRUE, then this point's Present_Value does NOT reflect the actual state
   * of the point.
   * @see #outOfService
   */
  @Generated
  public void setOutOfService(boolean v) { setBoolean(outOfService, v, null); }

  //endregion Property "outOfService"

  //region Property "priorityArray"

  /**
   * Slot for the {@code priorityArray} property.
   * @see #getPriorityArray
   * @see #setPriorityArray
   */
  @Generated
  public static final Property priorityArray = newProperty(0, new BBacnetArray(BBacnetPriorityValue.TYPE, 16), makeFacets(BBacnetPropertyIdentifier.PRIORITY_ARRAY, ASN_BACNET_ARRAY));

  /**
   * Get the {@code priorityArray} property.
   * @see #priorityArray
   */
  @Generated
  public BBacnetArray getPriorityArray() { return (BBacnetArray)get(priorityArray); }

  /**
   * Set the {@code priorityArray} property.
   * @see #priorityArray
   */
  @Generated
  public void setPriorityArray(BBacnetArray v) { set(priorityArray, v, null); }

  //endregion Property "priorityArray"

  //region Property "relinquishDefault"

  /**
   * Slot for the {@code relinquishDefault} property.
   * @see #getRelinquishDefault
   * @see #setRelinquishDefault
   */
  @Generated
  public static final Property relinquishDefault = newProperty(0, BBacnetDoorValue.lock, makeFacets(BBacnetPropertyIdentifier.RELINQUISH_DEFAULT, ASN_ENUMERATED));

  /**
   * Get the {@code relinquishDefault} property.
   * @see #relinquishDefault
   */
  @Generated
  public BBacnetDoorValue getRelinquishDefault() { return (BBacnetDoorValue)get(relinquishDefault); }

  /**
   * Set the {@code relinquishDefault} property.
   * @see #relinquishDefault
   */
  @Generated
  public void setRelinquishDefault(BBacnetDoorValue v) { set(relinquishDefault, v, null); }

  //endregion Property "relinquishDefault"

  //region Property "doorPulseTime"

  /**
   * Slot for the {@code doorPulseTime} property.
   * @see #getDoorPulseTime
   * @see #setDoorPulseTime
   */
  @Generated
  public static final Property doorPulseTime = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.DOOR_PULSE_TIME, ASN_UNSIGNED));

  /**
   * Get the {@code doorPulseTime} property.
   * @see #doorPulseTime
   */
  @Generated
  public BBacnetUnsigned getDoorPulseTime() { return (BBacnetUnsigned)get(doorPulseTime); }

  /**
   * Set the {@code doorPulseTime} property.
   * @see #doorPulseTime
   */
  @Generated
  public void setDoorPulseTime(BBacnetUnsigned v) { set(doorPulseTime, v, null); }

  //endregion Property "doorPulseTime"

  //region Property "doorExtendedPulseTime"

  /**
   * Slot for the {@code doorExtendedPulseTime} property.
   * @see #getDoorExtendedPulseTime
   * @see #setDoorExtendedPulseTime
   */
  @Generated
  public static final Property doorExtendedPulseTime = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.DOOR_EXTENDED_PULSE_TIME, ASN_UNSIGNED));

  /**
   * Get the {@code doorExtendedPulseTime} property.
   * @see #doorExtendedPulseTime
   */
  @Generated
  public BBacnetUnsigned getDoorExtendedPulseTime() { return (BBacnetUnsigned)get(doorExtendedPulseTime); }

  /**
   * Set the {@code doorExtendedPulseTime} property.
   * @see #doorExtendedPulseTime
   */
  @Generated
  public void setDoorExtendedPulseTime(BBacnetUnsigned v) { set(doorExtendedPulseTime, v, null); }

  //endregion Property "doorExtendedPulseTime"

  //region Property "doorOpenTooLongTime"

  /**
   * Slot for the {@code doorOpenTooLongTime} property.
   * @see #getDoorOpenTooLongTime
   * @see #setDoorOpenTooLongTime
   */
  @Generated
  public static final Property doorOpenTooLongTime = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.DOOR_OPEN_TOO_LONG_TIME, ASN_UNSIGNED));

  /**
   * Get the {@code doorOpenTooLongTime} property.
   * @see #doorOpenTooLongTime
   */
  @Generated
  public BBacnetUnsigned getDoorOpenTooLongTime() { return (BBacnetUnsigned)get(doorOpenTooLongTime); }

  /**
   * Set the {@code doorOpenTooLongTime} property.
   * @see #doorOpenTooLongTime
   */
  @Generated
  public void setDoorOpenTooLongTime(BBacnetUnsigned v) { set(doorOpenTooLongTime, v, null); }

  //endregion Property "doorOpenTooLongTime"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetAccessDoor.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void started()
    throws Exception
  {
    super.started();

    updatePriorityArrayType(priorityArray, BBacnetOptionalDoorValue.TYPE);
  }
}
