function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/controller/ThumbnailController
 */

define(['jquery', 'underscore'], function ($, _) {
  'use strict';

  var each = _.each;
  var ThumbnailController = /*#__PURE__*/function () {
    function ThumbnailController() {
      _classCallCheck(this, ThumbnailController);
    }
    return _createClass(ThumbnailController, [{
      key: "initialize",
      value:
      /**
       * Initialize the thumbnail controller by registering events.
       *
       * When the thumbnailDOM is clicked, this will scroll to that proportional
       * location of the scrolling element.
       *
       * When there is a mousemove, this will scroll the scroll area proportional
       * to the amount of movement that happened with respect to the size of the
       * thumbnail.
       *
       * @param {JQuery} thumbnailDOM this is the thumbnail container the
       * controller will listen on for events.
       * @param {JQuery} scrollDOM the controller will scroll this element to a
       * new location based upon the events that occur on the thumbnailDOM.
       */
      function initialize(thumbnailDOM, scrollDOM) {
        var _this = this;
        this.$thumbnailDOM = thumbnailDOM;
        this.$scrollDOM = scrollDOM;
        var _pointerdown = false,
          _pointermove = false,
          lastEventX = 0,
          lastEventY = 0;
        var domEvents = {
          'pointerdown': function pointerdown(e) {
            _pointerdown = true;
            _pointermove = false;
            var x = e.clientX,
              y = e.clientY;
            lastEventX = x;
            lastEventY = y;
          }
        };
        var documentEvents = {
          'touchmove': function touchmove(e) {
            return _pointerdown && e.preventDefault();
          },
          'pointermove': function pointermove(e) {
            var x = e.clientX,
              y = e.clientY;
            if (_pointerdown) {
              _this.drag(x - lastEventX, y - lastEventY);
            }
            _pointermove = true;
            lastEventX = x;
            lastEventY = y;
          },
          'pointercancel': function pointercancel() {
            _pointerdown = false;
          },
          'pointerup': function pointerup(e) {
            if (_pointerdown && !_pointermove) {
              _this.$click(e.offsetX, e.offsetY);
            }
            _pointerdown = false;
          }
        };
        var applyEventHandlers = function applyEventHandlers(onOrOff) {
          each(domEvents, function (handler, event) {
            event.split(' ').forEach(function (e) {
              return $(thumbnailDOM)[onOrOff](e, handler);
            });
          });
          each(documentEvents, function (handler, event) {
            var m = onOrOff === 'on' ? 'addEventListener' : 'removeEventListener';
            //need passive: false to allow preventDefault to stop scrolling when
            //moving a glyph around.
            event.split(' ').forEach(function (e) {
              return document[m](e, handler, {
                passive: false
              });
            });
          });
        };
        applyEventHandlers('on');
        this.release = function () {
          return applyEventHandlers('off');
        };
      }

      /**
       * Scrolls the wiresheet to position
       *
       * @param {number} x the x position of the click relative to the top left of
       * the thumbnail container
       * @param {number} y the y position of the click relative to the top left of
       * the thumbnail container
       */
    }, {
      key: "scrollTo",
      value: function scrollTo(x, y) {
        var thumbnailDOM = this.$thumbnailDOM,
          scrollDOM = this.$scrollDOM,
          _scrollDOM$ = scrollDOM[0],
          scrollWidth = _scrollDOM$.scrollWidth,
          scrollHeight = _scrollDOM$.scrollHeight,
          halfViewportWidth = scrollDOM.width() / 2,
          halfViewportHeight = scrollDOM.height() / 2;
        scrollDOM.scrollLeft(x / thumbnailDOM.width() * scrollWidth - halfViewportWidth);
        scrollDOM.scrollTop(y / thumbnailDOM.height() * scrollHeight - halfViewportHeight);
      }

      /**
       * Called when there is movement after a click on the thumbnail following
       * a mouse down.
       *
       * @param {number} dx the change in the x position of the mouse since the
       * last event
       * @param {number} dy the change in the y position of the mouse since the
       * last event
       */
    }, {
      key: "drag",
      value: function drag(dx, dy) {
        var thumbnailDOM = this.$thumbnailDOM,
          scrollDOM = this.$scrollDOM,
          _scrollDOM$2 = scrollDOM[0],
          scrollWidth = _scrollDOM$2.scrollWidth,
          scrollHeight = _scrollDOM$2.scrollHeight,
          thumbnailWidth = thumbnailDOM.width(),
          thumbnailHeight = thumbnailDOM.height(),
          currentScrollLeft = scrollDOM.scrollLeft(),
          currentScrollTop = scrollDOM.scrollTop(),
          scrollDx = dx / thumbnailWidth * scrollWidth,
          scrollDy = dy / thumbnailHeight * scrollHeight;
        scrollDOM.scrollLeft(currentScrollLeft + scrollDx);
        scrollDOM.scrollTop(currentScrollTop + scrollDy);
      }

      /**
       * Called when there is a click event on the thumbnail. This will only be
       * called when there is no movement detected prior to the mouse up.
       *
       * @private
       * @param {number} x the x position of the click relative to the top left of
       * the thumbnail container
       * @param {number} y the y position of the click relative to the top left of
       * the thumbnail container
       */
    }, {
      key: "$click",
      value: function $click(x, y) {
        this.scrollTo(x, y);
      }
    }]);
  }();
  return ThumbnailController;
});
