function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/baja/BajaContextMenu
 */
define(['baja!', 'baja!baja:IProtected', 'lex!bajaui,webEditors,wiresheet', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'dialogs', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/commands/AddSlotCommand', 'nmodule/webEditors/rc/wb/commands/ReorderSlotsCommand', 'nmodule/webEditors/rc/wb/mixin/TransferSupport', 'nmodule/webEditors/rc/wb/commands/transfer/TransferCommand', 'nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu', 'nmodule/webEditors/rc/wb/menu/Separator', 'nmodule/webEditors/rc/wb/menu/menuUtils', 'nmodule/webEditors/rc/wb/menu/componentMenuAgent', 'nmodule/wiresheet/rc/wb/baja/bajaUtils', 'nmodule/wiresheet/rc/wb/baja/commands/DeleteRelationsCommand', 'nmodule/wiresheet/rc/wb/commands/PinSlotsCommand', 'nmodule/wiresheet/rc/wb/util/wsMenuUtils', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (baja, types, lexs, Command, CommandGroup, dialogs, $, Promise, _, asyncUtils, feDialogs, compUtils, spaceUtils, PropertySheet, AddSlotCommand, ReorderSlotsCommand, TransferSupport, TransferCommand, CommandGroupContextMenu, Separator, menuUtils, componentMenuAgent, bajaUtils, DeleteRelationsCommand, PinSlotsCommand, wsMenuUtils, wsUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 3),
    bajauiLex = _lexs[0],
    webEditorsLex = _lexs[1],
    wiresheetLex = _lexs[2];
  var addAnnotation = bajaUtils.addAnnotation,
    addOrigin = bajaUtils.addOrigin,
    resolveEntityId = bajaUtils.resolveEntityId,
    isKnob = bajaUtils.isKnob,
    isLink = bajaUtils.isLink;
  var makeNewGroup = menuUtils.makeNewGroup,
    forSubject = menuUtils.forSubject;
  var getRoundedWixelCoords = wsUtils.getRoundedWixelCoords,
    isStub = wsUtils.isStub;
  var resolveStation = spaceUtils.resolveStation;
  var closest = compUtils.closest;
  var IS_NEW_COMMAND = componentMenuAgent.IS_NEW_COMMAND,
    IS_SHOW_ON_WIRESHEET_COMMAND = componentMenuAgent.IS_SHOW_ON_WIRESHEET_COMMAND;
  var getViewOrd = wsMenuUtils.getViewOrd,
    getGotoOrd = wsMenuUtils.getGotoOrd,
    getArrangeAllCommand = wsMenuUtils.getArrangeAllCommand,
    getArrangeSelectedCommand = wsMenuUtils.getArrangeSelectedCommand;

  /**
   * Wiresheet-specific context menu. (At the moment, requires
   * $rendererController and $viewModel to be set externally.)
   *
   * @alias module:nmodule/wiresheet/rc/wb/baja/BajaContextMenu
   * @extends module:nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu
   * @param {module:nmodule/wiresheet/rc/wb/WebWiresheet} ed
   * @constructor
   */
  var BajaContextMenu = function BajaContextMenu(ed) {
    CommandGroupContextMenu.apply(this, arguments);
    TransferSupport(this);
  };
  BajaContextMenu.prototype = Object.create(CommandGroupContextMenu.prototype);
  BajaContextMenu.prototype.constructor = BajaContextMenu;
  BajaContextMenu.prototype.toContextMenu = function (e) {
    var _this = this;
    return Promise.all([this.getSubject(e), this.$getSubjectEntities(e)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        subject = _ref2[0],
        entities = _ref2[1];
      var component = _this.$ed.value();
      if (!subject.length) {
        return _this.rootCommands(e, component);
      } else if (isStub(entities[0])) {
        return _this.stubCommands(subject, entities, e);
      } else if (baja.hasType(subject[0], 'baja:Relation')) {
        return _this.linkCommands(subject, entities);
      } else {
        return _this.componentCommands(subject);
      }
    });
  };
  BajaContextMenu.prototype.rootCommands = function (e, container) {
    var _getRoundedWixelCoord = getRoundedWixelCoords(e, $(e.target).offsetParent()),
      x = _getRoundedWixelCoord.x,
      y = _getRoundedWixelCoord.y,
      vm = this.$viewModel,
      mask = getMask(this.$rendererController),
      selection = this.$rendererController.$selection;
    return Promise.all([makeNewGroup(container, new AddSlotCommand(container, {
      undoable: true
    })), pasteCommand(this, container), pasteSpecialCommand(this, container)]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 3),
        newGroup = _ref4[0],
        pasteCmd = _ref4[1],
        pasteSpecialCommand = _ref4[2];
      addAnnotationSupport(e, newGroup, x, y);
      addOrigin(pasteCmd, x, y);
      addOrigin(pasteSpecialCommand, x, y);
      return new CommandGroup({
        commands: [newGroup, new Separator(), pasteCmd, pasteSpecialCommand, new Separator(), arrangeAllCommand(vm, mask, selection), new Separator(), reorderCommand(container)]
      });
    });
  };
  BajaContextMenu.prototype.componentCommands = function (subject) {
    var that = this;
    return forSubject(this.$ed, subject).then(filterCommands.bind(null, subject[0])).then(function (compCmdGrp) {
      return new CommandGroup({
        commands: _.compact([].concat(_toConsumableArray(compCmdGrp.getChildren()), [new Separator(), arrangeSelectedCommand(that.$viewModel, getMask(that.$rendererController), that.$rendererController.$selection), new Separator(), pinSlotsCommand(subject[0])]))
      });
    });
  };
  BajaContextMenu.prototype.linkCommands = function (subject, entities) {
    var component = subject[0];
    var hasStub = entities.find(isStub);
    var isSingle = [].concat(subject).length === 1;
    var needsWritePermission = !hasStub && hasAdminWriteOnAllComponents(subject);
    var editTags = !hasStub && isSingle && needsWritePermission && makeEditTagsCommand(component);
    return Promise.all([editTags]).then(function (_ref5) {
      var _ref6 = _slicedToArray(_ref5, 1),
        editTagsCommand = _ref6[0];
      return new CommandGroup({
        commands: _.compact([new DeleteRelationsCommand(subject), editRelationCommand(subject), editTagsCommand])
      });
    });
  };

  /**
   * Makes a CommandGroup with only commands applicable to a stub
   * entity where the subject could be a Knob object or a baja.Relation value
   * 
   * @param {Array<baja.Relation|Object>} subject
   * @param {Array<Object>} entities
   * @param {Event} e
   * @returns {Promise.<module:bajaux/commands/CommandGroup>}
   */
  BajaContextMenu.prototype.stubCommands = function (subject, entities, e) {
    var _this2 = this;
    var rendererController = this.$rendererController;
    var mouseEntities = rendererController.$getEntitiesUnderMouse(e);
    return Promise.all(entities.map(function (entity) {
      return rendererController.$displayForStub(entity, mouseEntities);
    })).then(function (displayNames) {
      var viewModel = _this2.$viewModel;
      return Promise.all([gotoRelationCommands(subject, viewModel, displayNames, true), gotoRelationCommands(subject, viewModel, displayNames, false), getDeletionCommands(subject, displayNames)]);
    }).then(function (commands) {
      return new CommandGroup({
        commands: _.compact(commands)
      });
    });
  };
  BajaContextMenu.prototype.getSubject = function (e) {
    var base = this.$ed.value();
    var viewModel = this.$viewModel;
    return this.$getSubjectEntities(e).then(function (entities) {
      return toBajaValues(entities, base, viewModel);
    });
  };
  BajaContextMenu.prototype.$getSubjectEntities = function (e) {
    return this.$rendererController.getSubject(e);
  };

  /**
   * 
   * @private
   * @param {Event} e 
   * @returns {Promise<Object|undefined>}
   */
  BajaContextMenu.prototype.$getStub = function (e) {
    return this.$rendererController.getSubject(e).then(function (entities) {
      return isStub(entities[0]);
    });
  };
  function filterCommands(subject, commandGroup) {
    var newCmd = commandGroup.findCommand(IS_NEW_COMMAND),
      showOnWsCmd = commandGroup.findCommand(IS_SHOW_ON_WIRESHEET_COMMAND);
    var filteredGroup = newCmd ? commandGroup.remove(newCmd) : commandGroup;
    return showOnWsCmd ? filteredGroup.remove(showOnWsCmd) : filteredGroup;
  }
  function addAnnotationSupport(e, cmd, x, y) {
    if (cmd instanceof TransferCommand) {
      addAnnotation(cmd, x, y, 8);
    }
    if (!cmd.isCommand() && cmd instanceof CommandGroup) {
      _.each(cmd.getChildren(), function (addCmd) {
        addAnnotation(addCmd, x, y, 8);
      });
    }
  }
  function pasteCommand(ed, subject) {
    return TransferCommand.make(ed, 'paste', {
      module: 'webEditors',
      lex: 'commands.paste',
      subject: _.isArray(subject) ? subject : [subject]
    });
  }
  function pasteSpecialCommand(ed, subject) {
    return TransferCommand.make(ed, 'pasteSpecial', {
      module: 'webEditors',
      lex: 'commands.pasteSpecial',
      subject: _.isArray(subject) ? subject : [subject]
    });
  }
  function editRelationCommand(subject) {
    var relations = subject.filter(function (s) {
      return baja.hasType(s, 'baja:Relation');
    });
    var editDisplay = bajauiLex.get('commands.editRelations.label');
    return new Command({
      module: 'bajaui',
      lex: 'commands.editRelations',
      enabled: relations.length === 1,
      func: function func() {
        return resolveStation().then(function (station) {
          return feDialogs.showFor({
            title: editDisplay,
            value: relations[0],
            properties: {
              ordBase: station,
              showHeader: false,
              showControls: false
            },
            formFactor: 'max',
            type: PropertySheet,
            onSaveError: function onSaveError() {
              var errorMsg = webEditorsLex.get("command.error", editDisplay);
              return feDialogs.error(errorMsg);
            }
          });
        });
      }
    });
  }
  function getLex(_ref7) {
    var subject = _ref7.subject,
      withViewOrd = _ref7.withViewOrd;
    if (withViewOrd) {
      if (isKnob(subject) || isLink(subject)) {
        return 'linkGotoLink';
      } else {
        return 'relationGotoRelation';
      }
    } else {
      if (isKnob(subject) || isLink(subject)) {
        return 'linkGoto';
      } else {
        return 'relationGoto';
      }
    }
  }
  function resolveGoToCommand(_ref8) {
    var subject = _ref8.subject,
      vm = _ref8.vm,
      module = _ref8.module,
      withViewOrd = _ref8.withViewOrd,
      displayName = _ref8.displayName;
    var lex, func;
    if (withViewOrd) {
      func = function func() {
        return getViewOrd(subject, vm).then(function (ord) {
          if (ord) {
            return niagara.env.hyperlink(ord);
          }
        })["catch"](feDialogs.error);
      };
    } else {
      func = function func() {
        var gotoOrd = getGotoOrd(subject);
        if (gotoOrd) {
          return baja.Ord.make(gotoOrd).get({
            base: baja.station
          }).then(function (c) {
            return niagara.env.hyperlink(c.getNavOrd());
          })["catch"](feDialogs.error);
        }
      };
    }
    if (!displayName) {
      lex = getLex({
        subject: subject,
        withViewOrd: withViewOrd
      });
      module = 'wiresheet';
    }
    return new Command({
      subject: subject,
      vm: vm,
      lex: lex,
      module: module,
      func: func,
      displayName: displayName
    });
  }
  function gotoRelationCommands(subjects, vm, displayNames, withViewOrd) {
    var primarySubject = subjects[0];
    var condensedDisplayNames = _.compact(displayNames);
    if (condensedDisplayNames.length < 2) {
      return resolveGoToCommand({
        subject: primarySubject,
        vm: vm,
        withViewOrd: withViewOrd
      });
    } else {
      return Promise.all(subjects.map(function (subject, i) {
        if (displayNames[i]) {
          return resolveGoToCommand({
            subject: subject,
            vm: vm,
            withViewOrd: withViewOrd,
            displayName: String(displayNames[i])
          });
        }
      })).then(function (commands) {
        var lex = getLex({
          subject: primarySubject,
          withViewOrd: withViewOrd
        });
        return new CommandGroup({
          displayName: '%lexicon(wiresheet:' + lex + '.displayName)%',
          icon: wiresheetLex.get(lex + '.icon'),
          commands: _.compact(commands)
        });
      });
    }
  }
  function getDeletionCommands(subjects, displayNames) {
    var condensedDisplayNames = _.compact(displayNames);
    if (condensedDisplayNames.length < 2) {
      return new DeleteRelationsCommand(subjects);
    } else {
      return Promise.all(subjects.map(function (subject, i) {
        if (displayNames[i]) {
          return new DeleteRelationsCommand(subject, String(displayNames[i]));
        }
      })).then(function (commands) {
        commands.unshift(new DeleteRelationsCommand(subjects, '%lexicon(bajaui:commands.deleteRelationsAll)%'));
        return new CommandGroup({
          displayName: '%lexicon(bajaui:commands.deleteRelations.displayName)%',
          icon: bajauiLex.get('commands.deleteRelations.icon'),
          commands: _.compact(commands)
        });
      });
    }
  }
  function reorderCommand(component) {
    var cmd = new ReorderSlotsCommand(component);
    cmd.setEnabled(component.getPermissions().hasAdminWrite());
    return cmd;
  }
  function arrangeAllCommand(viewModel, mask, selection) {
    return getArrangeAllCommand(viewModel, mask, selection);
  }
  function arrangeSelectedCommand(viewModel, mask, selection) {
    return getArrangeSelectedCommand(viewModel, mask, selection);
  }
  function getMask(renderController) {
    return renderController.$layoutStrategy.$mask;
  }
  function pinSlotsCommand(component) {
    var cmd = new PinSlotsCommand(component);
    cmd.setEnabled(component.getPermissions().hasAdminWrite());
    return cmd;
  }
  function hasAdminWriteOnAllComponents(components) {
    var _iterator = _createForOfIteratorHelper(components),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var comp = _step.value;
        var bIProtected = closest(comp, 'baja:IProtected');
        if (bIProtected && !bIProtected.getPermissions().hasAdminWrite()) {
          return false;
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    return true;
  }

  /**
   * @param {Array.<object>} entities vertices/triples being right-clicked
   * @param {baja.Component} base base to resolve ORDs against
   * @param {module:nmodule/wiresheet/rc/core/ViewModel} viewModel
   * @returns {Promise.<Array.<baja.Value>>}
   */
  function toBajaValues(entities, base, viewModel) {
    return Promise.all(entities.map(function (entity) {
      var id = viewModel.getId(entity.predicate || entity);
      return resolveEntityId(id, {
        base: base
      });
    }));
  }

  /**
   * @param {baja.Complex} complex item being right-clicked
   * @returns {Promise.<module:nmodule/tagdictionary/rc/commands/TagManagerCommand|null>}
   */
  var makeEditTagsCommand = function makeEditTagsCommand(complex) {
    //prevent JsBuildVerificationTests failures
    var requireJsId = 'nmodule'.toLowerCase() + '/tagdictionary/rc/commands/TagManagerCommand';
    return baja.$requireFromJsBuild(requireJsId, 'tagdictionary:TagDictionaryJsBuild').then(function (TagManagerCommand) {
      return TagManagerCommand.make(complex);
    })["catch"](function (ignore) {
      return null;
    });
  };
  return BajaContextMenu;
});
