function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */
/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/WsOptions
 */
define(['nmodule/wiresheet/rc/wb/WbConstants', 'nmodule/webEditors/rc/servlets/userData'], function (WbConstants, userData) {
  'use strict';

  var USER_DATA_KEY = 'WsOptionsOptions';
  var _WbConstants$DEFAULT_ = WbConstants.DEFAULT_USER_OPTIONS,
    SHOW_GRID = _WbConstants$DEFAULT_.SHOW_GRID,
    SHOW_STATUS_COLORS = _WbConstants$DEFAULT_.SHOW_STATUS_COLORS,
    SHOW_THUMBNAIL = _WbConstants$DEFAULT_.SHOW_THUMBNAIL,
    SHOW_LINKS = _WbConstants$DEFAULT_.SHOW_LINKS,
    SHOW_RELATIONS = _WbConstants$DEFAULT_.SHOW_RELATIONS,
    THUMBNAIL_X = _WbConstants$DEFAULT_.THUMBNAIL_X,
    THUMBNAIL_Y = _WbConstants$DEFAULT_.THUMBNAIL_Y,
    LINK_HIGHLIGHTING = _WbConstants$DEFAULT_.LINK_HIGHLIGHTING,
    MAX_WIDTH = _WbConstants$DEFAULT_.MAX_WIDTH,
    MAX_HEIGHT = _WbConstants$DEFAULT_.MAX_HEIGHT,
    DEFAULT_USER_OPTIONS = {
      showGrid: SHOW_GRID,
      showStatusColors: SHOW_STATUS_COLORS,
      showThumbnail: SHOW_THUMBNAIL,
      showLinks: SHOW_LINKS,
      showRelations: SHOW_RELATIONS,
      thumbnailX: THUMBNAIL_X,
      thumbnailY: THUMBNAIL_Y,
      linkHighlighting: LINK_HIGHLIGHTING,
      maxWidth: MAX_WIDTH,
      maxHeight: MAX_HEIGHT
    };

  /**
   * Wiresheet user options
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/WsOptions
   */
  return /*#__PURE__*/function () {
    /**
     * @param [params]
     * @param {Boolean} params.showGrid
     * @param {Boolean} params.showStatusColors
     * @param {Boolean} params.showThumbnail
     * @param {Boolean} params.showLinks
     * @param {Boolean} params.showRelations
     * @param {Number} params.thumbnailX
     * @param {Number} params.thumbnailY
     * @param {Boolean} params.linkHighlighting
     * @param {Number} params.maxWidth
     * @param {Number} params.maxHeight
     */
    function WsOptions() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck(this, WsOptions);
      this.showGrid = !!params.showGrid;
      this.showStatusColors = !!params.showStatusColors;
      this.showThumbnail = !!params.showThumbnail;
      this.showLinks = !!params.showLinks;
      this.showRelations = !!params.showRelations;
      this.thumbnailX = isNaN(params.thumbnailX) ? THUMBNAIL_X : params.thumbnailX;
      this.thumbnailY = isNaN(params.thumbnailY) ? THUMBNAIL_Y : params.thumbnailY;
      this.linkHighlighting = !!params.linkHighlighting;
      this.maxWidth = params.maxWidth || MAX_WIDTH;
      this.maxHeight = params.maxHeight || MAX_HEIGHT;
    }

    /**
     * 
     * @returns {Promise.<module:nmodule/wiresheet/rc/wb/WsOptions>}
     */
    return _createClass(WsOptions, [{
      key: "saveToUserData",
      value:
      /**
       * Persist wiresheet options to user data.
       *
       * @returns {Promise}
       */
      function saveToUserData() {
        return userData.putJson(USER_DATA_KEY, this);
      }
    }], [{
      key: "make",
      value: function make() {
        return userData.getJson(USER_DATA_KEY).then(function (userOptions) {
          if (userOptions) {
            return new WsOptions(userOptions);
          }
          return new WsOptions(DEFAULT_USER_OPTIONS);
        });
      }
    }]);
  }();
});
