function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/fe/AlarmTransitionBitsEditor
 */
define(['baja!alarm:AlarmTransitionBits', 'bajaux/spandrel', 'underscore', 'nmodule/alarm/rc/baja/AlarmTransitionBits', 'nmodule/webEditors/rc/fe/baja/BooleanPicker', 'css!nmodule/alarm/rc/fe/alarmEditors'], function (types, spandrel, _, AlarmTransitionBits, BooleanPicker) {
  'use strict';

  var contains = _.contains;
  var SHOW_OFF_NORMAL = AlarmTransitionBits.SHOW_OFF_NORMAL,
    SHOW_FAULT = AlarmTransitionBits.SHOW_FAULT,
    SHOW_NORMAL = AlarmTransitionBits.SHOW_NORMAL,
    SHOW_ALERT = AlarmTransitionBits.SHOW_ALERT;
  var keys = ['toOffnormal', 'toFault', 'toNormal', 'toAlert'];
  var keysToShowKeys = {
    toOffnormal: SHOW_OFF_NORMAL,
    toFault: SHOW_FAULT,
    toNormal: SHOW_NORMAL,
    toAlert: SHOW_ALERT
  };

  /**
   * Editor for working with `alarm:AlarmTransitionBits` values. It will initialize boolean editors
   * for the four available bits of an `AlarmTransitionBits`. If any Properties for a particular bit
   * (e.g. `AlarmTransitionBits.SHOW_ALERT`) are set to `false`, those editors will be hidden.
   *
   * @class
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @alias module:nmodule/alarm/rc/fe/AlarmTransitionBitsEditor
   */
  var AlarmTransitionBitsEditor = /*#__PURE__*/function (_spandrel) {
    function AlarmTransitionBitsEditor() {
      _classCallCheck(this, AlarmTransitionBitsEditor);
      return _callSuper(this, AlarmTransitionBitsEditor, arguments);
    }
    _inherits(AlarmTransitionBitsEditor, _spandrel);
    return _createClass(AlarmTransitionBitsEditor, [{
      key: "doRead",
      value:
      /**
       * Resolve a new `alarm:AlarmTransitionBits` instance with the bits set
       * according to the current values of the boolean editors.
       *
       * @returns {Promise.<module:nmodule/alarm/rc/baja/AlarmTransitionBits>}
       */
      function doRead() {
        return this.$getPicker().read().then(function (selectedKeys) {
          return AlarmTransitionBits.make.apply(AlarmTransitionBits, _toConsumableArray(keys.map(function (key) {
            return contains(selectedKeys, key);
          })));
        });
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/BooleanPicker}
       */
    }, {
      key: "$getPicker",
      value: function $getPicker() {
        return this.queryWidget('0');
      }
    }]);
  }(spandrel(function (transitionBits, _ref) {
    var properties = _ref.properties;
    var choices = getChoices(properties);
    var activeKeys = getActiveKeys(transitionBits);
    return spandrel.jsx(BooleanPicker, {
      value: activeKeys,
      properties: {
        choices: choices
      }
    });
  }));
  /**
   * @param {module:nmodule/alarm/rc/baja/AlarmTransitionBits} transitionBits
   * @returns {Array.<string>} keys representing the bits that are set
   */
  function getActiveKeys(transitionBits) {
    var bits = [transitionBits.isToOffNormal(), transitionBits.isToFault(), transitionBits.isToNormal(), transitionBits.isToAlert()];
    return keys.filter(function (key, i) {
      return bits[i];
    });
  }

  /**
   * @param {object} props editor properties (showAlert may be false etc)
   * @returns {Array.<module:nmodule/webEditors/rc/fe/baja/BooleanPicker~Choice>} boolean choices
   * to show to the user
   */
  function getChoices(props) {
    return keys.map(function (key) {
      var hidden = props[keysToShowKeys[key]] === false;
      return {
        value: key,
        hidden: hidden
      };
    });
  }
  return AlarmTransitionBitsEditor;
});
