/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/table/columns/TimestampColumn
 */
define(['lex!alarm', 'Promise', 'nmodule/alarm/rc/console/table/columns/DefaultColumn', 'nmodule/webEditors/rc/util/textUtils'], function (lexs, Promise, DefaultColumn, textUtils) {
  'use strict';

  var lex = lexs[0];

  /**
   * TimestampColumn
   *
   * @class
   * @extends {module:nmodule/alarm/rc/console/table/columns/DefaultColumn}
   * @alias {module:nmodule/alarm/rc/console/table/columns/TimestampColumn}
   * @param {module:nmodule/alarm/rc/console/support/AlarmConsoleSupport} support
   * @param {String} name the column name
   */
  var TimestampColumn = function TimestampColumn(support, name) {
    this.$support = support;
    DefaultColumn.apply(this, [name, {
      displayName: lex.get({
        key: 'alarm.console.columns.' + name,
        def: textUtils.toFriendly(name)
      })
    }]);
  };
  TimestampColumn.prototype = Object.create(DefaultColumn.prototype);
  TimestampColumn.prototype.constructor = TimestampColumn;

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {jQuery} dom
   * @returns {Promise}
   */
  TimestampColumn.prototype.buildCell = function (row, dom) {
    var support = this.$support,
      str = support.createDateString(this.getValueFor(row), row.getSubject().alarmData.TimeZone);
    dom.attr("title", str);
    return Promise.resolve(dom.text(str));
  };
  return TimestampColumn;
});
