function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/entsecHx/rc/photoID/PhotoIdViewerListWidget
 */
define(['baja!', 'bajaux/icon/iconUtils', 'jquery', 'Promise', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/fe/fe', 'nmodule/videoDriver/rc/fe/surveillance/DeviceListWidget', 'nmodule/entsecHx/rc/photoID/rpc/rpc', 'underscore', 'lex!entsecHx'], function (baja, iconUtils, $, Promise, subscriberMixIn, fe, DeviceListWidget, rpc, _, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      lex = _lexs[0];

  var tpl = function tpl() {
    return "<span class=\"title\">".concat(lex.getSafe('PhotoIdViewer.deviceList.label'), "</span>\n                     <div class=\"deviceList\"></div>");
  };
  /**
   * Trims the given ord down to only the slot part.
   * @param {string} ordString
   * @returns {string}
   */


  var trimToSlotPath = function trimToSlotPath(ordString) {
    return ordString === "null" ? "null" : /slot:\/(.)*/.exec(ordString)[0];
  };
  /**
   * Class to show the Camera and Reader devices for the PhotoId Viewer.
   *
   ** API Status: **Private**
   * @class
   * @alias module:nmodule/entsecHx/rc/photoID/PhotoIdViewerListWidget
   * @extends module:nmodule/videoDriver/rc/fe/surveillance/DeviceListWidget
   */


  var PhotoIdViewerListWidget = /*#__PURE__*/function (_DeviceListWidget) {
    _inherits(PhotoIdViewerListWidget, _DeviceListWidget);

    var _super = _createSuper(PhotoIdViewerListWidget);

    function PhotoIdViewerListWidget() {
      _classCallCheck(this, PhotoIdViewerListWidget);

      return _super.apply(this, arguments);
    }

    _createClass(PhotoIdViewerListWidget, [{
      key: "doInitialize",

      /**
       * Initializes the dom.
       *
       * @param {jquery} dom
       */
      value: function doInitialize(dom) {
        var _this = this;

        dom.html(tpl()).addClass('PhotoIdViewerListWidget');
        this.$cameraIdentityStore = {};
        return iconUtils.toHtml(['module://icons/x16/card.png', 'module://videoDriver/icons/camera.png', 'module://icons/x16/delete.png', 'module://icons/x16/deleteLinks.png'], true).then(function (html) {
          html = $(html);
          _this.$cardImgJq = $(html.get(0));
          _this.$cameraImgJq = $(html.get(1));
          _this.$deleteImgJq = $(html.get(2)).addClass('removeDevice').attr('title', lex.get('PhotoIdViewerListWidget.removeDevice.title'));
          _this.$deleteLinksImgJq = $(html.get(3)).addClass('removeFromView').attr('title', lex.get('PhotoIdViewerListWidget.removeFromView.title'));
        });
      }
      /**
       * @private
       * @param {string} value
       * @param {number} index
       * @returns {string}
       */

    }, {
      key: "$getDeviceJq",
      value: function $getDeviceJq(value, index) {
        var _this2 = this;

        var deviceValue = _.escape(value);

        var className = "box".concat(index);
        var slotPath = '';
        var html = ''; // Remove the key from identity store, it will help to handle duplicate reader names.

        Object.keys(this.$cameraIdentityStore).forEach(function (key) {
          if (_this2.$cameraIdentityStore[key] === value) {
            slotPath = key;
          }
        });
        delete this.$cameraIdentityStore[slotPath];
        var imgJq = this.$isPhotoIdCamera(slotPath) ? this.$cardImgJq : this.$cameraImgJq;

        if (this.value().getPermissions().hasAdminWrite()) {
          html = $("<div class=\"deviceBox fourColumnGrid ".concat(className, " \" title=\"").concat(deviceValue, "\" draggable=\"true\">"));
          imgJq.clone().appendTo(html);
          $("<div class=\"deviceText\">".concat(deviceValue, "</div>")).appendTo(html);
          this.$deleteImgJq.clone().appendTo(html);
          this.$deleteLinksImgJq.clone().appendTo(html);
          html.on('click', '.removeDevice', function () {
            _this2.jq().trigger('removeDevice', [slotPath, className]);
          });
          html.on('click', '.removeFromView', function () {
            _this2.jq().trigger('removeFromView', [slotPath]);
          });
        } else {
          html = $("<div class=\"deviceBox twoColumnGrid ".concat(className, " \" title=\"").concat(deviceValue, "\" draggable=\"true\">"));
          imgJq.clone().appendTo(html);
          $("<div class=\"deviceText\">".concat(deviceValue, "</div>")).appendTo(html);
        }

        return html;
      }
      /**
       * @private
       * @param {string} cameraId
       * @returns {boolean}
       */

    }, {
      key: "$isBUuid",
      value: function $isBUuid(cameraId) {
        return cameraId.length === 36 && cameraId.charAt(8) === '-' && cameraId.charAt(13) === '-' && cameraId.charAt(18) === '-' && cameraId.charAt(23) === '-';
      }
      /**
       * @private
       * @param {string} ord
       * @returns {string}
       */

    }, {
      key: "$isPhotoIdCamera",
      value: function $isPhotoIdCamera(ord) {
        try {
          var cameraId = baja.SlotPath.unescape(ord.substring(ord.lastIndexOf('/') + 1, ord.length));

          if (this.$isBUuid(cameraId)) {
            return cameraId;
          }
        } catch (err) {
          return undefined;
        }

        return undefined;
      }
      /**
       * @private
       * @param {baja.Component} device
       * @returns {Array}
       */

    }, {
      key: "$getExcludedCameras",
      value: function $getExcludedCameras(device) {
        return device.getExcludeCameras().getOrds().map(function (ord) {
          return trimToSlotPath(ord.toString());
        });
      }
      /**
       * This method gets the list of added cameras in the station and excludes
       * the ones present in getExcludeCameras of Surveillance Viewer instance.
       *
       * @param {baja.Component} device
       * @returns {Promise}
       */

    }, {
      key: "getAddedDevices",
      value: function getAddedDevices(device) {
        var _this3 = this;

        var currentOrdList = device.get('currentOrdList');
        var deviceOrdList = currentOrdList ? currentOrdList.getOrds() : [];
        var cameraListObj = {};
        var excludedCameraOrds = this.$getExcludedCameras(device);
        return this.$addPhotoIdCamera(deviceOrdList).then(function () {
          return Promise.map(deviceOrdList, function (eachDevice) {
            return rpc.getOrd(eachDevice);
          }).then(function (resolvedCameraList) {
            resolvedCameraList.forEach(function (camera) {
              if (camera) {
                var slotPath = trimToSlotPath(camera.getNavOrd());

                if (excludedCameraOrds.indexOf(slotPath) === -1) {
                  // In case of remote camera, it wouldn't have a videoDeviceId, consider displayName then.
                  var cameraDescription = camera.getVideoDeviceId ? camera.getVideoDeviceId().getDescription() : camera.getDisplayName();
                  cameraListObj[slotPath] = cameraDescription;
                  _this3.$cameraIdentityStore[slotPath] = cameraDescription;
                }
              }
            });
            return cameraListObj;
          });
        });
      }
      /**
       * Create photo id camera dynamic slots in the photo id network.
       * Duplicate slot check is performed on the server side ensuring no exceptions.
       *
       * @private
       * @param {Array<baja.Ord>>} deviceOrdList
       * @returns {Promise}
       */

    }, {
      key: "$addPhotoIdCamera",
      value: function $addPhotoIdCamera(deviceOrdList) {
        var _this4 = this;

        var promList = [];
        deviceOrdList.forEach(function (deviceOrd) {
          var uuid;

          if (uuid = _this4.$isPhotoIdCamera(deviceOrd.$ord)) {
            promList.push(rpc.addPhotoIdCamera([uuid]));
          }
        });
        return Promise.all(promList);
      }
      /**
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('PhotoIdViewerListWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);

    return PhotoIdViewerListWidget;
  }(DeviceListWidget);

  return PhotoIdViewerListWidget;
});
