function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/entsecHx/rc/photoID/ButtonsPane
 */
define(['baja!', 'jquery', 'bajaux/Widget', 'dialogs', 'Promise', 'bajaux/events', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'nmodule/webEditors/rc/fe/BaseWidget', 'lex!entsecHx', 'nmodule/webEditors/rc/fe/fe', 'nmodule/entsecHx/rc/photoID/rpc/rpc', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/util/ListSelection', 'nmodule/history/rc/TableFilter'], function (baja, $, Widget, dialogs, Promise, events, Command, CommandButton, BaseWidget, lexs, fe, photoIdRpc, Table, TableModel, JsonObjectPropertyColumn, Row, ListSelection, TableFilter) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      lex = _lexs[0];

  var tpl = function tpl() {
    return "\n    <button type=\"button\" class=\"readerCommand\"/>\n    <button type=\"button\" class=\"cameraCommand\"></button>\n  ";
  };
  /**
   * ButtonsPane view for addReader and addCamera buttons of photoIdViewer
   *
   * API Status: **Private**
   * @class
   * @alias module:nmodule/entsecHx/rc/photoID/ButtonsPane
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @param {Object} params
   */


  var ButtonsPane = /*#__PURE__*/function (_BaseWidget) {
    _inherits(ButtonsPane, _BaseWidget);

    var _super = _createSuper(ButtonsPane);

    function ButtonsPane() {
      _classCallCheck(this, ButtonsPane);

      return _super.apply(this, arguments);
    }

    _createClass(ButtonsPane, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('ButtonsPane');
        this.$filterMap = {};
      }
      /**
       * Loads the value into the ButtonsPane
       *
       * @param {baja.Component} value a `entsec:PhotoIDViewerComponent` instance
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this = this;

        return Promise.all([fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: this.$getReaderElement(),
          value: new Command({
            module: 'entsecHx',
            lex: 'commands.addReader',
            func: this.$showDialog.bind(this, 'reader')
          })
        }), fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: this.$getCameraElement(),
          value: new Command({
            module: 'entsecHx',
            lex: 'commands.addCamera',
            func: this.$showDialog.bind(this, 'camera')
          })
        })]).spread(function (readerCommandButton, cameraCommandButton) {
          _this.$readerCommandButton = readerCommandButton;
          _this.$cameraCommandButton = cameraCommandButton;
        });
      }
      /**
       * @private
       * @param deviceName
       * @returns {module:dialogs~Dialog}
       */

    }, {
      key: "$showDialog",
      value: function $showDialog(deviceName) {
        this.$deviceName = deviceName;
        return this.$deviceDialog = dialogs.show({
          title: deviceName === 'reader' ? lex.get('commands.addReader.displayName') : lex.get('commands.addCamera.displayName'),
          content: this.$getDialogContent.bind(this),
          buttons: this.$getButtons()
        });
      }
      /**
       * @private
       * @returns {Array<Object>}
       */

    }, {
      key: "$getButtons",
      value: function $getButtons() {
        return [{
          name: 'add',
          displayName: lex.get('commands.add'),
          handler: this.$deviceAddedHandler.bind(this)
        }, {
          name: 'close',
          displayName: lex.get('commands.close')
        }, {
          name: 'filter',
          displayName: lex.get('commands.filter'),
          handler: this.$showFilterDialog.bind(this)
        }];
      }
      /**
       * @private
       */

    }, {
      key: "$deviceAddedHandler",
      value: function $deviceAddedHandler() {
        if (this.$deviceName === 'reader') {
          // Add the photoIdCamera as a dynamic slot in the PhotoIdNetwork.
          Object.keys(this.$selectedRows).forEach(function (uuid) {
            photoIdRpc.addPhotoIdCamera([uuid])["catch"](baja.error);
          });
        }

        var eventName = this.$deviceName === 'reader' ? 'readerAdded' : 'cameraAdded';
        this.jq().trigger(eventName, [this.$selectedRows]);
      }
      /**
       * Adds the tableModel columns to the TableFilter
       * @returns {Array.<module:nmodule/webEditors/rc/wb/table/model/Column>}
       */

    }, {
      key: "getFilterColumns",
      value: function getFilterColumns() {
        var columns = this.$tableModel.getColumns();
        return columns;
      }
    }, {
      key: "$showFilterDialog",

      /**
       * @private
       * @param {module:dialogs~Dialog} dialog
       * @returns {Promise}
       */
      value: function $showFilterDialog(dialog) {
        var _this2 = this;

        var tableFilter;

        if (!(tableFilter = this.$filterMap[this.$deviceName])) {
          tableFilter = TableFilter.makeFor(this);
          this.$filterMap[this.$deviceName] = tableFilter;
          tableFilter.on('filterChanged', function (evt, modifiedTableFilter) {
            _this2.$filterMap[_this2.$deviceName] = modifiedTableFilter; // Closing the device dialog and relaunching a new device dialog with the modified filter set.
            // Used a field instead of the parameterized dialog, sometimes the dialog parameter
            // does not respond to the actions.

            _this2.$deviceDialog.close();

            Promise.resolve(_this2.$showDialog(_this2.$deviceName))["catch"](baja.error);
          });
        }

        return tableFilter.invoke().then(function () {
          // Upon ok or cancel of the filter dialog, set the filter status.
          _this2.$setFilterStatus(dialog); // Rejecting the promise to stop the ok click promise propagation to outer dialog.
          // eslint-disable-next-line prefer-promise-reject-errors


          throw Promise.reject();
        });
      }
      /**
       * @private
       * @param {module:dialogs~Dialog} dialog
       */

    }, {
      key: "$setFilterStatus",
      value: function $setFilterStatus(dialog) {
        var filterSet;
        var isFilterEnabled = false;
        var buttonJq = dialog.buttonJq('filter').find(".ux-btn");
        var tableFilter = this.$filterMap[this.$deviceName];

        if (tableFilter && (filterSet = tableFilter.getFilterSet())) {
          filterSet.getSlots().toArray().forEach(function (slot) {
            isFilterEnabled = isFilterEnabled || filterSet.get(slot).getActive();
          });
        }

        if (isFilterEnabled) {
          buttonJq.addClass('redFilterColor');
        } else {
          buttonJq.removeClass('redFilterColor');
        }
      }
      /**
       * @private
       * @param {module:dialogs~Dialog} dialog
       * @returns {Promise}
       */

    }, {
      key: "$getDialogContent",
      value: function $getDialogContent(dialog) {
        var _this3 = this;

        this.$selectedRows = {};
        return this.$getDataFromRpc().then(function (rows) {
          _this3.$setFilterStatus(dialog);

          return _this3.$buildTable(dialog, _this3.$getTableModel(rows));
        });
      }
      /**
       * Creates the table element that the readers will be displayed in.
       *
       * @private
       * @param {module:dialogs~Dialog} dialog
       * @param {module:nmodule/webEditors/rc/wb/table/model/TableModel} table
       * @returns {Promise}
       */

    }, {
      key: "$buildTable",
      value: function $buildTable(dialog, table) {
        var _this4 = this;

        this.$tableModel = table;
        var selection = new ListSelection();
        var tableDom = $("<table class='ux-table'></table>");
        selection.on('changed', function () {
          tableDom.find(".ux-table-row").each(function (index, element) {
            var subject = table.getRows()[index].getSubject();
            var slotPath = subject.slotPath;

            if (selection.isSelected(index)) {
              _this4.$selectedRows[slotPath] = subject;
            } else {
              delete _this4.$selectedRows[slotPath];
            }
          });
        });
        dialog.content().append(tableDom);
        return fe.buildFor({
          dom: dialog.jq().find(".ux-table"),
          type: Table,
          value: table,
          selection: selection
        });
      }
      /**
       * @private
       * @param {Array<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
       * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel}
       */

    }, {
      key: "$getTableModel",
      value: function $getTableModel(rows) {
        var columns;

        if (this.$deviceName === 'reader') {
          columns = [this.$getColumn('readerName', 'displayName', lex.get('readerChooserTable.header.readerName')), this.$getColumn('assignment', 'assignment', lex.get('readerChooserTable.header.assignment')), this.$getColumn('stationName', 'stationName', lex.get('readerChooserTable.header.stationName'))];
        } else {
          columns = [this.$getColumn('displayName', 'displayName', lex.get('cameraChooserTable.header.displayName')), this.$getColumn('slotPath', 'slotPath', lex.get('cameraChooserTable.header.slotPath'))];
        }

        return new TableModel({
          rows: rows,
          columns: columns
        });
      }
      /**
       * @private
       * @param {string} colName
       * @param {string} subjectProperty
       * @param {string} displayName
       * @returns {module:nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn}
       */

    }, {
      key: "$getColumn",
      value: function $getColumn(colName, subjectProperty, displayName) {
        var column = new JsonObjectPropertyColumn(colName, {
          displayName: displayName
        });

        column.buildCell = function (row, dom) {
          return Promise.resolve(dom.text(row.getSubject()[subjectProperty]));
        };

        column.setSortable(false);
        return column;
      }
      /**
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$getDataFromRpc",
      value: function $getDataFromRpc() {
        var rows = [];
        var unescape = baja.SlotPath.unescape;
        var encodedFilterSet = "";
        var tableFilter;

        if (tableFilter = this.$filterMap[this.$deviceName]) {
          encodedFilterSet = JSON.stringify(baja.bson.encodeValue(tableFilter.getFilterSet()));
        }

        if (this.$deviceName === 'reader') {
          return photoIdRpc.getReaders(this.value().getNavOrd(), encodedFilterSet).then(function (deviceArray) {
            deviceArray.forEach(function (device) {
              var tokenDevice = device.split("|");
              var displayName = unescape(tokenDevice[0]);
              var assignment = unescape(tokenDevice[1]);
              var stationName = unescape(tokenDevice[2]); // This will not be a slotPath but a UUID. For the convenience of map making this is named as slotPath.

              var slotPath = unescape(tokenDevice[3]);
              rows.push(new Row({
                displayName: displayName,
                assignment: assignment,
                stationName: stationName,
                slotPath: slotPath
              }));
            });
            return rows;
          });
        } else {
          return photoIdRpc.getCameras(this.value().getNavOrd(), encodedFilterSet).then(function (deviceArray) {
            deviceArray.forEach(function (device) {
              var tokenDevice = device.split("|");
              var displayName = unescape(tokenDevice[0]);
              var slotPath = unescape(tokenDevice[1]);
              rows.push(new Row({
                displayName: displayName,
                slotPath: slotPath
              }));
            });
            return rows;
          });
        }
      }
      /**
       * @private
       * @returns{JQuery}
       */

    }, {
      key: "$getReaderElement",
      value: function $getReaderElement() {
        return this.jq().find(".readerCommand");
      }
      /**
       * @private
       * @returns{module:bajaux/Widget}
       */

    }, {
      key: "$getReaderButton",
      value: function $getReaderButton() {
        return Widget["in"](this.$getReaderElement());
      }
      /**
       * @private
       * @returns{JQuery}
       */

    }, {
      key: "$getCameraElement",
      value: function $getCameraElement() {
        return this.jq().find(".cameraCommand");
      }
      /**
       * @private
       * @returns{module:bajaux/Widget}
       */

    }, {
      key: "$getCameraButton",
      value: function $getCameraButton() {
        return Widget["in"](this.$getCameraElement());
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('ButtonsPane');
        return Promise.all([this.getChildWidgets().destroyAll()]);
      }
    }]);

    return ButtonsPane;
  }(BaseWidget);

  return ButtonsPane;
});
