/*
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Jayashree Madanala
 */
define(['Promise', 'bajaux/commands/Command', 'nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn', 'dialogs'], function (Promise, Command, alarmConsoleCommandMixIn, dialogs) {
  'use strict';

  var ShowLiveCommand = function ShowLiveCommand(view) {
    this.$view = view;
    Command.apply(this, [{
      module: 'entsecHx',
      lex: 'commands.showLive',
      func: function func() {
        var consoleRecipientName = this.$view.value().getName(); // eslint-disable-next-line no-undef

        window.niagara.env.hyperlink("station:|slot:/Services/AlarmService/" + consoleRecipientName + "|view:entsecHx:LiveSecAlarmConsoleView");
      },
      enabled: true
    }]);
    this.$showInMenu = true;
  };
  /**
   * Shows a video from the alarm console.
   *
   * See the alarm console mixin for the extra methods one can override for the alarm console.
   *
   * @param {module:nmodule/alarm/rc/console/AlarmConsole} view The Alarm Console Widget.
   * @mixes {module:nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn}
   */


  var ShowVideoCommand = function ShowVideoCommand(view) {
    this.$view = view;
    Command.apply(this, [{
      module: 'entsecHx',
      lex: 'commands.showVideo',
      func: function func() {
        var alarmUuid = this.$view.getSelectedAlarmRecords()[0].uuid;
        var consoleRecipient = this.$view.value();
        var width = "600";
        var height = "600"; // eslint-disable-next-line no-unused-vars

        var specs = "resizable=yes, " + "location=no, " + "scrollbars=yes, " + "status=no, " + "toolbar=no"; // eslint-disable-next-line no-undef

        window.open("ord?station:|" + consoleRecipient.getSlotPath() + "|view:entsecHx:HxVideoReviewView?uuid=" + alarmUuid + ";width=" + width + ";height=" + height + ",'reviewVideo','width=" + width + ",height=" + height);
      },
      enabled: false // The command is disabled by default.

    }]);
    alarmConsoleCommandMixIn(this); // If more control is needed over when a command is shown in a right click menu
    // or in the command bar then override the 'showInMenu' and 'showInCommandBar' methods
    // as shown in the alarmConsoleCommandMixIn mixin.

    this.$showInMenu = true;
    this.$showInCommandBar = true;
  };

  ShowVideoCommand.prototype = Object.create(Command.prototype);
  ShowVideoCommand.prototype.constructor = ShowVideoCommand;
  /**
   * Invoked when the alarm console selection changes.
   */

  ShowVideoCommand.prototype.selectionChanged = function () {
    // Only enable the command if some rows are selected.
    if (this.$view.isSelectionEmpty()) {
      this.setEnabled(false);
    } else if (this.$view.getSelectedAlarmRecords().length > 1) {
      this.setEnabled(false);
    } else {
      var cameraHandleOrd = this.$view.getSelectedAlarmRecords()[0].alarmData.cameraHandleOrd;
      var cameraOrd = this.$view.getSelectedAlarmRecords()[0].alarmData.cameraOrd;

      if (cameraHandleOrd == null && cameraOrd == null) {
        this.setEnabled(false);
      } else {
        this.setEnabled(true);
      }
    }
  };

  ShowLiveCommand.prototype = Object.create(Command.prototype);
  ShowLiveCommand.prototype.constructor = ShowLiveCommand;
  return function decorate(view, params) {
    if (view.$moduleName.moduleName === "entsecHx") {
      var group = view.getCommandGroup();
      group.add(new ShowVideoCommand(view));
      group.add(new ShowLiveCommand(view));
    }
  };
});
